/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.loaderv2.NiftyLoader;
import de.lessvoid.nifty.loaderv2.types.ControlDefinitionType;
import de.lessvoid.nifty.loaderv2.types.PopupType;
import de.lessvoid.nifty.loaderv2.types.RegisterEffectType;
import de.lessvoid.nifty.loaderv2.types.RegisterMouseCursorType;
import de.lessvoid.nifty.loaderv2.types.RegisterMusicType;
import de.lessvoid.nifty.loaderv2.types.RegisterSoundType;
import de.lessvoid.nifty.loaderv2.types.ResourceBundleType;
import de.lessvoid.nifty.loaderv2.types.ScreenType;
import de.lessvoid.nifty.loaderv2.types.StyleType;
import de.lessvoid.nifty.loaderv2.types.UseControlsType;
import de.lessvoid.nifty.loaderv2.types.UseStylesType;
import de.lessvoid.nifty.loaderv2.types.XmlBaseType;
import de.lessvoid.nifty.loaderv2.types.helper.CollectionLogger;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.tools.StopWatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public class NiftyType
extends XmlBaseType {
    private static Logger log = Logger.getLogger(NiftyType.class.getName());
    private Collection<StyleType> styles = new ArrayList<StyleType>();
    private Collection<UseStylesType> useStyles = new ArrayList<UseStylesType>();
    private Collection<UseControlsType> useControls = new ArrayList<UseControlsType>();
    private Collection<RegisterSoundType> registeredSounds = new ArrayList<RegisterSoundType>();
    private Collection<RegisterMusicType> registeredMusic = new ArrayList<RegisterMusicType>();
    private Collection<RegisterMouseCursorType> registeredMouseCursor = new ArrayList<RegisterMouseCursorType>();
    private Collection<RegisterEffectType> registeredEffect = new ArrayList<RegisterEffectType>();
    private Collection<ResourceBundleType> resourceBundles = new ArrayList<ResourceBundleType>();
    private Collection<PopupType> popups = new ArrayList<PopupType>();
    private Collection<ControlDefinitionType> controlDefinitions = new ArrayList<ControlDefinitionType>();
    private Collection<ScreenType> screens = new ArrayList<ScreenType>();

    public void addStyle(StyleType newStyle) {
        this.styles.add(newStyle);
    }

    public void addUseStyles(UseStylesType newStyle) {
        this.useStyles.add(newStyle);
    }

    public void addUseControls(UseControlsType useControl) {
        this.useControls.add(useControl);
    }

    public void addRegisterSound(RegisterSoundType registerSound) {
        this.registeredSounds.add(registerSound);
    }

    public void addRegisterMusic(RegisterMusicType registerMusic) {
        this.registeredMusic.add(registerMusic);
    }

    public void addRegisterMouseCursor(RegisterMouseCursorType registerMouseCursor) {
        this.registeredMouseCursor.add(registerMouseCursor);
    }

    public void addResourceBundle(ResourceBundleType resourceBundle) {
        this.resourceBundles.add(resourceBundle);
    }

    public void addRegisterEffect(RegisterEffectType registerEffect) {
        this.registeredEffect.add(registerEffect);
    }

    public void addPopup(PopupType popupType) {
        this.popups.add(popupType);
    }

    public void addControlDefinition(ControlDefinitionType controlDefinition) {
        this.controlDefinitions.add(controlDefinition);
    }

    public void addScreen(ScreenType screenType) {
        this.screens.add(screenType);
    }

    public void create(Nifty nifty, TimeProvider timeProvider) {
        StopWatch stopWatch = new StopWatch(timeProvider);
        stopWatch.start();
        log.fine("debug out [" + stopWatch.stop() + "]");
        stopWatch.start();
        for (ResourceBundleType resourceBundle : this.resourceBundles) {
            resourceBundle.translateSpecialValues(nifty, null);
            resourceBundle.materialize(nifty);
        }
        log.fine("resourceBundles [" + stopWatch.stop() + "]");
        stopWatch.start();
        for (StyleType style : this.styles) {
            style.translateSpecialValues(nifty, null);
            nifty.registerStyle(style);
        }
        log.fine("registerStyle [" + stopWatch.stop() + "]");
        stopWatch.start();
        for (ControlDefinitionType controlDefintion : this.controlDefinitions) {
            controlDefintion.translateSpecialValues(nifty, null);
            controlDefintion.makeFlat();
            nifty.registerControlDefintion(controlDefintion);
        }
        log.fine("registerControlDefinition [" + stopWatch.stop() + "]");
        stopWatch.start();
        for (RegisterEffectType registerEffectType : this.registeredEffect) {
            registerEffectType.translateSpecialValues(nifty, null);
            nifty.registerEffect(registerEffectType);
        }
        log.fine("registerEffect [" + stopWatch.stop() + "]");
        stopWatch.start();
        for (RegisterSoundType registerSoundType : this.registeredSounds) {
            registerSoundType.translateSpecialValues(nifty, null);
            registerSoundType.materialize(nifty.getSoundSystem());
        }
        log.fine("registerSound [" + stopWatch.stop() + "]");
        stopWatch.start();
        for (RegisterMusicType registerMusicType : this.registeredMusic) {
            registerMusicType.translateSpecialValues(nifty, null);
            registerMusicType.materialize(nifty.getSoundSystem());
        }
        log.fine("registerMusic [" + stopWatch.stop() + "]");
        stopWatch.start();
        for (RegisterMouseCursorType registerMouseCursorType : this.registeredMouseCursor) {
            registerMouseCursorType.translateSpecialValues(nifty, null);
            registerMouseCursorType.materialize(nifty, log);
        }
        log.fine("registerMouseCursor [" + stopWatch.stop() + "]");
        stopWatch.start();
        for (PopupType popup : this.popups) {
            popup.translateSpecialValues(nifty, null);
            nifty.registerPopup(popup);
        }
        log.fine("registerPopup [" + stopWatch.stop() + "]");
        stopWatch.start();
        for (ScreenType screen : this.screens) {
            screen.translateSpecialValues(nifty, null);
            screen.create(nifty, this, timeProvider);
        }
        log.fine("create Screens [" + stopWatch.stop() + "]");
    }

    public void loadStyles(NiftyLoader niftyLoader, Nifty nifty) throws Exception {
        for (UseStylesType useStyle : this.useStyles) {
            useStyle.loadStyle(niftyLoader, this, nifty);
        }
    }

    public void loadControls(NiftyLoader niftyLoader) throws Exception {
        for (UseControlsType useControl : this.useControls) {
            useControl.loadControl(niftyLoader, this);
        }
    }

    public String output() {
        int offset = 1;
        return "\nNifty Data:\n" + CollectionLogger.out(offset, this.styles, "styles") + "\n" + CollectionLogger.out(offset, this.useStyles, "useStyles") + "\n" + CollectionLogger.out(offset, this.useControls, "useControls") + "\n" + CollectionLogger.out(offset, this.registeredSounds, "registerSounds") + "\n" + CollectionLogger.out(offset, this.registeredMusic, "registeredMusic") + "\n" + CollectionLogger.out(offset, this.registeredEffect, "registeredEffect") + "\n" + CollectionLogger.out(offset, this.popups, "popups") + "\n" + CollectionLogger.out(offset, this.controlDefinitions, "controlDefinitions") + "\n" + CollectionLogger.out(offset, this.screens, "screens");
    }
}

