/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.textfield.filter.input;

import de.lessvoid.nifty.controls.textfield.filter.input.TextFieldInputCharFilter;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class FilterAcceptFloat
implements TextFieldInputCharFilter {
    private final char minusChar;
    private final char decimalSeparator;

    public FilterAcceptFloat() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());
        this.minusChar = symbols.getMinusSign();
        this.decimalSeparator = symbols.getDecimalSeparator();
    }

    @Override
    public boolean acceptInput(int index, char newChar) {
        if (Character.isDigit(newChar)) {
            return true;
        }
        if (newChar == this.minusChar && index == 0) {
            return true;
        }
        return newChar == this.decimalSeparator;
    }
}

