/*
 * Decompiled with CFR 0.152.
 */
package jme.controller;

import jme.controller.EntityController;
import jme.controller.KeyboardController;
import jme.controller.MouseController;
import jme.entity.Entity;
import jme.math.Vector;
import jme.system.KeyBindingManager;
import org.lwjgl.Display;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class AbstractGameController
implements KeyboardController,
MouseController,
EntityController {
    private int x;
    private int y;
    private int absX;
    private int absY;
    protected Entity entity;

    public void pollMouse() {
        Mouse.poll();
        if (Mouse.dx != 0 || Mouse.dy != 0) {
            this.x += Mouse.dx;
            this.y += Mouse.dy;
            if (this.x < 0) {
                this.absX = this.x;
                this.x = 0;
            } else if (this.x >= Display.getWidth()) {
                this.absX = this.x - Display.getWidth();
                this.x = Display.getWidth() - 1;
            }
            if (this.y < 0) {
                this.absY = this.y;
                this.y = 0;
            } else if (this.y >= Display.getHeight()) {
                this.absY = this.y - Display.getWidth();
                this.y = Display.getHeight() - 1;
            }
        }
    }

    public void pollKeyboard() {
        Keyboard.poll();
    }

    public boolean isKeyDown(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        return KeyBindingManager.getKeyBindingManager().isValidCommand((String)object);
    }

    public void setBuffered() {
        Keyboard.enableBuffer();
    }

    public int next() {
        Keyboard.next();
        return Keyboard.key;
    }

    public int getMousePositionX() {
        return this.x;
    }

    public int getMousePositionY() {
        return this.y;
    }

    public int getAbsoluteMousePositionX() {
        return this.absX;
    }

    public int getAbsoluteMousePositionY() {
        return this.absY;
    }

    public int getMouseDeltaX() {
        return Mouse.dx;
    }

    public int getMouseDeltaY() {
        return Mouse.dy;
    }

    public void setMousePosition(int n, int n2) {
        this.x = Math.min(Math.max(0, n), Display.getWidth() - 1);
        this.y = Math.min(Math.max(0, n2), Display.getHeight() - 1);
    }

    public int getNumberOfButtons() {
        return Mouse.buttonCount;
    }

    public boolean isButtonDown(int n) {
        return Mouse.isButtonDown((int)n);
    }

    public void setEntityPosition(Vector vector) {
        this.entity.setPosition(vector);
    }

    public void setEntityYaw(float f) {
        this.entity.setYaw(f);
    }

    public void setEntityRoll(float f) {
        this.entity.setRoll(f);
    }

    public void setEntityPitch(float f) {
        this.entity.setPitch(f);
    }

    public Vector getEntityPosition() {
        return this.entity.getPosition();
    }

    public abstract void render();

    public abstract boolean update(float var1);
}

