/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.primitive;

import jme.exception.MonkeyRuntimeException;
import jme.geometry.primitive.Primitive;
import jme.math.Vector;
import jme.texture.TextureManager;
import org.lwjgl.opengl.GL;

public class Quad
extends Primitive {
    private GL gl;
    Vector[] points;

    public Quad(Vector[] vectorArray) {
        if (null == vectorArray) {
            throw new MonkeyRuntimeException("Points cannot be null.");
        }
        this.points = vectorArray;
        this.initialize();
    }

    public void setPoints(Vector[] vectorArray) {
        if (null == vectorArray) {
            throw new MonkeyRuntimeException("Points cannot be null.");
        }
        this.points = vectorArray;
        this.initialize();
    }

    public void setPoint(int n, Vector vector) {
        this.points[n] = vector;
        this.initialize();
    }

    public void render() {
        if (this.getTextureId() > 0) {
            GL.glEnable((int)3553);
            TextureManager.getTextureManager().bind(this.getTextureId());
        }
        GL.glBegin((int)7);
        GL.glColor4f((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
        GL.glTexCoord2f((float)1.0f, (float)1.0f);
        GL.glVertex3f((float)this.points[0].x, (float)this.points[0].y, (float)this.points[0].z);
        GL.glTexCoord2f((float)0.0f, (float)1.0f);
        GL.glVertex3f((float)this.points[1].x, (float)this.points[1].y, (float)this.points[1].z);
        GL.glTexCoord2f((float)0.0f, (float)0.0f);
        GL.glVertex3f((float)this.points[2].x, (float)this.points[2].y, (float)this.points[2].z);
        GL.glTexCoord2f((float)1.0f, (float)0.0f);
        GL.glVertex3f((float)this.points[3].x, (float)this.points[3].y, (float)this.points[3].z);
        GL.glEnd();
        if (this.getTextureId() > 0) {
            GL.glDisable((int)3553);
        }
    }

    public void initialize() {
        float f = 0.0f;
        for (int i = 0; i < 4; ++i) {
            float f2 = (float)Math.sqrt(this.points[i].x * this.points[i].x + this.points[i].y * this.points[i].y + this.points[i].z * this.points[i].z);
            if (!(f2 > f)) continue;
            f = f2;
        }
    }

    public void preRender() {
    }

    public Vector[] getPoints() {
        return this.points;
    }
}

