/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.primitive;

import java.util.logging.Level;
import jme.exception.MonkeyRuntimeException;
import jme.geometry.primitive.Quadric;
import jme.math.Vector;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GLU;

public class Sphere
extends Quadric {
    private double radius;
    private int slices;
    private int stacks;
    private GLU glu;

    public Sphere(double d, int n, int n2) {
        if (d <= 0.0 || n <= 0 || n2 <= 0) {
            throw new MonkeyRuntimeException("No sphere parameters may be less than or equal to zero.");
        }
        this.radius = d;
        this.slices = n;
        this.stacks = n2;
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Sphere created.");
    }

    public void render() {
        super.preRender();
        super.clean();
    }

    public void setRadius(double d) {
        if (d <= 0.0) {
            throw new MonkeyRuntimeException("Radius must be greater than zero");
        }
        this.radius = d;
    }

    public void setSlices(int n) {
        if (n <= 0) {
            throw new MonkeyRuntimeException("Number of slices must be greater than zero");
        }
        this.slices = n;
    }

    public void setStacks(int n) {
        if (n <= 0) {
            throw new MonkeyRuntimeException("Number of stacks must be greater than zero");
        }
        this.stacks = n;
    }

    public Vector[] getPoints() {
        return null;
    }
}

