/*
 * Decompiled with CFR 0.152.
 */
package jme.lighting;

import jme.exception.MonkeyRuntimeException;
import jme.lighting.AbstractLightMap;
import jme.locale.external.data.AbstractHeightMap;
import jme.math.Vector;

public class SlopeLighting
extends AbstractLightMap {
    private int softness;
    private float maxBright;
    private float minBright;
    private int dirZ;
    private int dirX;
    private AbstractHeightMap heightMap;

    public SlopeLighting(AbstractHeightMap abstractHeightMap, int n, int n2, float f, float f2, int n3) {
        if (null == abstractHeightMap) {
            throw new MonkeyRuntimeException("Heightmap cannot be null");
        }
        if (n != 1 && n != -1 || n2 != 1 && n2 != -1) {
            throw new MonkeyRuntimeException("Directions must be 1 or -1");
        }
        if (f2 < 0.0f || f2 > 1.0f || f < 0.0f || f > 1.0f) {
            throw new MonkeyRuntimeException("Brightness values must be between 0 and 1");
        }
        this.dirX = n;
        this.dirZ = n2;
        this.minBright = f;
        this.maxBright = f2;
        this.softness = n3;
        this.heightMap = abstractHeightMap;
        this.color = new Vector(1.0f, 1.0f, 1.0f);
        this.createLighting();
    }

    public void createLighting() {
        int n = this.heightMap.getSize();
        this.lightMap = new float[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                float f;
                if (j >= this.dirX && i >= this.dirZ && j - this.dirX < n && i - this.dirZ < n) {
                    f = 1.0f - ((float)this.heightMap.getTrueHeightAtPoint(j - this.dirX, i - this.dirZ) - (float)this.heightMap.getTrueHeightAtPoint(j, i)) / (float)this.softness;
                    if (f > this.maxBright) {
                        f = this.maxBright;
                    } else if (f < this.minBright) {
                        f = this.minBright;
                    }
                } else {
                    f = this.maxBright;
                }
                this.lightMap[j][i] = f;
            }
        }
    }

    public void setDirX(int n) {
        if (n != 1 && n != -1) {
            throw new MonkeyRuntimeException("Direction must be either 1 or -1");
        }
        this.dirX = n;
    }

    public void setDirZ(int n) {
        if (n != 1 && n != -1) {
            throw new MonkeyRuntimeException("Direction must be either 1 or -1");
        }
        this.dirZ = n;
    }

    public void setMaxBright(float f) {
        if (f > 1.0f || f < 0.0f) {
            throw new MonkeyRuntimeException("Brightness value must be between 0 and 1");
        }
        this.maxBright = f;
    }

    public void setMinBright(float f) {
        if (f > 1.0f || f < 0.0f) {
            throw new MonkeyRuntimeException("Brightness value must be between 0 and 1");
        }
        this.minBright = f;
    }

    public void setSoftness(int n) {
        this.softness = n;
    }

    public void setHeightMap(AbstractHeightMap abstractHeightMap) {
        if (null == abstractHeightMap) {
            throw new MonkeyRuntimeException("The height map cannot be null");
        }
        this.heightMap = abstractHeightMap;
    }
}

