/*
 * Decompiled with CFR 0.152.
 */
package jme.locale.external;

import java.util.logging.Level;
import jme.entity.camera.Camera;
import jme.exception.MonkeyRuntimeException;
import jme.locale.external.Terrain;
import jme.locale.external.data.AbstractHeightMap;
import jme.texture.TextureManager;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;

public class Geomipmap
extends Terrain {
    private Camera camera;
    private int patchSize;
    private int numPatchesPerSide;
    private Patch[] patches;
    private int maxLOD;
    private float minDistance = 50.0f;
    private int patchesRendered = 0;

    public Geomipmap(AbstractHeightMap abstractHeightMap, int n, Camera camera) {
        int n2;
        if (n <= 0) {
            throw new MonkeyRuntimeException("patchSize must be greater than 0.");
        }
        this.heightData = abstractHeightMap;
        this.terrainSize = this.heightData.getSize();
        this.patchSize = n;
        this.camera = camera;
        this.numPatchesPerSide = this.terrainSize / n;
        this.patches = new Patch[this.numPatchesPerSide * this.numPatchesPerSide];
        for (n2 = 0; n2 < this.patches.length; ++n2) {
            this.patches[n2] = new Patch();
        }
        n2 = n - 1;
        int n3 = 0;
        while (n2 > 2) {
            n2 >>= 1;
            ++n3;
        }
        this.maxLOD = n3;
        for (int i = 0; i < this.numPatchesPerSide; ++i) {
            for (int j = 0; j < this.numPatchesPerSide; ++j) {
                this.patches[this.getPatchNumber((int)j, (int)i)].LOD = this.maxLOD;
                this.patches[this.getPatchNumber((int)j, (int)i)].isVisible = true;
            }
        }
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created Geomipmap terrain system.");
    }

    public int getNumPatches() {
        return this.numPatchesPerSide * this.numPatchesPerSide;
    }

    public int getNumPatchesRendered() {
        return this.patchesRendered;
    }

    public void update(float f) {
        for (int i = 0; i < this.numPatchesPerSide; ++i) {
            for (int j = 0; j < this.numPatchesPerSide; ++j) {
                int n = this.getPatchNumber(j, i);
                float f2 = (float)(j * this.patchSize) + (float)this.patchSize / 2.0f;
                float f3 = this.heightData.getScaledHeightAtPoint(j, i);
                float f4 = (float)(i * this.patchSize) + (float)this.patchSize / 2.0f;
                this.patches[n].isVisible = this.camera.getFrustum().containsSphere(f2 *= this.xScale, f3, f4 *= this.zScale, (float)this.patchSize * this.xScale);
                if (!this.patches[n].isVisible && !this.camera.hasMoved()) continue;
                this.patches[n].distance = (float)Math.sqrt((f2 - this.camera.getPosition().x) * (f2 - this.camera.getPosition().x) + (f3 - this.camera.getPosition().y) * (f3 - this.camera.getPosition().y) + (f4 - this.camera.getPosition().z) * (f4 - this.camera.getPosition().z));
                this.patches[n].LOD = this.distanceToLOD(this.patches[n].distance);
            }
        }
    }

    public void render() {
        GL.glActiveTextureARB((int)33984);
        GL.glEnable((int)3553);
        GL.glEnable((int)2929);
        if (this.useDistanceFog || this.useVolumeFog) {
            GL.glEnable((int)2912);
        }
        TextureManager.getTextureManager().bind(this.terrainTexture);
        if (this.isDetailed) {
            GL.glActiveTextureARB((int)33985);
            GL.glEnable((int)3553);
            TextureManager.getTextureManager().bind(this.detailId);
            GL.glTexEnvi((int)8960, (int)8704, (int)34160);
            GL.glTexEnvi((int)8960, (int)34163, (int)2);
        }
        this.patchesRendered = 0;
        for (int i = 0; i < this.numPatchesPerSide; ++i) {
            for (int j = 0; j < this.numPatchesPerSide; ++j) {
                if (!this.patches[this.getPatchNumber((int)j, (int)i)].isVisible) continue;
                ++this.patchesRendered;
                this.renderPatch(j, i);
            }
        }
        GL.glActiveTextureARB((int)33985);
        GL.glDisable((int)3553);
        GL.glBindTexture((int)3553, (int)0);
        GL.glActiveTextureARB((int)33984);
        GL.glDisable((int)3553);
        GL.glBindTexture((int)3553, (int)0);
        GL.glDisable((int)2929);
        if (this.useDistanceFog || this.useVolumeFog) {
            GL.glDisable((int)2912);
        }
    }

    public void setMinimumDistance(float f) {
        this.minDistance = f;
    }

    private void renderVertex(float f, float f2, float f3, float f4) {
        float f5 = 1.0f;
        float f6 = 1.0f;
        float f7 = 1.0f;
        if (this.isLit) {
            float f8 = this.lightMap.getShade((int)f, (int)f2);
            f5 = f8 * this.lightMap.getColor().x;
            f6 = f8 * this.lightMap.getColor().y;
            f7 = f8 * this.lightMap.getColor().z;
        } else {
            f5 = 1.0f;
            f6 = 1.0f;
            f7 = 1.0f;
        }
        GL.glColor3f((float)f5, (float)f6, (float)f7);
        GL.glMultiTexCoord2fARB((int)33984, (float)f3, (float)f4);
        if (this.isDetailed) {
            GL.glMultiTexCoord2fARB((int)33985, (float)(f3 * (float)this.repeatDetailMap), (float)(f4 * (float)this.repeatDetailMap));
        }
        if (this.useVolumeFog) {
            this.setVolumetricFogCoord(this.heightData.getScaledHeightAtPoint((int)f, (int)f2));
        }
        GL.glVertex3f((float)(f * this.xScale), (float)this.heightData.getScaledHeightAtPoint((int)f, (int)f2), (float)(f2 * this.zScale));
    }

    private void renderFan(float f, float f2, float f3, Neighbor neighbor) {
        float f4 = f3 / 2.0f;
        float f5 = Math.abs(f - f4) / (float)this.terrainSize;
        float f6 = Math.abs(f2 - f4) / (float)this.terrainSize;
        float f7 = Math.abs(f + f4) / (float)this.terrainSize;
        float f8 = Math.abs(f2 + f4) / (float)this.terrainSize;
        float f9 = (f5 + f7) / 2.0f;
        float f10 = (f6 + f8) / 2.0f;
        GL.glBegin((int)6);
        this.renderVertex(f, f2, f9, f10);
        this.renderVertex(f - f4, f2 - f4, f5, f6);
        if (neighbor.left) {
            this.renderVertex(f - f4, f2, f5, f10);
        }
        this.renderVertex(f - f4, f2 + f4, f5, f8);
        if (neighbor.up) {
            this.renderVertex(f, f2 + f4, f9, f8);
        }
        this.renderVertex(f + f4, f2 + f4, f7, f8);
        if (neighbor.right) {
            this.renderVertex(f + f4, f2, f7, f10);
        }
        this.renderVertex(f + f4, f2 - f4, f7, f6);
        if (neighbor.down) {
            this.renderVertex(f, f2 - f4, f9, f6);
        }
        this.renderVertex(f - f4, f2 - f4, f5, f6);
        GL.glEnd();
    }

    private void renderPatch(int n, int n2) {
        float f;
        Neighbor neighbor = new Neighbor();
        Neighbor neighbor2 = new Neighbor();
        int n3 = this.getPatchNumber(n, n2);
        neighbor.left = n == 0 ? true : this.patches[this.getPatchNumber((int)(n - 1), (int)n2)].LOD <= this.patches[n3].LOD;
        neighbor.up = n2 == this.numPatchesPerSide - 1 ? true : this.patches[this.getPatchNumber((int)n, (int)(n2 + 1))].LOD <= this.patches[n3].LOD;
        neighbor.right = n == this.numPatchesPerSide - 1 ? true : this.patches[this.getPatchNumber((int)(n + 1), (int)n2)].LOD <= this.patches[n3].LOD;
        neighbor.down = n2 == 0 ? true : this.patches[this.getPatchNumber((int)n, (int)(n2 - 1))].LOD <= this.patches[n3].LOD;
        float f2 = this.patchSize;
        int n4 = this.patchSize - 1;
        int n5 = this.patches[n3].LOD;
        while (n5-- >= 0) {
            n4 >>= 1;
        }
        float f3 = f = (f2 /= (float)n4) / 2.0f;
        while ((float)((int)f3) + f < (float)(this.patchSize + 1)) {
            float f4 = f;
            while ((float)((int)f4) + f < (float)(this.patchSize + 1)) {
                neighbor2.left = f4 == f ? neighbor.left : true;
                neighbor2.down = f3 == f ? neighbor.down : true;
                neighbor2.right = f4 >= (float)this.patchSize - f ? neighbor.right : true;
                neighbor2.up = f3 >= (float)this.patchSize - f ? neighbor.up : true;
                this.renderFan((float)(n * this.patchSize) + f4, (float)(n2 * this.patchSize) + f3, f2, neighbor2);
                f4 += f2;
            }
            f3 += f2;
        }
    }

    private int distanceToLOD(float f) {
        float f2 = this.minDistance;
        for (int i = 0; i < this.maxLOD; ++i) {
            if (f < f2) {
                return i;
            }
            f2 = (float)((double)f2 * 2.5);
        }
        return this.maxLOD;
    }

    private int getPatchNumber(int n, int n2) {
        return n2 * this.numPatchesPerSide + n;
    }

    private class Neighbor {
        public boolean left;
        public boolean right;
        public boolean up;
        public boolean down;

        private Neighbor() {
        }
    }

    private class Patch {
        public float distance;
        public int LOD;
        public boolean isVisible;

        private Patch() {
        }
    }
}

