/*
 * Decompiled with CFR 0.152.
 */
package jme.locale.external;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import jme.exception.MonkeyRuntimeException;
import jme.lighting.AbstractLightMap;
import jme.locale.Locale;
import jme.locale.external.data.AbstractHeightMap;
import jme.texture.TextureManager;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCaps;

public abstract class Terrain
implements Locale {
    protected int terrainTexture;
    protected int detailId;
    protected int terrainSize;
    protected boolean isTextured;
    protected boolean isLit;
    protected boolean isDetailed;
    protected int repeatDetailMap;
    protected AbstractLightMap lightMap;
    protected AbstractHeightMap heightData;
    protected GL gl;
    protected float xScale = 1.0f;
    protected float zScale = 1.0f;
    protected boolean useVolumeFog;
    private float fogDepth = 0.0f;
    protected boolean useDistanceFog;

    public void setXScale(float f) {
        this.xScale = f;
    }

    public void setZScale(float f) {
        this.zScale = f;
    }

    public void setFogAttributes(int n, float[] fArray, float f, float f2, float f3) {
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.flip();
        GL.glFogi((int)2917, (int)n);
        GL.glFog((int)2918, (FloatBuffer)floatBuffer);
        GL.glFogf((int)2914, (float)f);
        GL.glFogf((int)2915, (float)f2);
        GL.glFogf((int)2916, (float)f3);
    }

    public boolean useDistanceFog() {
        return this.useDistanceFog;
    }

    public boolean useVolumetricFog() {
        return this.useVolumeFog;
    }

    public void setDistanceFog(boolean bl) {
        this.useDistanceFog = bl;
        if (bl) {
            GL.glEnable((int)2912);
        } else {
            GL.glDisable((int)2912);
        }
    }

    public void setVolumetricFogDepth(float f) {
        this.fogDepth = f;
    }

    public void setVolumetricFog(boolean bl) {
        this.useVolumeFog = bl;
        if (bl) {
            GL.glFogi((int)33872, (int)33873);
            GL.glEnable((int)2912);
        } else {
            GL.glDisable((int)2912);
        }
    }

    protected void setVolumetricFogCoord(float f) {
        if (f > this.fogDepth) {
            GL.glFogCoordfEXT((float)(-(f - this.fogDepth)));
        } else {
            GL.glFogCoordfEXT((float)0.0f);
        }
    }

    public void setDetailTexture(String string, int n) {
        this.repeatDetailMap = n;
        boolean bl = GLCaps.GL_ARB_multitexture;
        if (!bl) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Graphics does not support multitexturing.");
        }
        if (null != string && bl) {
            this.detailId = TextureManager.getTextureManager().loadTexture(string, 9987, 9729, true);
            this.isDetailed = true;
        } else {
            this.isDetailed = false;
        }
    }

    public void setTexture(String string) {
        if (string != null) {
            this.terrainTexture = TextureManager.getTextureManager().loadTexture(string, 9987, 9729, true);
            if (this.terrainTexture != -1) {
                this.isTextured = true;
            }
        } else {
            this.isTextured = false;
        }
    }

    public void setTexture(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.terrainTexture = TextureManager.getTextureManager().loadTexture(imageIcon, 9987, 9729, true);
            if (this.terrainTexture != -1) {
                this.isTextured = true;
            }
        } else {
            this.isTextured = false;
        }
    }

    public void setLightMap(AbstractLightMap abstractLightMap) {
        this.lightMap = abstractLightMap;
        this.isLit = true;
    }

    public void setHeightData(AbstractHeightMap abstractHeightMap) {
        if (null == abstractHeightMap) {
            throw new MonkeyRuntimeException("heightData cannot be null");
        }
        this.heightData = abstractHeightMap;
        this.terrainSize = abstractHeightMap.getSize();
    }

    public abstract void update(float var1);

    public abstract void render();
}

