/*
 * Decompiled with CFR 0.152.
 */
package jme.locale.external.data;

import java.util.logging.Level;
import jme.exception.MonkeyRuntimeException;
import jme.locale.external.data.AbstractHeightMap;
import jme.utility.LoggingSystem;

public class CombinerHeightMap
extends AbstractHeightMap {
    public static final int ADDITION = 0;
    public static final int SUBTRACTION = 1;
    private AbstractHeightMap map1;
    private AbstractHeightMap map2;
    private float factor1 = 0.5f;
    private float factor2 = 0.5f;
    private int mode;

    public CombinerHeightMap(AbstractHeightMap abstractHeightMap, AbstractHeightMap abstractHeightMap2, int n) {
        if (null == abstractHeightMap || null == abstractHeightMap2) {
            throw new MonkeyRuntimeException("Height map may not be null");
        }
        if (abstractHeightMap.getSize() != abstractHeightMap2.getSize()) {
            throw new MonkeyRuntimeException("The two maps must be of the same size");
        }
        if (this.factor1 + this.factor2 != 1.0f) {
            throw new MonkeyRuntimeException("factor1 and factor2 must add to 1.0");
        }
        this.size = abstractHeightMap.getSize();
        this.map1 = abstractHeightMap;
        this.map2 = abstractHeightMap2;
        this.mode = n;
        this.load();
    }

    public CombinerHeightMap(AbstractHeightMap abstractHeightMap, float f, AbstractHeightMap abstractHeightMap2, float f2, int n) {
        if (null == abstractHeightMap || null == abstractHeightMap2) {
            throw new MonkeyRuntimeException("Height map may not be null");
        }
        if (abstractHeightMap.getSize() != abstractHeightMap2.getSize()) {
            throw new MonkeyRuntimeException("The two maps must be of the same size");
        }
        if (f + f2 != 1.0f) {
            throw new MonkeyRuntimeException("factor1 and factor2 must add to 1.0");
        }
        if (n != 0 || n != 1) {
            throw new MonkeyRuntimeException("Invalid mode");
        }
        this.size = abstractHeightMap.getSize();
        this.map1 = abstractHeightMap;
        this.map2 = abstractHeightMap2;
        this.factor1 = f;
        this.factor2 = f2;
        this.mode = n;
        this.load();
    }

    public void setFactors(float f, float f2) {
        if (f + f2 != 1.0f) {
            throw new MonkeyRuntimeException("factor1 and factor2 must add to 1.0");
        }
        this.factor1 = f;
        this.factor2 = f2;
    }

    public void setHeightMaps(AbstractHeightMap abstractHeightMap, AbstractHeightMap abstractHeightMap2) {
        if (null == abstractHeightMap || null == abstractHeightMap2) {
            throw new MonkeyRuntimeException("Height map may not be null");
        }
        if (abstractHeightMap.getSize() != abstractHeightMap2.getSize()) {
            throw new MonkeyRuntimeException("The two maps must be of the same size");
        }
        this.size = abstractHeightMap.getSize();
        this.map1 = abstractHeightMap;
        this.map2 = abstractHeightMap2;
    }

    public void setMode(int n) {
        if (n != 0 || n != 1) {
            throw new MonkeyRuntimeException("Invalid mode");
        }
        this.mode = n;
    }

    public boolean load() {
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new int[this.size][this.size];
        int[][] nArray = this.map1.getHeightMap();
        int[][] nArray2 = this.map2.getHeightMap();
        if (this.mode == 0) {
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    this.heightData[i][j] = (int)((float)nArray[i][j] * this.factor1 + (float)nArray2[i][j] * this.factor2);
                }
            }
        } else if (this.mode == 1) {
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    this.heightData[i][j] = (int)((float)nArray[i][j] * this.factor1 - (float)nArray2[i][j] * this.factor2);
                }
            }
        }
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created heightmap using Combiner");
        return true;
    }
}

