/*
 * Decompiled with CFR 0.152.
 */
package jme.locale.external.data;

import java.util.logging.Level;
import jme.exception.MonkeyRuntimeException;
import jme.locale.external.data.AbstractHeightMap;
import jme.utility.LoggingSystem;

public class FaultFractalHeightMap
extends AbstractHeightMap {
    private int iterations;
    private int minDelta;
    private int maxDelta;

    public FaultFractalHeightMap(int n, int n2, int n3, int n4, float f) {
        if (n <= 0 || n2 <= 0 || n3 > n4 || f < 0.0f || f >= 1.0f) {
            throw new MonkeyRuntimeException("Either size is not greater than zero, iterations is not greater than zero, minDelta is more than maxDelta and/or filter is not between 0 and 1.");
        }
        this.size = n;
        this.iterations = n2;
        this.minDelta = n3;
        this.maxDelta = n4;
        this.filter = f;
        this.load();
    }

    public boolean load() {
        int n;
        int n2;
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new int[this.size][this.size];
        float[][] fArray = new float[this.size][this.size];
        for (n2 = 0; n2 < this.iterations; ++n2) {
            int n3;
            int n4;
            float f = this.maxDelta - (this.maxDelta - this.minDelta) * n2 / this.iterations;
            int n5 = (int)(Math.random() * (double)this.size);
            int n6 = (int)(Math.random() * (double)this.size);
            do {
                n4 = (int)(Math.random() * (double)this.size);
                n3 = (int)(Math.random() * (double)this.size);
            } while (n5 == n4 && n6 == n3);
            int n7 = n4 - n5;
            int n8 = n3 - n6;
            for (n = 0; n < this.size; ++n) {
                for (int i = 0; i < this.size; ++i) {
                    int n9 = n - n5;
                    int n10 = i - n6;
                    if (n9 * n8 - n7 * n10 <= 0) continue;
                    float[] fArray2 = fArray[n];
                    int n11 = i;
                    fArray2[n11] = fArray2[n11] + f;
                }
            }
        }
        this.erodeTerrain(fArray);
        this.normalizeTerrain(fArray);
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                this.setHeightAtPoint((int)fArray[n2][n], n, n2);
            }
        }
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created Heightmap using Fault Fractal");
        return true;
    }

    public void setIterations(int n) {
        if (n <= 0) {
            throw new MonkeyRuntimeException("iterations must be greater than zero");
        }
        this.iterations = n;
    }

    public void setMinDelta(int n) {
        if (n > this.maxDelta) {
            throw new MonkeyRuntimeException("minDelta must be greater than the current maxDelta");
        }
        this.minDelta = n;
    }

    public void setMaxDelta(int n) {
        if (n < this.minDelta) {
            throw new MonkeyRuntimeException("maxDelta must be greater than current minDelta");
        }
        this.maxDelta = n;
    }
}

