/*
 * Decompiled with CFR 0.152.
 */
package jme.locale.external.feature;

import java.util.logging.Level;
import jme.exception.MonkeyGLException;
import jme.geometry.model.Vertex;
import jme.locale.external.feature.Sky;
import jme.texture.TextureManager;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.Window;

public class SkyDome
implements Sky {
    private int texId;
    private float radius;
    private float dLon;
    private float dLat;
    private float hTile;
    private float vTile;
    private float xSpeed;
    private float ySpeed;
    private float xTexAnimation = 0.0f;
    private float yTexAnimation = 0.0f;
    private float rotationSpeed;
    private float rotation;
    private Vertex[] vertices;
    private int numVertices;
    private static final float DTOR = (float)Math.PI / 180;

    public SkyDome(float f, float f2, float f3, float f4, float f5) {
        if (!Window.isCreated()) {
            throw new MonkeyGLException("Window must be created before SkyDome.");
        }
        this.radius = f;
        this.dLon = f2;
        this.dLat = f3;
        this.hTile = f4;
        this.vTile = f5;
        this.generateDome();
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created Skydome.");
    }

    public void setTexture(String string) {
        this.texId = TextureManager.getTextureManager().loadTexture(string, 9987, 9729, true);
    }

    public float getSize() {
        return this.radius / 4.0f;
    }

    public void setTextureSpeed(float f, float f2) {
        this.xSpeed = f / 100.0f;
        this.ySpeed = f2 / 100.0f;
    }

    public void setDomeRotation(float f) {
        this.rotationSpeed = f / 1000.0f;
    }

    public void update(float f) {
        this.xTexAnimation += this.xSpeed * f / 10000.0f;
        this.yTexAnimation += this.ySpeed * f / 10000.0f;
        this.rotation += this.rotationSpeed * f;
        if (this.rotation > 360.0f || this.rotation < 0.0f) {
            this.rotation %= 360.0f;
        }
        if (this.xTexAnimation > this.hTile) {
            this.xTexAnimation %= this.hTile;
        }
        if (this.yTexAnimation > this.vTile) {
            this.yTexAnimation %= this.vTile;
        }
    }

    public void render() {
        GL.glEnable((int)3553);
        GL.glDisable((int)2929);
        GL.glCullFace((int)1028);
        GL.glBindTexture((int)3553, (int)this.texId);
        GL.glPushMatrix();
        GL.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL.glRotatef((float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GL.glBegin((int)5);
        for (int i = 0; i < this.numVertices; ++i) {
            GL.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL.glTexCoord2f((float)(this.vertices[i].u + this.xTexAnimation), (float)(this.vertices[i].v + this.yTexAnimation));
            GL.glVertex3f((float)this.vertices[i].x, (float)this.vertices[i].y, (float)this.vertices[i].z);
        }
        GL.glEnd();
        GL.glPopMatrix();
        GL.glDisable((int)3553);
        GL.glEnable((int)2929);
        GL.glCullFace((int)1029);
    }

    private void generateDome() {
        this.numVertices = (int)(360.0f / this.dLon * (90.0f / this.dLat) * 4.0f);
        this.vertices = new Vertex[this.numVertices];
        for (int i = 0; i < this.numVertices; ++i) {
            this.vertices[i] = new Vertex();
        }
        int n = 0;
        int n2 = 0;
        while ((float)n2 <= 90.0f - this.dLat) {
            int n3 = 0;
            while ((float)n3 <= 360.0f - this.dLon) {
                this.vertices[n].x = this.radius * (float)Math.sin((float)n2 * ((float)Math.PI / 180)) * (float)Math.cos((float)Math.PI / 180 * (float)n3);
                this.vertices[n].y = this.radius * (float)Math.sin((float)n2 * ((float)Math.PI / 180)) * (float)Math.sin((float)Math.PI / 180 * (float)n3);
                this.vertices[n].z = this.radius * (float)Math.cos((float)n2 * ((float)Math.PI / 180));
                float f = this.vertices[n].x;
                float f2 = this.vertices[n].y;
                float f3 = this.vertices[n].z;
                float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
                this.vertices[n].u = this.hTile * (float)(Math.atan2(f /= f4, f3 /= f4) / (Math.PI * 2)) + 0.5f;
                this.vertices[n].v = this.vTile * (float)(Math.asin(f2 /= f4) / Math.PI) + 0.5f;
                this.vertices[++n].x = this.radius * (float)Math.sin(((float)n2 + this.dLat) * ((float)Math.PI / 180)) * (float)Math.cos((float)n3 * ((float)Math.PI / 180));
                this.vertices[n].y = this.radius * (float)Math.sin(((float)n2 + this.dLat) * ((float)Math.PI / 180)) * (float)Math.sin((float)n3 * ((float)Math.PI / 180));
                this.vertices[n].z = this.radius * (float)Math.cos(((float)n2 + this.dLat) * ((float)Math.PI / 180));
                f = this.vertices[n].x;
                f2 = this.vertices[n].y;
                f3 = this.vertices[n].z;
                f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
                this.vertices[n].u = this.hTile * (float)(Math.atan2(f /= f4, f3 /= f4) / (Math.PI * 2)) + 0.5f;
                this.vertices[n].v = this.vTile * (float)(Math.asin(f2 /= f4) / Math.PI) + 0.5f;
                this.vertices[++n].x = this.radius * (float)Math.sin((float)Math.PI / 180 * (float)n2) * (float)Math.cos((float)Math.PI / 180 * ((float)n3 + this.dLon));
                this.vertices[n].y = this.radius * (float)Math.sin((float)Math.PI / 180 * (float)n2) * (float)Math.sin((float)Math.PI / 180 * ((float)n3 + this.dLon));
                this.vertices[n].z = this.radius * (float)Math.cos((float)Math.PI / 180 * (float)n2);
                f = this.vertices[n].x;
                f2 = this.vertices[n].y;
                f3 = this.vertices[n].z;
                f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
                this.vertices[n].u = this.hTile * (float)(Math.atan2(f /= f4, f3 /= f4) / (Math.PI * 2)) + 0.5f;
                this.vertices[n].v = this.vTile * (float)(Math.asin(f2 /= f4) / Math.PI) + 0.5f;
                ++n;
                if (n2 > -90 && n2 < 90) {
                    this.vertices[n].x = this.radius * (float)Math.sin(((float)n2 + this.dLat) * ((float)Math.PI / 180)) * (float)Math.cos((float)Math.PI / 180 * ((float)n3 + this.dLon));
                    this.vertices[n].y = this.radius * (float)Math.sin(((float)n2 + this.dLat) * ((float)Math.PI / 180)) * (float)Math.sin((float)Math.PI / 180 * ((float)n3 + this.dLon));
                    this.vertices[n].z = this.radius * (float)Math.cos(((float)n2 + this.dLat) * ((float)Math.PI / 180));
                    f = this.vertices[n].x;
                    f2 = this.vertices[n].y;
                    f3 = this.vertices[n].z;
                    f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
                    this.vertices[n].u = this.hTile * (float)(Math.atan2(f /= f4, f3 /= f4) / (Math.PI * 2)) + 0.5f;
                    this.vertices[n].v = this.vTile * (float)(Math.asin(f2 /= f4) / Math.PI) + 0.5f;
                    ++n;
                }
                n3 += (int)this.dLon;
            }
            n2 += (int)this.dLat;
        }
        for (n2 = 0; n2 < this.numVertices - 3; ++n2) {
            if (this.vertices[n2].u - this.vertices[n2 + 1].u > 0.9f) {
                this.vertices[n2 + 1].u += 1.0f;
            }
            if (this.vertices[n2 + 1].u - this.vertices[n2].u > 0.9f) {
                this.vertices[n2].u += 1.0f;
            }
            if (this.vertices[n2].u - this.vertices[n2 + 2].u > 0.9f) {
                this.vertices[n2 + 2].u += 1.0f;
            }
            if (this.vertices[n2 + 2].u - this.vertices[n2].u > 0.9f) {
                this.vertices[n2].u += 1.0f;
            }
            if (this.vertices[n2 + 1].u - this.vertices[n2 + 2].u > 0.9f) {
                this.vertices[n2 + 2].u += 1.0f;
            }
            if (this.vertices[n2 + 2].u - this.vertices[n2 + 1].u > 0.9f) {
                this.vertices[n2 + 1].u += 1.0f;
            }
            if (this.vertices[n2].v - this.vertices[n2 + 1].v > 0.8f) {
                this.vertices[n2 + 1].v += 1.0f;
            }
            if (this.vertices[n2 + 1].v - this.vertices[n2].v > 0.8f) {
                this.vertices[n2].v += 1.0f;
            }
            if (this.vertices[n2].v - this.vertices[n2 + 2].v > 0.8f) {
                this.vertices[n2 + 2].v += 1.0f;
            }
            if (this.vertices[n2 + 2].v - this.vertices[n2].v > 0.8f) {
                this.vertices[n2].v += 1.0f;
            }
            if (this.vertices[n2 + 1].v - this.vertices[n2 + 2].v > 0.8f) {
                this.vertices[n2 + 2].v += 1.0f;
            }
            if (!(this.vertices[n2 + 2].v - this.vertices[n2 + 1].v > 0.8f)) continue;
            this.vertices[n2 + 1].v += 1.0f;
        }
    }
}

