/*
 * Decompiled with CFR 0.152.
 */
package jme.locale.external.feature;

import jme.exception.MonkeyRuntimeException;
import jme.locale.external.feature.Water;
import jme.math.Vector;
import jme.texture.TextureManager;
import org.lwjgl.opengl.GL;

public class WaterPlane
implements Water {
    private int texId;
    private float repeat = 16.0f;
    private int size;
    private float baseLevel;
    private float variation;
    private Vector color;
    private float transparency;
    private float currentLevel;
    private float waveSpeed;
    private float xSpeed;
    private float zSpeed;
    private float changeX = 0.0f;
    private float changeZ = 0.0f;

    public WaterPlane(int n, float f, float f2) {
        if (n <= 0) {
            throw new MonkeyRuntimeException("size must be greater than zero.");
        }
        this.size = n;
        this.baseLevel = f;
        this.variation = f2;
    }

    public void setTexture(String string) {
        if (null == string) {
            throw new MonkeyRuntimeException("file name cannot be null.");
        }
        this.texId = TextureManager.getTextureManager().loadTexture(string, 9987, 9729, true);
    }

    public void setTextureAnimation(float f, float f2) {
        this.xSpeed = f;
        this.zSpeed = f2;
    }

    public void setWaveSpeed(float f) {
        this.waveSpeed = f;
    }

    public void setColor(Vector vector) {
        this.color = vector;
    }

    public void setTransparency(float f) {
        this.transparency = f;
    }

    public void setRepeat(float f) {
        this.repeat = f;
    }

    public void update(float f) {
        this.currentLevel += this.waveSpeed * f;
        if (this.currentLevel > this.baseLevel + this.variation) {
            this.currentLevel = this.baseLevel + this.variation;
            this.waveSpeed *= -1.0f;
        } else if (this.currentLevel < this.baseLevel - this.variation) {
            this.currentLevel = this.baseLevel - this.variation;
            this.waveSpeed *= -1.0f;
        }
        this.changeX += this.xSpeed * f / 100.0f;
        this.changeZ += this.zSpeed * f / 100.0f;
        if (this.changeX > this.repeat) {
            this.changeX = 0.0f;
        }
        if (this.changeZ > this.repeat) {
            this.changeZ = 0.0f;
        }
    }

    public void render() {
        GL.glEnable((int)3042);
        GL.glEnable((int)3553);
        GL.glEnable((int)2929);
        GL.glDisable((int)2884);
        GL.glBlendFunc((int)770, (int)1);
        GL.glColor4f((float)this.color.x, (float)this.color.y, (float)this.color.z, (float)this.transparency);
        TextureManager.getTextureManager().bind(this.texId);
        GL.glBegin((int)5);
        GL.glTexCoord2f((float)this.changeX, (float)this.changeZ);
        GL.glVertex3f((float)0.0f, (float)this.currentLevel, (float)0.0f);
        GL.glTexCoord2f((float)(this.changeX + this.repeat), (float)this.changeZ);
        GL.glVertex3f((float)this.size, (float)this.currentLevel, (float)0.0f);
        GL.glTexCoord2f((float)this.changeX, (float)(this.changeZ + this.repeat));
        GL.glVertex3f((float)0.0f, (float)this.currentLevel, (float)this.size);
        GL.glTexCoord2f((float)(this.changeX + this.repeat), (float)(this.changeZ + this.repeat));
        GL.glVertex3f((float)this.size, (float)this.currentLevel, (float)this.size);
        GL.glEnd();
        GL.glDisable((int)3042);
        GL.glDisable((int)3553);
        GL.glDisable((int)2929);
        GL.glEnable((int)2884);
    }
}

