/*
 * Decompiled with CFR 0.152.
 */
package jme.math;

import jme.exception.MonkeyRuntimeException;
import jme.math.Matrix;

public class Vector {
    public float x;
    public float y;
    public float z;

    public Vector() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vector(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vector(float[] fArray) {
        if (fArray.length != 3) {
            throw new MonkeyRuntimeException("Attributes must be length 3.");
        }
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
    }

    public Vector(Vector vector) {
        if (null == vector) {
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
        } else {
            this.x = vector.x;
            this.y = vector.y;
            this.z = vector.z;
        }
    }

    public Vector divide(float f) {
        return new Vector(this.x / f, this.y / f, this.z / f);
    }

    public Vector mult(float f) {
        return new Vector(this.x * f, this.y * f, this.z * f);
    }

    public Vector add(Vector vector) {
        return new Vector(this.x + vector.x, this.y + vector.y, this.z + vector.z);
    }

    public Vector subtract(Vector vector) {
        return new Vector(this.x - vector.x, this.y - vector.y, this.z - vector.z);
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float dot(Vector vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    public Vector cross(Vector vector) {
        return new Vector(this.y * vector.z - this.z * vector.y, this.z * vector.x - this.x * vector.z, this.x * vector.y - this.y * vector.x);
    }

    public Vector rotate(Matrix matrix) {
        Vector vector = new Vector();
        vector.x = this.dot(new Vector(matrix.matrix[0][0], matrix.matrix[0][1], matrix.matrix[0][2]));
        vector.y = this.dot(new Vector(matrix.matrix[1][0], matrix.matrix[1][1], matrix.matrix[1][2]));
        vector.z = this.dot(new Vector(matrix.matrix[2][0], matrix.matrix[2][1], matrix.matrix[2][2]));
        return vector;
    }

    public Vector inverseRotate(Matrix matrix) {
        Vector vector = new Vector();
        vector.x = this.x * matrix.matrix[0][0] + this.y * matrix.matrix[1][0] + this.z * matrix.matrix[2][0];
        vector.y = this.x * matrix.matrix[0][1] + this.y * matrix.matrix[1][1] + this.z * matrix.matrix[2][1];
        vector.z = this.x * matrix.matrix[0][2] + this.y * matrix.matrix[1][2] + this.z * matrix.matrix[2][2];
        return vector;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public Vector normalize() {
        float f = this.length();
        return this.divide(f);
    }

    public void unitize() {
        float f = this.length();
        float f2 = 1.0f / f;
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
    }

    public static void generateOrthonormalBasis(Vector vector, Vector vector2, Vector vector3, boolean bl) {
        if (!bl) {
            vector3.unitize();
        }
        if (Math.abs(vector3.x) >= Math.abs(vector3.y) && Math.abs(vector3.x) >= Math.abs(vector3.z)) {
            vector.x = -vector3.y;
            vector.y = vector3.x;
            vector.z = 0.0f;
        } else {
            vector.x = 0.0f;
            vector.y = vector3.z;
            vector.z = -vector3.y;
        }
        vector.unitize();
        vector2 = vector3.cross(vector);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }
}

