/*
 * Decompiled with CFR 0.152.
 */
package jme.texture;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import jme.exception.MonkeyGLException;
import jme.exception.MonkeyRuntimeException;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLU;
import org.lwjgl.opengl.Window;

public class TextureManager {
    private static TextureManager instance = null;
    private GL gl;
    private GLU glu;
    private HashMap textureList = null;
    private ArrayList keyList = null;
    private ArrayList previousKeys = null;
    private int boundID = -1;
    private static final int NO_TRANSPARENCY = 255;
    private static final int FULL_TRANSPARENCY = 0;
    private static short idLength;
    private static short colorMapType;
    private static short imageType;
    private static int cMapStart;
    private static int cMapLength;
    private static short cMapDepth;
    private static int xOffset;
    private static int yOffset;
    private static int width;
    private static int height;
    private static short pixelDepth;
    private static short imageDescriptor;
    private static DirectColorModel cm;
    private static int[] pixels;

    private TextureManager() {
        if (!Window.isCreated()) {
            throw new MonkeyGLException("Window must be created before TextureManager.");
        }
        this.textureList = new HashMap();
        this.keyList = new ArrayList();
        this.previousKeys = new ArrayList();
    }

    public void reload() {
        this.reload(true);
    }

    public void reload(boolean bl) {
        this.saveKeys();
        this.deleteAll();
        for (int i = 0; i < this.previousKeys.size(); ++i) {
            TextureData textureData = (TextureData)this.previousKeys.get(i);
            if (textureData.name.endsWith(".tga")) {
                this.loadTexture(textureData.name, textureData.minFilter, textureData.magFilter, textureData.mipmapped);
            }
            this.loadImage(textureData.name, textureData.image, textureData.minFilter, textureData.magFilter, textureData.mipmapped, bl);
        }
    }

    public void batchLoad(ArrayList arrayList) {
        this.batchLoad(arrayList, true);
    }

    public void batchLoad(ArrayList arrayList, boolean bl) {
        for (int i = 0; i < arrayList.size(); ++i) {
            TextureData textureData = (TextureData)arrayList.get(i);
            this.loadImage(textureData.name, textureData.image, textureData.minFilter, textureData.magFilter, textureData.mipmapped, bl);
        }
    }

    public ArrayList saveKeys() {
        this.previousKeys = (ArrayList)this.keyList.clone();
        return this.previousKeys;
    }

    public int loadTexture(ImageIcon imageIcon, int n, int n2, boolean bl) {
        return this.loadTexture(imageIcon, n, n2, bl, true);
    }

    public int loadTexture(ImageIcon imageIcon, int n, int n2, boolean bl, boolean bl2) {
        Object v = this.textureList.get(imageIcon.getDescription());
        if (v != null) {
            return (Integer)v;
        }
        return this.loadImage(imageIcon.getDescription(), imageIcon.getImage(), n, n2, bl, true);
    }

    public int loadTexture(String string, int n, int n2, boolean bl) {
        return this.loadTexture(string, n, n2, bl, true);
    }

    public int loadTexture(String string, int n, int n2, boolean bl, boolean bl2) {
        Object v = this.textureList.get(string);
        if (v != null) {
            return (Integer)v;
        }
        Image image = null;
        image = ".TGA".equalsIgnoreCase(string.substring(string.indexOf(46))) ? this.loadTGAImage(string) : (".BMP".equalsIgnoreCase(string.substring(string.indexOf(46))) ? this.loadBMPImage(string) : new ImageIcon(string).getImage());
        if (null == image) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Could not load" + string);
            return -1;
        }
        return this.loadImage(string, image, n, n2, bl, bl2);
    }

    public int getTexture(String string) {
        Object v = this.textureList.get(string);
        if (v != null) {
            return (Integer)v;
        }
        return -1;
    }

    public boolean bind(String string) {
        Object v = this.textureList.get(string);
        if (v != null) {
            int n = (Integer)v;
            if (n != this.boundID) {
                this.boundID = n;
                GL.glBindTexture((int)3553, (int)n);
            }
            return true;
        }
        return false;
    }

    public void bind(int n) {
        if (n != this.boundID) {
            this.boundID = n;
            GL.glBindTexture((int)3553, (int)n);
        }
    }

    public boolean deleteTexture(String string) {
        Object v = this.textureList.get(string);
        if (v != null) {
            int n = (Integer)v;
            IntBuffer intBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
            intBuffer.put(n);
            GL.glDeleteTextures((IntBuffer)intBuffer);
            this.textureList.remove(string);
            return true;
        }
        this.keyList.remove(string);
        return false;
    }

    public void deleteAll() {
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Deleting All Textures");
        for (int i = 0; i < this.keyList.size(); ++i) {
            String string = ((TextureData)this.keyList.get((int)i)).name;
            int n = (Integer)this.textureList.get(string);
            if (!GL.glIsTexture((int)n)) continue;
            IntBuffer intBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
            intBuffer.put(n);
            GL.glDeleteTextures((IntBuffer)intBuffer);
        }
        this.textureList.clear();
        this.keyList.clear();
    }

    public int getNumberOfTextures() {
        return this.textureList.size();
    }

    public static TextureManager getTextureManager() {
        if (null == instance) {
            instance = new TextureManager();
            return instance;
        }
        return instance;
    }

    public static void reset() {
        if (null != instance) {
            instance.deleteAll();
            instance = null;
        }
    }

    private int loadImage(String string, Image image, int n, int n2, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Could not load image file " + string);
            return -1;
        }
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(image, null, null);
        graphics2D.dispose();
        if (bl2) {
            object2 = AffineTransform.getScaleInstance(1.0, -1.0);
            ((AffineTransform)object2).translate(0.0, -image.getHeight(null));
            object = new AffineTransformOp((AffineTransform)object2, 1);
            bufferedImage = ((AffineTransformOp)object).filter(bufferedImage, null);
        }
        object2 = ByteBuffer.allocateDirect(4 * bufferedImage.getWidth() * bufferedImage.getHeight());
        object = (byte[])bufferedImage.getRaster().getDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        ((ByteBuffer)object2).clear();
        ((ByteBuffer)object2).put((byte[])object);
        ((ByteBuffer)object2).rewind();
        IntBuffer intBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL.glGenTextures((IntBuffer)intBuffer);
        GL.glBindTexture((int)3553, (int)intBuffer.get(0));
        GL.glTexParameteri((int)3553, (int)10241, (int)n);
        GL.glTexParameteri((int)3553, (int)10240, (int)n2);
        if (bl) {
            GLU.gluBuild2DMipmaps((int)3553, (int)3, (int)bufferedImage.getWidth(), (int)bufferedImage.getHeight(), (int)6407, (int)5121, (ByteBuffer)object2);
        } else {
            GL.glTexImage2D((int)3553, (int)0, (int)6407, (int)bufferedImage.getWidth(), (int)bufferedImage.getHeight(), (int)0, (int)6407, (int)5121, (ByteBuffer)object2);
        }
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Successfully loaded " + string + " with ID " + intBuffer.get(0));
        this.textureList.put(string, new Integer(intBuffer.get(0)));
        this.keyList.add(new TextureData(image, string, n, n2, bl));
        return intBuffer.get(0);
    }

    private Image loadBMPImage(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BitmapHeader bitmapHeader = new BitmapHeader();
            bitmapHeader.read(fileInputStream);
            if (bitmapHeader.bitcount == 24) {
                return bitmapHeader.readMap24(fileInputStream, bitmapHeader);
            }
            if (bitmapHeader.bitcount == 32) {
                return bitmapHeader.readMap32(fileInputStream, bitmapHeader);
            }
            if (bitmapHeader.bitcount == 8) {
                return bitmapHeader.readMap8(fileInputStream, bitmapHeader);
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Error while loading " + string);
            System.exit(1);
        }
        return null;
    }

    private Image loadTGAImage(String string) {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            idLength = (short)dataInputStream.read();
            colorMapType = (short)dataInputStream.read();
            imageType = (short)dataInputStream.read();
            cMapStart = this.flipEndian(dataInputStream.readShort());
            cMapLength = this.flipEndian(dataInputStream.readShort());
            cMapDepth = (short)dataInputStream.read();
            xOffset = this.flipEndian(dataInputStream.readShort());
            yOffset = this.flipEndian(dataInputStream.readShort());
            width = this.flipEndian(dataInputStream.readShort());
            height = this.flipEndian(dataInputStream.readShort());
            pixelDepth = (short)dataInputStream.read();
            if (pixelDepth == 24) {
                cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
            } else if (pixelDepth == 32) {
                cm = new DirectColorModel(32, -16777216, 0xFF0000, 65280, 255);
            }
            imageDescriptor = (short)dataInputStream.read();
            if (idLength > 0) {
                bufferedInputStream.skip(idLength);
            }
            pixels = new int[width * height];
            for (int i = height - 1; i >= 0; --i) {
                n4 = i * width;
                for (int j = 0; j < width; ++j) {
                    n3 = bufferedInputStream.read() & 0xFF;
                    n2 = bufferedInputStream.read() & 0xFF;
                    n = bufferedInputStream.read() & 0xFF;
                    if (pixelDepth == 32) {
                        n5 = bufferedInputStream.read() & 0xFF;
                        TextureManager.pixels[n4 + j] = n5 << 24 | n << 16 | n2 << 8 | n3;
                        continue;
                    }
                    TextureManager.pixels[n4 + j] = n << 16 | n2 << 8 | n3;
                }
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Unable to load " + string);
            throw new MonkeyRuntimeException("Could not load targa file");
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, (ColorModel)cm, pixels, 0, width));
    }

    private short flipEndian(short s) {
        int n = s & 0xFFFF;
        return (short)(n << 8 | (n & 0xFF00) >>> 8);
    }

    private class TextureData {
        public Image image;
        public String name;
        public int minFilter;
        public int magFilter;
        public boolean mipmapped;

        public TextureData(Image image, String string, int n, int n2, boolean bl) {
            this.image = image;
            this.name = string;
            this.minFilter = n;
            this.magFilter = n2;
            this.mipmapped = bl;
        }
    }

    private class BitmapHeader {
        public int size;
        public int bisize;
        public int width;
        public int height;
        public int planes;
        public int bitcount;
        public int compression;
        public int sizeimage;
        public int xpm;
        public int ypm;
        public int clrused;
        public int clrimp;

        private BitmapHeader() {
        }

        private Image readMap32(FileInputStream fileInputStream, BitmapHeader bitmapHeader) throws IOException {
            int n = bitmapHeader.sizeimage / bitmapHeader.height;
            int[] nArray = new int[bitmapHeader.height * bitmapHeader.width];
            byte[] byArray = new byte[bitmapHeader.width * 4 * bitmapHeader.height];
            fileInputStream.read(byArray, 0, bitmapHeader.width * 4 * bitmapHeader.height);
            int n2 = 0;
            for (int i = 0; i < bitmapHeader.height; ++i) {
                for (int j = 0; j < bitmapHeader.width; ++j) {
                    nArray[bitmapHeader.width * (bitmapHeader.height - i - 1) + j] = this.constructInt3(byArray, n2);
                    n2 += 4;
                }
            }
            Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bitmapHeader.width, bitmapHeader.height, nArray, 0, bitmapHeader.width));
            fileInputStream.close();
            return image;
        }

        private Image readMap24(FileInputStream fileInputStream, BitmapHeader bitmapHeader) throws IOException {
            int n = bitmapHeader.sizeimage / bitmapHeader.height - bitmapHeader.width * 3;
            int[] nArray = new int[bitmapHeader.height * bitmapHeader.width];
            byte[] byArray = new byte[(bitmapHeader.width + n) * 3 * bitmapHeader.height];
            fileInputStream.read(byArray, 0, (bitmapHeader.width + n) * 3 * bitmapHeader.height);
            int n2 = 0;
            for (int i = 0; i < bitmapHeader.height; ++i) {
                for (int j = 0; j < bitmapHeader.width; ++j) {
                    nArray[bitmapHeader.width * (bitmapHeader.height - i - 1) + j] = this.constructInt3(byArray, n2);
                    n2 += 3;
                }
                n2 += n;
            }
            Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bitmapHeader.width, bitmapHeader.height, nArray, 0, bitmapHeader.width));
            fileInputStream.close();
            return image;
        }

        private Image readMap8(FileInputStream fileInputStream, BitmapHeader bitmapHeader) throws IOException {
            int n;
            int n2 = 0;
            n2 = bitmapHeader.clrused > 0 ? bitmapHeader.clrused : 1 << bitmapHeader.bitcount;
            if (bitmapHeader.sizeimage == 0) {
                bitmapHeader.sizeimage = (bitmapHeader.width * bitmapHeader.bitcount + 31 & 0xFFFFFFE0) >> 3;
                bitmapHeader.sizeimage *= bitmapHeader.height;
            }
            int[] nArray = new int[n2];
            byte[] byArray = new byte[n2 * 4];
            fileInputStream.read(byArray, 0, n2 * 4);
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                nArray[n] = this.constructInt3(byArray, n3);
                n3 += 4;
            }
            n = bitmapHeader.sizeimage / bitmapHeader.height - bitmapHeader.width;
            int[] nArray2 = new int[bitmapHeader.width * bitmapHeader.height];
            byte[] byArray2 = new byte[(bitmapHeader.width + n) * bitmapHeader.height];
            fileInputStream.read(byArray2, 0, (bitmapHeader.width + n) * bitmapHeader.height);
            n3 = 0;
            for (int i = 0; i < bitmapHeader.height; ++i) {
                for (int j = 0; j < bitmapHeader.width; ++j) {
                    nArray2[bitmapHeader.width * (bitmapHeader.height - i - 1) + j] = nArray[byArray2[n3] & 0xFF];
                    ++n3;
                }
                n3 += n;
            }
            Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bitmapHeader.width, bitmapHeader.height, nArray2, 0, bitmapHeader.width));
            return image;
        }

        private int constructInt(byte[] byArray, int n) {
            int n2 = byArray[n + 3] & 0xFF;
            n2 = n2 << 8 | byArray[n + 2] & 0xFF;
            n2 = n2 << 8 | byArray[n + 1] & 0xFF;
            n2 = n2 << 8 | byArray[n + 0] & 0xFF;
            return n2;
        }

        private int constructInt3(byte[] byArray, int n) {
            int n2 = 255;
            n2 = n2 << 8 | byArray[n + 2] & 0xFF;
            n2 = n2 << 8 | byArray[n + 1] & 0xFF;
            n2 = n2 << 8 | byArray[n + 0] & 0xFF;
            return n2;
        }

        private long constructLong(byte[] byArray, int n) {
            long l = (long)byArray[n + 7] & 0xFFL;
            l |= l << 8 | (long)byArray[n + 6] & 0xFFL;
            l |= l << 8 | (long)byArray[n + 5] & 0xFFL;
            l |= l << 8 | (long)byArray[n + 4] & 0xFFL;
            l |= l << 8 | (long)byArray[n + 3] & 0xFFL;
            l |= l << 8 | (long)byArray[n + 2] & 0xFFL;
            l |= l << 8 | (long)byArray[n + 1] & 0xFFL;
            l |= l << 8 | (long)byArray[n + 0] & 0xFFL;
            return l;
        }

        private double constructDouble(byte[] byArray, int n) {
            long l = this.constructLong(byArray, n);
            return Double.longBitsToDouble(l);
        }

        private short constructShort(byte[] byArray, int n) {
            short s = (short)(byArray[n + 1] & 0xFF);
            s = (short)(s << 8 | (short)(byArray[n + 0] & 0xFF));
            return s;
        }

        protected final void read(FileInputStream fileInputStream) throws IOException {
            byte[] byArray = new byte[14];
            fileInputStream.read(byArray, 0, 14);
            byte[] byArray2 = new byte[40];
            fileInputStream.read(byArray2, 0, 40);
            this.size = this.constructInt(byArray, 2);
            this.bisize = this.constructInt(byArray2, 2);
            this.width = this.constructInt(byArray2, 4);
            this.height = this.constructInt(byArray2, 8);
            this.planes = this.constructShort(byArray2, 12);
            this.bitcount = this.constructShort(byArray2, 14);
            this.compression = this.constructInt(byArray2, 16);
            this.sizeimage = this.constructInt(byArray2, 20);
            this.xpm = this.constructInt(byArray2, 24);
            this.ypm = this.constructInt(byArray2, 28);
            this.clrused = this.constructInt(byArray2, 32);
            this.clrimp = this.constructInt(byArray2, 36);
        }
    }
}

