/*
 * Decompiled with CFR 0.152.
 */
package test.general;

import java.util.logging.Logger;
import javax.swing.ImageIcon;
import jme.AbstractGame;
import jme.entity.Entity;
import jme.entity.camera.Camera;
import jme.geometry.hud.SplashScreen;
import jme.geometry.hud.text.Font2D;
import jme.geometry.model.md3.Md3Model;
import jme.geometry.primitive.Pyramid;
import jme.lighting.SlopeLighting;
import jme.locale.external.Geomipmap;
import jme.locale.external.data.AbstractHeightMap;
import jme.locale.external.data.FaultFractalHeightMap;
import jme.locale.external.feature.SkyDome;
import jme.locale.external.feature.WaterPlane;
import jme.math.Vector;
import jme.physics.mobile.LandMobility;
import jme.system.DisplaySystem;
import jme.texture.ProceduralTexture;
import jme.texture.TextureManager;
import jme.utility.LoggingSystem;
import jme.utility.Timer;
import jme.world.World;
import org.lwjgl.Display;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCaps;
import org.lwjgl.opengl.GLU;
import org.lwjgl.opengl.Window;
import test.general.TestController;

public class TestMain
extends AbstractGame {
    private int currentAnimation;
    private LandMobility physics;
    private ProceduralTexture pt;
    private SlopeLighting sl;
    private AbstractHeightMap hm1;
    private World world;
    private Geomipmap l;
    private Camera camera = null;
    private Font2D font = null;
    private Pyramid object;
    Entity e;
    private TestController cc = null;
    protected Logger log = null;
    private Timer timer;
    SplashScreen ss;
    int tex1;
    int tex2;
    int tex3;
    static float wrap;

    static {
        if (GLCaps.WGL_EXT_swap_control) {
            GL.wglSwapIntervalEXT((int)1);
        }
        wrap = 0.0f;
    }

    protected void update() {
        if (!this.cc.update(this.timer.getFrameRate())) {
            this.finish();
        }
        this.world.update(1.0f / this.timer.getFrameRate());
        this.timer.update();
        if (this.e.getPosition().x > 4000.0f) {
            this.e.getPosition().x = 4000.0f;
        }
        if (this.e.getPosition().z > 4000.0f) {
            this.e.getPosition().z = 4000.0f;
        }
        if (this.e.getPosition().x < 200.0f) {
            this.e.getPosition().x = 200.0f;
        }
        if (this.e.getPosition().z < 200.0f) {
            this.e.getPosition().z = 200.0f;
        }
        this.e.getPosition().y = this.hm1.getInterpolatedHeight(this.e.getPosition().x / 4.0f, this.e.getPosition().z / 4.0f) + 3.0f;
        if (this.camera.getPosition().x > 4000.0f) {
            this.camera.getPosition().x = 4000.0f;
        }
        if (this.camera.getPosition().z > 4000.0f) {
            this.camera.getPosition().z = 4000.0f;
        }
        if (this.camera.getPosition().x < 200.0f) {
            this.camera.getPosition().x = 200.0f;
        }
        if (this.camera.getPosition().z < 200.0f) {
            this.camera.getPosition().z = 200.0f;
        }
        if (this.camera.getPosition().y < this.hm1.getInterpolatedHeight(this.camera.getPosition().x / 4.0f, this.camera.getPosition().z / 4.0f) + 8.0f) {
            this.camera.getPosition().y = this.hm1.getInterpolatedHeight(this.camera.getPosition().x / 4.0f, this.camera.getPosition().z / 4.0f) + 8.0f;
        }
        if (this.physics.getCurrentVelocity() < -1.0f && this.currentAnimation != 4) {
            this.currentAnimation = 4;
            ((Md3Model)this.e.getGeometry()).setLegsAnimation("LEGS_BACK");
        } else if (this.physics.getCurrentVelocity() < 1.0f && this.physics.getCurrentVelocity() > -1.0f) {
            if (this.physics.getCurrentTurningVel() != 0.0f && this.currentAnimation != 0) {
                this.currentAnimation = 0;
                ((Md3Model)this.e.getGeometry()).setLegsAnimation("LEGS_TURN");
            } else if (this.physics.getCurrentTurningVel() == 0.0f && this.currentAnimation != 3) {
                this.currentAnimation = 3;
                ((Md3Model)this.e.getGeometry()).setLegsAnimation("LEGS_IDLE");
            }
        } else if (this.physics.getCurrentVelocity() > 1.0f && this.physics.getCurrentVelocity() < 20.0f && this.currentAnimation != 1) {
            this.currentAnimation = 1;
            ((Md3Model)this.e.getGeometry()).setLegsAnimation("LEGS_WALK");
        } else if (this.physics.getCurrentVelocity() > 20.0f && this.currentAnimation != 2) {
            this.currentAnimation = 2;
            ((Md3Model)this.e.getGeometry()).setLegsAnimation("LEGS_RUN");
        }
    }

    protected void render() {
        GL.glClear((int)16640);
        GL.glLoadIdentity();
        this.cc.render();
        this.world.render();
        this.font.print(1, 1, "FPS - " + this.timer.getFrameRate() + " : " + this.timer.getMinFrameRate() + " - " + this.timer.getMaxFrameRate(), 0);
        this.font.print(1, 20, "Entity Location - " + this.e.getPosition().toString(), 0);
        this.font.print(1, 40, "Patches rendered " + this.l.getNumPatchesRendered() + " / " + this.l.getNumPatches(), 0);
        this.font.print(1, 60, "Entities rendered " + this.world.getNumRenderedEntities() + " / " + this.world.getTotalEntities(), 0);
    }

    private void initLogger() {
        this.log = LoggingSystem.getLoggingSystem().getLogger();
    }

    private void initCamera() {
        this.camera = new Camera(1, 850.0f, 100.0f, 850.0f, 451.0f, 100.0f, 450.0f, 0.0f, 1.0f, 0.0f);
        this.camera.getFrustum().setBuffer(3.0f);
    }

    private void initDisplay() {
        DisplaySystem.createDisplaySystem("test", "data/Images/Monkey.jpg", true);
    }

    private void initGL() {
        GL.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL.glClearDepth((double)1.0);
        GL.glEnable((int)2929);
        GL.glDepthFunc((int)515);
        GL.glMatrixMode((int)5889);
        GL.glLoadIdentity();
        GLU.gluPerspective((double)45.0, (double)((float)Display.getWidth() / (float)Display.getHeight()), (double)1.0, (double)750.0);
        GL.glMatrixMode((int)5888);
        GL.glHint((int)3152, (int)4354);
        DisplaySystem.getDisplaySystem().cullMode(1029, true);
    }

    protected void reinit() {
        Keyboard.destroy();
        Mouse.destroy();
        try {
            Keyboard.create();
            Mouse.create();
            this.initGL();
            this.initTimer();
            TextureManager.getTextureManager().reload();
            this.font = new Font2D("data/Font/font.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        float[] color = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
        this.l.setFogAttributes(9729, color, 0.35f, 50.0f, 500.0f);
        this.l.setDistanceFog(true);
    }

    protected void initSystem() {
        this.initDisplay();
        this.font = new Font2D("data/Font/font.png");
        this.initLogger();
        this.initGL();
        this.initCamera();
        this.initTimer();
        SplashScreen ss3 = new SplashScreen();
        ss3.setTexture("data/Images/tdemo.jpg");
        this.addSplashScreen(ss3);
    }

    protected void initGame() {
        this.hm1 = new FaultFractalHeightMap(1025, 64, 0, 255, 0.15f);
        this.hm1.setHeightScale(1.0f);
        this.pt = new ProceduralTexture(this.hm1);
        this.pt.addTexture(new ImageIcon("data/texture/plants15.jpg"), -128, 0, 128);
        this.pt.addTexture(new ImageIcon("data/texture/plants12.jpg"), 0, 128, 255);
        this.pt.addTexture(new ImageIcon("data/texture/highestTile.png"), 128, 255, 384);
        this.pt.createTexture(128);
        SkyDome sd = new SkyDome(16.0f, 15.0f, 15.0f, 1.0f, 1.0f);
        sd.setTexture("data/texture/clouds.png");
        sd.setDomeRotation(0.25f);
        WaterPlane wp = new WaterPlane(2050, 45.0f, 0.25f);
        wp.setColor(new Vector(1.0f, 1.0f, 1.0f));
        wp.setTransparency(0.6f);
        wp.setTexture("data/texture/water02.jpg");
        wp.setWaveSpeed(0.05f);
        wp.setTextureAnimation(1.0f, 1.0f);
        this.sl = new SlopeLighting(this.hm1, 1, -1, 0.1f, 0.9f, 10);
        this.l = new Geomipmap(this.hm1, 17, this.camera);
        this.l.setDetailTexture("data/texture/Detail.jpg", 64);
        this.l.setLightMap(this.sl);
        this.camera.setSky(sd);
        this.e = new Entity(1);
        Md3Model msmodel = new Md3Model("data/model/Paladin", "Paladin", "railgun");
        msmodel.setTorsoAnimation("TORSO_STAND");
        msmodel.setLegsAnimation("LEGS_IDLE");
        msmodel.setScale(new Vector(0.15f, 0.15f, 0.15f));
        this.e.setGeometry(msmodel);
        this.e.setPosition(new Vector(1000.0f, this.hm1.getScaledHeightAtPoint(250, 250), 1000.0f));
        this.e.setVisibilityType(1);
        this.camera.setView(this.e.getPosition());
        this.physics = new LandMobility();
        this.physics.setMaxVelocity(40.0f);
        this.physics.setMinVelocity(-20.0f);
        this.physics.setBaseAcceleration(60.0f);
        this.physics.setCoastDeceleration(20.0f);
        this.physics.setCurrentAngle(0.0f);
        this.physics.setTurningVelocity(100.0f);
        this.e.setPhysicsModule(this.physics);
        this.l.setXScale(4.0f);
        this.l.setZScale(4.0f);
        this.l.setTexture(this.pt.getImageIcon());
        this.world = new World();
        this.world.addEntity(this.e);
        this.world.setWater(wp);
        this.world.setLocale(this.l);
        float[] color = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
        this.l.setFogAttributes(9729, color, 0.35f, 50.0f, 750.0f);
        this.l.setDistanceFog(true);
        this.l.setVolumetricFog(false);
        this.l.setVolumetricFogDepth(100.0f);
        this.object = new Pyramid(10.0f, 30.0f);
        this.object.setColor(0.5f, 0.85f, 0.5f, 0.5f);
        this.object.setTexture("data/texture/plants15.jpg");
        this.object.useDisplayList(true);
        Entity[] elist = new Entity[1000];
        int i = 0;
        while (i < 1000) {
            float z;
            float x;
            elist[i] = new Entity(i + 1);
            elist[i].setGeometry(this.object);
            elist[i].setVisibilityType(0);
            while (this.hm1.getInterpolatedHeight((x = (float)Math.random() * 2000.0f) / 2.0f, (z = (float)Math.random() * 2000.0f) / 2.0f) < 75.0f || this.hm1.getInterpolatedHeight(x / 4.0f, z / 4.0f) > 200.0f) {
            }
            elist[i].setPosition(new Vector(x, this.hm1.getInterpolatedHeight(x / 4.0f, z / 4.0f) + 1.0f, z));
            this.world.addEntity(elist[i]);
            elist[i].setVisibilityType(1);
            ++i;
        }
        this.cc = new TestController(this.camera, this.e, this);
        this.cc.setTrackingDistance(30.0f);
        this.cc.setTrackingSpeed(1.0f);
        this.world.setCamera(this.camera);
        this.world.setEntityVisibility(true);
    }

    public void rebuildTerrain() {
        this.hm1.load();
        this.sl.setHeightMap(this.hm1);
        this.sl.createLighting();
    }

    private void initTimer() {
        this.timer = Timer.getTimer();
    }

    protected void cleanup() {
        Keyboard.destroy();
        Mouse.destroy();
        Window.destroy();
        TextureManager.reset();
    }

    public static void main(String[] args) {
        TestMain app = new TestMain();
        app.start();
    }

    public void saveTerrain(String filename) {
        this.hm1.save(filename);
    }
}

