/*
 * Decompiled with CFR 0.152.
 */
package test.model.ms3dAscii;

import jme.AbstractGame;
import jme.controller.BaseFPSController;
import jme.entity.camera.Camera;
import jme.geometry.bounding.BoundingSphere;
import jme.geometry.hud.text.Font2D;
import jme.geometry.model.Model;
import jme.geometry.model.ms.MilkshapeModel;
import jme.system.DisplaySystem;
import jme.utility.Timer;
import org.lwjgl.Display;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLU;
import org.lwjgl.opengl.Window;

public class TestMilkshape
extends AbstractGame {
    private Model model;
    private float yrot;
    private BaseFPSController cc;
    private Timer timer;
    private Camera camera;
    private Font2D font;

    protected void update() {
        if (!this.cc.update(this.timer.getFrameRate())) {
            this.finish();
        }
        this.timer.update();
        this.model.update(10.0f / this.timer.getFrameRate());
    }

    protected void render() {
        GL.glClear((int)16640);
        GL.glLoadIdentity();
        this.cc.render();
        this.model.render();
        this.font.print(1, 1, "Frame Rate - " + this.timer.getFrameRate(), 0);
    }

    protected void initDisplay() {
        DisplaySystem.createDisplaySystem("TestMilkshape", "data/Images/Monkey.jpg", true);
    }

    protected void initGL() {
        GL.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL.glClearDepth((double)1.0);
        GL.glEnable((int)2929);
        GL.glDepthFunc((int)515);
        GL.glMatrixMode((int)5889);
        GL.glLoadIdentity();
        GLU.gluPerspective((double)45.0, (double)((float)Display.getWidth() / (float)Display.getHeight()), (double)100.0, (double)2000.0);
        GL.glMatrixMode((int)5888);
        GL.glHint((int)3152, (int)4354);
        GL.glBlendFunc((int)770, (int)1);
    }

    protected void initSystem() {
        this.initDisplay();
        this.initGL();
        this.camera = new Camera(1, 50.0f, 0.0f, 300.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.cc = new BaseFPSController(this.camera){

            protected boolean checkAdditionalKeys() {
                if (this.isKeyDown("exit")) {
                    return false;
                }
                if (this.isKeyDown("rise")) {
                    DisplaySystem.getDisplaySystem().takeScreenShot("test");
                }
                return true;
            }
        };
        this.timer = Timer.getTimer();
        this.font = new Font2D("data/Font/font.png");
    }

    protected void initGame() {
        this.model = new MilkshapeModel("data/model/msascii/run.txt", true);
        BoundingSphere bs = new BoundingSphere();
        bs.averagePoints(this.model.getPoints());
        System.out.println("num of points " + this.model.getPoints().length);
        System.out.println("center " + bs.getCenter());
        System.out.println("radius " + bs.getRadius());
    }

    protected void reinit() {
    }

    protected void cleanup() {
        Window.destroy();
    }

    public static void main(String[] args) {
        TestMilkshape testApp = new TestMilkshape();
        testApp.start();
    }
}

