/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.Sys;
import org.lwjgl.input.Mouse;

public class Cursor {
    private static boolean initialized;
    private final long nativeHandle;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Cursor(int n, int n2, int n3, int n4, int n5, IntBuffer intBuffer, IntBuffer intBuffer2) throws Exception {
        if (!initialized) {
            Cursor.initialize();
        }
        n4 = n2 - 1 - n4;
        if (!$assertionsDisabled && !Mouse.isCreated()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n * n2 * n5 > intBuffer.remaining()) {
            throw new AssertionError((Object)"width*height*numImages > images.remaining()");
        }
        if (!$assertionsDisabled && intBuffer2 != null && n5 > intBuffer2.remaining()) {
            throw new AssertionError((Object)"delays != null && numImages > delays.remaining()");
        }
        if (!($assertionsDisabled || n3 < n && n3 >= 0)) {
            throw new AssertionError((Object)"xHotspot > width || xHotspot < 0");
        }
        if (!($assertionsDisabled || n4 < n2 && n4 >= 0)) {
            throw new AssertionError((Object)"yHotspot > height || yHotspot < 0");
        }
        IntBuffer intBuffer3 = ByteBuffer.allocateDirect(intBuffer.remaining() * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        Cursor.flipImages(n, n2, n5, intBuffer, intBuffer3);
        this.nativeHandle = Cursor.nCreateCursor(n, n2, n3, n4, n5, intBuffer3, 0, intBuffer2, intBuffer2 != null ? intBuffer2.position() : 0);
    }

    private static void initialize() {
        System.loadLibrary(Sys.getLibraryName());
        initialized = true;
    }

    private static void flipImages(int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        for (int i = 0; i < n3; ++i) {
            int n4 = i * n * n2;
            Cursor.flipImage(n, n2, n4, intBuffer, intBuffer2);
        }
    }

    private static void flipImage(int n, int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        for (int i = 0; i < n2 >> 1; ++i) {
            int n4 = i * n + n3;
            int n5 = (n2 - i - 1) * n + n3;
            for (int j = 0; j < n; ++j) {
                int n6 = n4 + j;
                int n7 = n5 + j;
                int n8 = intBuffer.get(n6 + intBuffer.position());
                intBuffer2.put(n6, intBuffer.get(n7 + intBuffer.position()));
                intBuffer2.put(n7, n8);
            }
        }
    }

    public void destroy() {
        Cursor.nDestroyCursor(this.nativeHandle);
    }

    public long getHandle() {
        return this.nativeHandle;
    }

    private static native long nCreateCursor(int var0, int var1, int var2, int var3, int var4, IntBuffer var5, int var6, IntBuffer var7, int var8);

    private static native void nDestroyCursor(long var0);

    static {
        $assertionsDisabled = !Cursor.class.desiredAssertionStatus();
        initialized = false;
    }
}

