/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vector;

import java.io.Serializable;
import java.nio.FloatBuffer;
import org.lwjgl.vector.ReadableVector2f;
import org.lwjgl.vector.Vector;

public class Vector2f
extends Vector
implements Serializable,
ReadableVector2f {
    public float x;
    public float y;

    public Vector2f() {
    }

    public Vector2f(ReadableVector2f readableVector2f) {
        this.set(readableVector2f);
    }

    public Vector2f(float f, float f2) {
        this.set(f, f2);
    }

    public Vector2f set(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public Vector2f set(ReadableVector2f readableVector2f) {
        this.x = readableVector2f.getX();
        this.y = readableVector2f.getY();
        return this;
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2f translate(float f, float f2) {
        this.x += f;
        this.y += f2;
        return this;
    }

    public Vector negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2f negate(Vector2f vector2f) {
        if (vector2f == null) {
            vector2f = new Vector2f();
        }
        vector2f.x = -this.x;
        vector2f.y = -this.y;
        return vector2f;
    }

    public Vector2f normalise(Vector2f vector2f) {
        float f = this.length();
        if (vector2f == null) {
            vector2f = new Vector2f(this.x / f, this.y / f);
        } else {
            vector2f.set(this.x / f, this.y / f);
        }
        return vector2f;
    }

    public static float dot(Vector2f vector2f, Vector2f vector2f2) {
        return vector2f.x * vector2f2.x + vector2f.y * vector2f2.y;
    }

    public static float angle(Vector2f vector2f, Vector2f vector2f2) {
        float f = Vector2f.dot(vector2f, vector2f2) / (vector2f.length() * vector2f2.length());
        if (f < -1.0f) {
            f = -1.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return (float)Math.toDegrees(Math.acos(f));
    }

    public static Vector2f add(Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3) {
        if (vector2f3 == null) {
            return new Vector2f(vector2f.x + vector2f2.x, vector2f.y + vector2f2.y);
        }
        return vector2f3.set(vector2f.x + vector2f2.x, vector2f.y + vector2f2.y);
    }

    public static Vector2f sub(Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3) {
        if (vector2f3 == null) {
            return new Vector2f(vector2f.x - vector2f2.x, vector2f.y - vector2f2.y);
        }
        return vector2f3.set(vector2f.x - vector2f2.x, vector2f.y - vector2f2.y);
    }

    public Vector store(FloatBuffer floatBuffer) {
        floatBuffer.put(this.x);
        floatBuffer.put(this.y);
        return this;
    }

    public Vector load(FloatBuffer floatBuffer) {
        this.x = floatBuffer.get();
        this.y = floatBuffer.get();
        return this;
    }

    public Vector scale(float f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("Vector2f[");
        stringBuffer.append(this.x);
        stringBuffer.append(", ");
        stringBuffer.append(this.y);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final void setX(float f) {
        this.x = f;
    }

    public final void setY(float f) {
        this.y = f;
    }
}

