/*
 * Copyright (c) 2003, jMonkeyEngine - Mojo Monkey Coding
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this 
 * list of conditions and the following disclaimer. 
 * 
 * Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 
 * Neither the name of the Mojo Monkey Coding, jME, jMonkey Engine, nor the 
 * names of its contributors may be used to endorse or promote products derived 
 * from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package jme.controller;

/**
 * <code>KeyboardController</code> provides an interface for interacting with 
 * the keyboard. The keyboard can be queried in two ways, individual polls, or
 * buffered mode. If poll mode is used, all keys that are pressed when poll is
 * called is set to true. If buffered mode is used, all pressed keys are 
 * entered into the buffer and each key press can be retrieved via a call to 
 * next.
 * 
 * @author Mark Powell
 * @version 1
 */
public interface KeyboardController {
    
    /**
     * <code>pollKeyboard</code> updates the state of the key variables to
     * be either true or false depending on the current keyboard. 
     */
    public void pollKeyboard();
    
    /**
     * <code>isKeyDown</code> returns a boolean value if a key is pressed or
     * not. True is returned if the key is pressed, false otherwise.
     * 
     * @param keyCode which key to check for. Implementations job to define
     *      how a keyCode is defined.
     * @return true if the key is pressed, false if it is not.
     */
    public boolean isKeyDown(Object keyCode);
    
    /**
     * <code>setBuffered</code> sets the keyboard to buffered mode. All keyboard
     * input will be placed in the buffer and can be retrieved one key press
     * at a time using next.
     */
    public void setBuffered();
    
    /**
     * <code>next</code> returns the key code of the next key in the buffer.
     * To correctly use this, a call to <code>setBuffered</code> needs to be
     * made.
     */
    public int next();

}
