/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.lwjgl.LwjglFiles;
import com.badlogic.gdx.backends.lwjgl.LwjglGraphics;
import com.badlogic.gdx.backends.lwjgl.LwjglInput;
import com.badlogic.gdx.backends.lwjgl.LwjglNativesLoader;
import com.badlogic.gdx.backends.lwjgl.LwjglPreferences;
import com.badlogic.gdx.backends.openal.OpenALAudio;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.Display;

public class LwjglCanvas
implements Application {
    final LwjglGraphics graphics;
    final OpenALAudio audio;
    final LwjglFiles files;
    final LwjglInput input;
    final ApplicationListener listener;
    final Canvas canvas;
    final List<Runnable> runnables = new ArrayList<Runnable>();
    boolean running = true;
    int logLevel = 2;
    Map<String, Preferences> preferences = new HashMap<String, Preferences>();

    public LwjglCanvas(ApplicationListener listener, boolean useGL2) {
        LwjglNativesLoader.load();
        this.canvas = new Canvas(){
            private final Dimension minSize = new Dimension(0, 0);

            @Override
            public final void addNotify() {
                super.addNotify();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LwjglCanvas.this.start();
                    }
                });
            }

            @Override
            public final void removeNotify() {
                LwjglCanvas.this.stop();
                super.removeNotify();
            }

            @Override
            public Dimension getMinimumSize() {
                return this.minSize;
            }
        };
        this.canvas.setIgnoreRepaint(true);
        this.graphics = new LwjglGraphics(this.canvas, useGL2){

            @Override
            public void setTitle(String title) {
                super.setTitle(title);
                LwjglCanvas.this.setTitle(title);
            }

            @Override
            public boolean setDisplayMode(int width, int height, boolean fullscreen) {
                if (!super.setDisplayMode(width, height, fullscreen)) {
                    return false;
                }
                if (!fullscreen) {
                    LwjglCanvas.this.setDisplayMode(width, height);
                }
                return true;
            }

            @Override
            public boolean setDisplayMode(Graphics.DisplayMode displayMode) {
                if (!super.setDisplayMode(displayMode)) {
                    return false;
                }
                LwjglCanvas.this.setDisplayMode(displayMode.width, displayMode.height);
                return true;
            }
        };
        this.graphics.setVSync(true);
        this.audio = new OpenALAudio();
        this.files = new LwjglFiles();
        this.input = new LwjglInput();
        this.listener = listener;
        Gdx.app = this;
        Gdx.graphics = this.graphics;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.input = this.input;
    }

    protected void setDisplayMode(int width, int height) {
    }

    protected void setTitle(String title) {
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Files getFiles() {
        return this.files;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public Input getInput() {
        return this.input;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.Desktop;
    }

    public int getVersion() {
        return 0;
    }

    void start() {
        try {
            this.graphics.setupDisplay();
            this.listener.create();
            this.listener.resize(Math.max(1, this.graphics.getWidth()), Math.max(1, this.graphics.getHeight()));
        }
        catch (Exception ex) {
            this.stopped();
            throw new GdxRuntimeException((Throwable)ex);
        }
        EventQueue.invokeLater(new Runnable(){
            int lastWidth;
            int lastHeight;
            {
                this.lastWidth = Math.max(1, LwjglCanvas.this.graphics.getWidth());
                this.lastHeight = Math.max(1, LwjglCanvas.this.graphics.getHeight());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!LwjglCanvas.this.running) {
                    return;
                }
                LwjglCanvas.this.canvas.setCursor(null);
                LwjglCanvas.this.graphics.updateTime();
                List<Runnable> list = LwjglCanvas.this.runnables;
                synchronized (list) {
                    for (int i = 0; i < LwjglCanvas.this.runnables.size(); ++i) {
                        try {
                            LwjglCanvas.this.runnables.get(i).run();
                            continue;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    LwjglCanvas.this.runnables.clear();
                }
                LwjglCanvas.this.input.update();
                int width = Math.max(1, LwjglCanvas.this.graphics.getWidth());
                int height = Math.max(1, LwjglCanvas.this.graphics.getHeight());
                if (this.lastWidth != width || this.lastHeight != height) {
                    this.lastWidth = width;
                    this.lastHeight = height;
                    Gdx.gl.glViewport(0, 0, this.lastWidth, this.lastHeight);
                    LwjglCanvas.this.resize(width, height);
                    LwjglCanvas.this.listener.resize(width, height);
                }
                LwjglCanvas.this.input.processEvents();
                LwjglCanvas.this.listener.render();
                LwjglCanvas.this.audio.update();
                Display.update();
                if (LwjglCanvas.this.graphics.vsync) {
                    Display.sync(60);
                }
                if (LwjglCanvas.this.running && !Display.isCloseRequested()) {
                    EventQueue.invokeLater(this);
                } else {
                    LwjglCanvas.this.stopped();
                }
            }
        });
    }

    protected void resize(int width, int height) {
    }

    protected void stopped() {
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            Display.destroy();
            this.audio.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LwjglCanvas.this.listener.pause();
                LwjglCanvas.this.listener.dispose();
            }
        });
    }

    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    public Preferences getPreferences(String name) {
        if (this.preferences.containsKey(name)) {
            return this.preferences.get(name);
        }
        LwjglPreferences prefs = new LwjglPreferences(name);
        this.preferences.put(name, prefs);
        return prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        List<Runnable> list = this.runnables;
        synchronized (list) {
            this.runnables.add(runnable);
        }
    }

    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            System.out.println(tag + ": " + message);
        }
    }

    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            System.out.println(tag + ": " + message);
            exception.printStackTrace(System.out);
        }
    }

    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            System.out.println(tag + ": " + message);
        }
    }

    public void log(String tag, String message, Exception exception) {
        if (this.logLevel >= 2) {
            System.out.println(tag + ": " + message);
            exception.printStackTrace(System.out);
        }
    }

    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            System.err.println(tag + ": " + message);
        }
    }

    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            System.err.println(tag + ": " + message);
            exception.printStackTrace(System.err);
        }
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void exit() {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                LwjglCanvas.this.listener.pause();
                LwjglCanvas.this.listener.dispose();
                System.exit(-1);
            }
        });
    }
}

