/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Element;
import org.jdom.Text;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomXPPParser
implements XmlPullParser {
    private final String fileName;
    private final ArrayList<Object> events;
    private Iterator<Object> iter;
    private Object currentEvent;
    private StartTag currentStartTag;
    private int depth;

    public DomXPPParser(String string) {
        this.fileName = string;
        this.events = new ArrayList();
        this.events.add(Boolean.TRUE);
    }

    public void addElement(Object object, Element element) {
        this.addStartTag(object, element.getName(), DomXPPParser.toArray(element.getAttributes()));
        for (Object e : element.getContent()) {
            if (e instanceof Element) {
                this.addElement(object, (Element)e);
                continue;
            }
            if (e instanceof Text) {
                this.addText(((Text)e).getText());
                continue;
            }
            if (!(e instanceof CDATA)) continue;
            this.addText(((CDATA)e).getText());
        }
        this.addEndTag(element.getName());
    }

    public void addStartTag(Object object, String string, Collection<Attribute> collection) {
        this.addStartTag(object, string, DomXPPParser.toArray(collection));
    }

    public void addStartTag(Object object, String string, Attribute ... attributeArray) {
        StartTag startTag = new StartTag(string, attributeArray, this.currentStartTag, object, this.currentStartTag != null ? (this.currentStartTag.numChildren = this.currentStartTag.numChildren + 1) : 1);
        this.events.add(startTag);
        this.currentStartTag = startTag;
    }

    public void addEndTag(String string) {
        if (!this.currentStartTag.name.equals(string)) {
            throw new IllegalArgumentException("Unbalanced XML tree, expected: " + this.currentStartTag.name);
        }
        this.events.add(new EndTag(string));
        this.currentStartTag = this.currentStartTag.parent;
    }

    public void addText(String string) {
        Object object = this.events.get(this.events.size() - 1);
        if (object instanceof String) {
            this.events.set(this.events.size() - 1, ((String)object).concat(string));
        } else {
            this.events.add(string);
        }
    }

    public Object getLocation() {
        return this.currentStartTag != null ? this.currentStartTag.location : null;
    }

    public void defineEntityReplacementText(String string, String string2) throws XmlPullParserException {
    }

    public int getAttributeCount() {
        return ((StartTag)this.currentEvent).attributes.length;
    }

    public String getAttributeName(int n) {
        return ((StartTag)this.currentEvent).attributes[n].getName();
    }

    public String getAttributeNamespace(int n) {
        return null;
    }

    public String getAttributePrefix(int n) {
        return null;
    }

    public String getAttributeType(int n) {
        return "CDATA";
    }

    public String getAttributeValue(int n) {
        return ((StartTag)this.currentEvent).attributes[n].getValue();
    }

    public String getAttributeValue(String string, String string2) {
        if (string == null) {
            for (Attribute attribute : ((StartTag)this.currentEvent).attributes) {
                if (!attribute.getName().equals(string2)) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public int getColumnNumber() {
        return 0;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getEventType() {
        if (this.iter == null) {
            return this.next();
        }
        if (this.currentEvent instanceof StartTag) {
            return 2;
        }
        if (this.currentEvent instanceof String) {
            return 4;
        }
        if (this.currentEvent instanceof EndTag) {
            return 3;
        }
        if (this.iter.hasNext()) {
            return 0;
        }
        return 1;
    }

    public boolean getFeature(String string) {
        return false;
    }

    public String getInputEncoding() {
        return "UTF8";
    }

    public int getLineNumber() {
        return 0;
    }

    public String getName() {
        if (this.currentEvent instanceof StartTag) {
            return ((StartTag)this.currentEvent).name;
        }
        if (this.currentEvent instanceof EndTag) {
            return ((EndTag)this.currentEvent).name;
        }
        return null;
    }

    public String getNamespace(String string) {
        return null;
    }

    public String getNamespace() {
        return null;
    }

    public int getNamespaceCount(int n) throws XmlPullParserException {
        return 0;
    }

    public String getNamespacePrefix(int n) throws XmlPullParserException {
        return null;
    }

    public String getNamespaceUri(int n) throws XmlPullParserException {
        return null;
    }

    public String getPositionDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.fileName).append(": ");
        this.getPositionDescription(this.currentStartTag, stringBuilder);
        return stringBuilder.toString();
    }

    private void getPositionDescription(StartTag startTag, StringBuilder stringBuilder) {
        if (startTag != null) {
            this.getPositionDescription(startTag.parent, stringBuilder);
            stringBuilder.append(" #").append(startTag.position).append('<').append(startTag.name);
            for (int i = 0; i < startTag.attributes.length; ++i) {
                Attribute attribute = startTag.attributes[i];
                stringBuilder.append(' ').append(attribute.getName()).append("=\"").append(attribute.getValue()).append('\"');
            }
            stringBuilder.append('>');
        }
    }

    public String getPrefix() {
        return null;
    }

    public Object getProperty(String string) {
        return null;
    }

    public String getText() {
        return (String)this.currentEvent;
    }

    public char[] getTextCharacters(int[] nArray) {
        String string = this.getText();
        nArray[0] = 0;
        nArray[1] = string.length();
        return string.toCharArray();
    }

    public boolean isAttributeDefault(int n) {
        return false;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        return false;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        return this.getText().trim().isEmpty();
    }

    public int next() {
        if (this.iter == null) {
            if (this.currentStartTag != null) {
                throw new IllegalStateException("Unclosed XML tag: " + this.currentStartTag.name);
            }
            this.iter = this.events.iterator();
        }
        this.currentEvent = this.iter.next();
        int n = this.getEventType();
        switch (n) {
            case 2: {
                this.currentStartTag = (StartTag)this.currentEvent;
                ++this.depth;
                break;
            }
            case 3: {
                this.currentStartTag = this.currentStartTag.parent;
                --this.depth;
            }
        }
        return n;
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int n = this.next();
        if (n == 4 && this.isWhitespace()) {
            n = this.next();
        }
        if (n != 2 && n != 3) {
            throw new XmlPullParserException("expected start or end tag", (XmlPullParser)this, null);
        }
        return n;
    }

    public String nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw new XmlPullParserException("parser must be on START_TAG to read next text", (XmlPullParser)this, null);
        }
        int n = this.next();
        if (n == 4) {
            String string = this.getText();
            n = this.next();
            if (n != 3) {
                throw new XmlPullParserException("event TEXT it must be immediately followed by END_TAG", (XmlPullParser)this, null);
            }
            return string;
        }
        if (n == 3) {
            return "";
        }
        throw new XmlPullParserException("parser must be on START_TAG or TEXT to read text", (XmlPullParser)this, null);
    }

    public int nextToken() throws XmlPullParserException, IOException {
        return this.next();
    }

    public void require(int n, String string, String string2) throws XmlPullParserException, IOException {
        int n2 = this.getEventType();
        if (n != n2) {
            throw new XmlPullParserException("expected event " + this.getEventTypeStr(n) + " got " + this.getEventTypeStr(n2), (XmlPullParser)this, null);
        }
        if (string2 != null && !string2.equals(this.getName())) {
            throw new XmlPullParserException("expected name '" + string2 + "' got '" + this.getName() + "'", (XmlPullParser)this, null);
        }
    }

    private String getEventTypeStr(int n) {
        switch (n) {
            case 0: {
                return "START_DOCUMENT";
            }
            case 2: {
                return "START_TAG";
            }
            case 4: {
                return "TEXT";
            }
            case 3: {
                return "END_TAG";
            }
            case 1: {
                return "END_DOCUMENT";
            }
        }
        return "?";
    }

    public void setFeature(String string, boolean bl) throws XmlPullParserException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setInput(Reader reader) throws XmlPullParserException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setInput(InputStream inputStream, String string) throws XmlPullParserException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setProperty(String string, Object object) throws XmlPullParserException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static Attribute[] toArray(Collection<Attribute> collection) {
        return collection.toArray(new Attribute[collection.size()]);
    }

    static class EndTag {
        final String name;

        EndTag(String string) {
            this.name = string;
        }
    }

    static class StartTag {
        final String name;
        final Attribute[] attributes;
        final StartTag parent;
        final Object location;
        final int position;
        int numChildren;

        StartTag(String string, Attribute[] attributeArray, StartTag startTag, Object object, int n) {
            this.name = string;
            this.attributes = attributeArray;
            this.parent = startTag;
            this.location = object;
            this.position = n;
        }
    }
}

