/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.model.AbstractTableModel;
import de.matthiasmann.twl.model.TreeTableModel;
import de.matthiasmann.twl.model.TreeTableNode;
import java.util.ArrayList;

public class FilteredModel
extends AbstractTableModel {
    private final TreeTableModel model;
    private final ArrayList<TreeTableNode> rows;
    private Filter filter;

    public FilteredModel(TreeTableModel treeTableModel) {
        this.model = treeTableModel;
        this.rows = new ArrayList();
        this.updateList();
        treeTableModel.addChangeListener(new TreeTableModel.ChangeListener(){

            public void nodesAdded(TreeTableNode treeTableNode, int n, int n2) {
                FilteredModel.this.updateList();
            }

            public void nodesRemoved(TreeTableNode treeTableNode, int n, int n2) {
                FilteredModel.this.updateList();
            }

            public void nodesChanged(TreeTableNode treeTableNode, int n, int n2) {
                FilteredModel.this.updateList();
            }

            public void columnInserted(int n, int n2) {
                FilteredModel.this.fireColumnInserted(n, n2);
            }

            public void columnDeleted(int n, int n2) {
                FilteredModel.this.fireColumnDeleted(n, n2);
            }

            public void columnHeaderChanged(int n) {
                FilteredModel.this.fireColumnHeaderChanged(n);
            }
        });
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        this.updateList();
    }

    public String getColumnHeaderText(int n) {
        return this.model.getColumnHeaderText(n);
    }

    public int getNumColumns() {
        return this.model.getNumColumns();
    }

    public TreeTableNode getRow(int n) {
        return this.rows.get(n);
    }

    public Object getCell(int n, int n2) {
        return this.getRow(n).getData(n2);
    }

    public int getNumRows() {
        return this.rows.size();
    }

    public int getRowFromNode(TreeTableNode treeTableNode) {
        int n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            if (this.rows.get(i) != treeTableNode) continue;
            return i;
        }
        return -1;
    }

    void updateList() {
        this.rows.clear();
        this.updateList((TreeTableNode)this.model);
        this.fireAllChanged();
    }

    void updateList(TreeTableNode treeTableNode) {
        if (this.filter == null || this.filter.isVisible(treeTableNode)) {
            this.rows.add(treeTableNode);
        }
        int n = treeTableNode.getNumChildren();
        for (int i = 0; i < n; ++i) {
            this.updateList(treeTableNode.getChild(i));
        }
    }

    public static interface Filter {
        public boolean isVisible(TreeTableNode var1);
    }
}

