/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.utils.ParameterStringParser;
import de.matthiasmann.twlthemeeditor.TestEnv;
import de.matthiasmann.twlthemeeditor.VirtualFile;
import de.matthiasmann.twlthemeeditor.datamodel.DomWrapper;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.FontParam;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CloneNodeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewSimple;
import de.matthiasmann.twlthemeeditor.properties.AttributeProperty;
import de.matthiasmann.twlthemeeditor.properties.BooleanProperty;
import de.matthiasmann.twlthemeeditor.properties.ColorProperty;
import de.matthiasmann.twlthemeeditor.properties.HasProperties;
import de.matthiasmann.twlthemeeditor.properties.IntegerProperty;
import de.matthiasmann.twlthemeeditor.properties.NameProperty;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontDef
extends ThemeTreeNode
implements HasProperties {
    protected final ArrayList<VirtualFile> virtualFontFiles = new ArrayList();
    protected final NameProperty nameProperty;
    protected final Property<String> fileNameProperty;
    protected final BooleanProperty defaultProperty;

    public FontDef(ThemeFile themeFile, TreeTableNode treeTableNode, Element element) throws IOException {
        super(themeFile, treeTableNode, element);
        this.nameProperty = new NameProperty((Property)new AttributeProperty(element, "name"), this.getThemeTreeModel(), Kind.FONT, true){

            public void validateName(String string) throws IllegalArgumentException {
                if (string == null || string.length() == 0) {
                    throw new IllegalArgumentException("Empty name not allowed");
                }
            }
        };
        this.addProperty(this.nameProperty);
        this.fileNameProperty = new AttributeProperty(element, "filename", "Font file name", true);
        this.fileNameProperty.addValueChangedCallback(new Runnable(){

            public void run() {
                FontDef.this.registerFontFiles();
            }
        });
        this.addProperty(this.fileNameProperty);
        this.defaultProperty = new BooleanProperty((Property<String>)new AttributeProperty(element, "default", "Default font", true), false);
        this.addProperty(this.defaultProperty);
        FontDef.addCommonFontDefProperties(this, element);
        this.registerFontFiles();
    }

    @Override
    public String getDisplayName() {
        String string = this.getName();
        if (string != null) {
            if (this.defaultProperty.getValue()) {
                return string + " *";
            }
            return string;
        }
        return super.getDisplayName();
    }

    @Override
    public String getName() {
        return this.nameProperty.getPropertyValue();
    }

    @Override
    protected String getIcon() {
        return "fontdef";
    }

    @Override
    public Kind getKind() {
        return Kind.FONT;
    }

    public URL getFontFileURL() throws MalformedURLException {
        String string = (String)this.fileNameProperty.getPropertyValue();
        return string != null ? this.themeFile.getURL(string) : null;
    }

    @Override
    public void addChildren() throws IOException {
        this.addChildren(this.themeFile, this.element, new DomWrapperImpl());
    }

    @Override
    public void addToXPP(DomXPPParser domXPPParser) {
        Utils.addToXPP(domXPPParser, this.element.getName(), this, this.element.getAttributes());
    }

    @Override
    public boolean canPasteElement(Element element) {
        return FontDef.canPasteFontDefElement(element);
    }

    public static boolean canPasteFontDefElement(Element element) {
        return "fontParam".equals(element.getName());
    }

    @Override
    public List<ThemeTreeOperation> getOperations() {
        List<ThemeTreeOperation> list = super.getOperations();
        list.add(new CloneNodeOperation(this.element, (ThemeTreeNode)this){

            protected void adjustClonedElement(Element element) {
                super.adjustClonedElement(element);
                element.removeAttribute("default");
            }
        });
        return list;
    }

    @Override
    public List<CreateChildOperation> getCreateChildOperations() {
        List<CreateChildOperation> list = super.getCreateChildOperations();
        FontDef.addFontParamOperations(list, this, this.element);
        return list;
    }

    private void registerFontFiles() {
        try {
            FontDef.registerFontFiles(this.getThemeFile().getEnv(), this.virtualFontFiles, this.getFontFileURL());
        }
        catch (IOException iOException) {
            this.getRootThemeFile().logError("Could not load font", null, iOException);
        }
    }

    static void addCommonFontDefProperties(ThemeTreeNode themeTreeNode, Element element) {
        themeTreeNode.addProperty(new ColorProperty((Property<String>)new AttributeProperty(element, "color", "Font color", true)));
        themeTreeNode.addProperty(new IntegerProperty((Property<String>)new AttributeProperty(element, "offsetX", "Offset X", true), -100, 100));
        themeTreeNode.addProperty(new IntegerProperty((Property<String>)new AttributeProperty(element, "offsetY", "Offset Y", true), -100, 100));
        themeTreeNode.addProperty(new BooleanProperty((Property<String>)new AttributeProperty(element, "linethrough", "line through / striked", true), false));
        themeTreeNode.addProperty(new BooleanProperty((Property<String>)new AttributeProperty(element, "underline", "Underlined", true), false));
        themeTreeNode.addProperty(new IntegerProperty((Property<String>)new AttributeProperty(element, "underlineOffset", "Underline offset", true), -100, 100));
    }

    static void addFontParamOperations(List<CreateChildOperation> list, ThemeTreeNode themeTreeNode, Element element) {
        list.add(new CreateNewSimple(themeTreeNode, element, "fontParam", "if", "hover"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerFontFiles(TestEnv testEnv, ArrayList<VirtualFile> arrayList, URL uRL) throws IOException {
        block10: {
            testEnv.unregisterFiles(arrayList);
            arrayList.clear();
            if (uRL != null) {
                arrayList.add(testEnv.registerFile(uRL));
                InputStream inputStream = uRL.openStream();
                try {
                    String string;
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    bufferedInputStream.mark(1);
                    if (bufferedInputStream.read() != 105) {
                        bufferedInputStream.reset();
                        Document document = Utils.loadDocument(bufferedInputStream);
                        Element element = document.getRootElement().getChild("pages");
                        if (element != null) {
                            for (Object e : element.getChildren("page")) {
                                Element element2 = (Element)e;
                                String string2 = element2.getAttributeValue("file");
                                if (string2 == null) continue;
                                arrayList.add(testEnv.registerFile(new URL(uRL, string2)));
                            }
                        }
                        break block10;
                    }
                    bufferedInputStream.reset();
                    InputStreamReader inputStreamReader = new InputStreamReader(bufferedInputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.startsWith("page ")) {
                            ParameterStringParser parameterStringParser = new ParameterStringParser(string, ' ', '=');
                            while (parameterStringParser.next()) {
                                if (!"file".equals(parameterStringParser.getKey())) continue;
                                arrayList.add(testEnv.registerFile(new URL(uRL, parameterStringParser.getValue())));
                            }
                        }
                        if (!string.startsWith("char")) continue;
                        break;
                    }
                }
                finally {
                    inputStream.close();
                }
            }
        }
    }

    static class DomWrapperImpl
    implements DomWrapper {
        DomWrapperImpl() {
        }

        public TreeTableNode wrap(ThemeFile themeFile, ThemeTreeNode themeTreeNode, Element element) throws IOException {
            if ("fontParam".equals(element.getName())) {
                return new FontParam(themeFile, (TreeTableNode)themeTreeNode, element);
            }
            return null;
        }
    }
}

