/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.Border;
import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.Condition;
import de.matthiasmann.twlthemeeditor.datamodel.DomWrapper;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.Images;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.datamodel.images.Alias;
import de.matthiasmann.twlthemeeditor.datamodel.images.Animation;
import de.matthiasmann.twlthemeeditor.datamodel.images.Area;
import de.matthiasmann.twlthemeeditor.datamodel.images.Composed;
import de.matthiasmann.twlthemeeditor.datamodel.images.Cursor;
import de.matthiasmann.twlthemeeditor.datamodel.images.CursorRef;
import de.matthiasmann.twlthemeeditor.datamodel.images.Grid;
import de.matthiasmann.twlthemeeditor.datamodel.images.Select;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CloneNodeOperation;
import de.matthiasmann.twlthemeeditor.properties.AttributeProperty;
import de.matthiasmann.twlthemeeditor.properties.BooleanProperty;
import de.matthiasmann.twlthemeeditor.properties.BorderProperty;
import de.matthiasmann.twlthemeeditor.properties.ColorProperty;
import de.matthiasmann.twlthemeeditor.properties.ConditionProperty;
import de.matthiasmann.twlthemeeditor.properties.HasProperties;
import de.matthiasmann.twlthemeeditor.properties.IntegerProperty;
import de.matthiasmann.twlthemeeditor.properties.NameProperty;
import de.matthiasmann.twlthemeeditor.properties.RectProperty;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Image
extends ThemeTreeNode
implements HasProperties {
    protected final Images textures;
    protected final NameProperty nameProperty;
    protected ConditionProperty conditionProperty;

    protected Image(Images images, TreeTableNode treeTableNode, Element element) {
        super(images.getThemeFile(), treeTableNode, element);
        this.textures = images;
        if (treeTableNode == images) {
            this.nameProperty = new ImageNameProperty(element);
            this.addProperty(this.nameProperty);
        } else {
            this.nameProperty = null;
        }
    }

    @Override
    public Kind getKind() {
        return Kind.IMAGE;
    }

    @Override
    public void addToXPP(DomXPPParser domXPPParser) {
        domXPPParser.addElement(this, this.element);
    }

    protected void addStandardProperties() {
        this.conditionProperty = new ConditionProperty((Property<String>)new AttributeProperty(this.element, "if", "Condition", true), (Property<String>)new AttributeProperty(this.element, "unless", "Condition", true), "Condition");
        this.addProperty(this.conditionProperty);
        this.addProperty(new BooleanProperty((Property<String>)new AttributeProperty(this.element, "center", "Centered", true), false));
        this.addProperty(new BorderProperty((Property<String>)new AttributeProperty(this.element, "border", "Border", true), 0, false));
        this.addProperty(new BorderProperty((Property<String>)new AttributeProperty(this.element, "inset", "Inset", true), Short.MIN_VALUE, false));
        this.addProperty(new ColorProperty((Property<String>)new AttributeProperty(this.element, "tint", "Tint color", true)));
        this.addProperty(new IntegerProperty((Property<String>)new AttributeProperty(this.element, "sizeOverwriteH", "Size overwrite horizontal", true), 0, Short.MAX_VALUE));
        this.addProperty(new IntegerProperty((Property<String>)new AttributeProperty(this.element, "sizeOverwriteV", "Size overwrite vertical", true), 0, Short.MAX_VALUE));
        this.addProperty(new BooleanProperty((Property<String>)new AttributeProperty(this.element, "repeatX", "Repeat horizontal", true), false));
        this.addProperty(new BooleanProperty((Property<String>)new AttributeProperty(this.element, "repeatY", "Repeat vertical", true), false));
    }

    @Override
    public String getName() {
        return this.nameProperty != null ? this.nameProperty.getPropertyValue() : null;
    }

    public Condition getCondition() {
        return this.conditionProperty != null ? this.conditionProperty.getPropertyValue() : Condition.NONE;
    }

    public final Images getTextures() {
        return this.textures;
    }

    public final Image getLimit() {
        Image image = this;
        while (image.getParent() instanceof Image) {
            image = (Image)image.getParent();
        }
        return image;
    }

    @Override
    public void addChildren() throws IOException {
        this.addChildren(this.textures.getThemeFile(), this.element, Image.getImageDomWrapper(this.textures));
    }

    @Override
    public List<ThemeTreeOperation> getOperations() {
        List<ThemeTreeOperation> list = super.getOperations();
        list.add(new CloneNodeOperation(this.element, this));
        return list;
    }

    public static void convertToXYWH(ThemeFile themeFile, Element element) {
        if (element.getAttributeValue("xywh") == null) {
            String string = element.getAttributeValue("x");
            String string2 = element.getAttributeValue("y");
            String string3 = element.getAttributeValue("width");
            String string4 = element.getAttributeValue("height");
            element.setAttribute("xywh", string + "," + string2 + "," + string3 + "," + string4);
            element.removeAttribute("x");
            element.removeAttribute("y");
            element.removeAttribute("width");
            element.removeAttribute("height");
            themeFile.elementUpgraded();
        }
    }

    public static void convertSplitX(ThemeFile themeFile, Element element) {
        if (element.getAttributeValue("splitx") == null) {
            String string = element.getAttributeValue("border");
            int n = 0;
            int n2 = 0;
            try {
                Border border = Utils.parseBorder(string);
                if (border != null) {
                    n = border.getBorderLeft();
                    n2 = border.getBorderRight();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                themeFile.logError("Could not parse border", string, illegalArgumentException);
            }
            element.setAttribute("splitx", "L" + n + ",R" + n2);
            themeFile.elementUpgraded();
        }
    }

    public static void convertSplitY(ThemeFile themeFile, Element element) {
        if (element.getAttributeValue("splity") == null) {
            String string = element.getAttributeValue("border");
            int n = 0;
            int n2 = 0;
            try {
                Border border = Utils.parseBorder(string);
                if (border != null) {
                    n = border.getBorderTop();
                    n2 = border.getBorderBottom();
                }
            }
            catch (NumberFormatException numberFormatException) {
                themeFile.logError("Could not parse border", string, numberFormatException);
            }
            element.setAttribute("splity", "T" + n + ",B" + n2);
            themeFile.elementUpgraded();
        }
    }

    public static DomWrapper getImageDomWrapper(final Images images) {
        return new DomWrapper(){

            public TreeTableNode wrap(ThemeFile themeFile, ThemeTreeNode themeTreeNode, Element element) throws IOException {
                Image image = this.createChild(themeFile, themeTreeNode, element);
                if (image != null && image.getKind() != Kind.CURSOR) {
                    image.addStandardProperties();
                }
                return image;
            }

            public Image createChild(ThemeFile themeFile, ThemeTreeNode themeTreeNode, Element element) throws IOException {
                String string = element.getName();
                if ("area".equals(string)) {
                    return new Area(images, (TreeTableNode)themeTreeNode, element);
                }
                if ("alias".equals(string)) {
                    return new Alias(images, (TreeTableNode)themeTreeNode, element);
                }
                if ("select".equals(string)) {
                    return new Select(images, (TreeTableNode)themeTreeNode, element);
                }
                if ("composed".equals(string)) {
                    return new Composed(images, (TreeTableNode)themeTreeNode, element);
                }
                if ("grid".equals(string)) {
                    return new Grid(images, themeTreeNode, element);
                }
                if ("cursor".equals(string)) {
                    if (element.getAttribute("ref") != null) {
                        return new CursorRef(images, (TreeTableNode)themeTreeNode, element);
                    }
                    Image.convertToXYWH(themeFile, element);
                    return new Cursor(images, (TreeTableNode)themeTreeNode, element);
                }
                if ("animation".equals(string)) {
                    return new Animation(images, (TreeTableNode)themeTreeNode, element);
                }
                if ("texture".equals(string)) {
                    return this.upgradeTexture(themeFile, themeTreeNode, element);
                }
                if ("hsplit".equals(string)) {
                    return this.upgradeHSplit(themeFile, themeTreeNode, element);
                }
                if ("vsplit".equals(string)) {
                    return this.upgradeVSplit(themeFile, themeTreeNode, element);
                }
                if ("hvsplit".equals(string)) {
                    return this.upgradeHVSplit(themeFile, themeTreeNode, element);
                }
                return null;
            }

            private Image upgradeTexture(ThemeFile themeFile, ThemeTreeNode themeTreeNode, Element element) {
                element.setName("area");
                Image.convertToXYWH(themeFile, element);
                themeFile.elementUpgraded();
                return new Area(images, (TreeTableNode)themeTreeNode, element);
            }

            private Image upgradeHSplit(ThemeFile themeFile, ThemeTreeNode themeTreeNode, Element element) {
                element.setName("area");
                Image.convertToXYWH(themeFile, element);
                Image.convertSplitX(themeFile, element);
                themeFile.elementUpgraded();
                return new Area(images, (TreeTableNode)themeTreeNode, element);
            }

            private Image upgradeVSplit(ThemeFile themeFile, ThemeTreeNode themeTreeNode, Element element) {
                element.setName("area");
                Image.convertToXYWH(themeFile, element);
                Image.convertSplitY(themeFile, element);
                themeFile.elementUpgraded();
                return new Area(images, (TreeTableNode)themeTreeNode, element);
            }

            private Image upgradeHVSplit(ThemeFile themeFile, ThemeTreeNode themeTreeNode, Element element) {
                element.setName("area");
                Image.convertToXYWH(themeFile, element);
                Image.convertSplitX(themeFile, element);
                Image.convertSplitY(themeFile, element);
                themeFile.elementUpgraded();
                return new Area(images, (TreeTableNode)themeTreeNode, element);
            }
        };
    }

    protected class ImageNameProperty
    extends NameProperty {
        public ImageNameProperty(Element element) {
            super((Property<String>)new AttributeProperty(element, "name"), Image.this.getThemeTreeModel(), Image.this.getKind(), true);
        }

        public void validateName(String string) throws IllegalArgumentException {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("empty name not allowed");
            }
            if ("none".equals(string)) {
                throw new IllegalArgumentException("\"none\" is a reserved name");
            }
            if (Image.this.getThemeTreeModel().findImage(Image.this.getKind(), string, Image.this) != null) {
                throw new IllegalArgumentException("Name \"" + string + "\" already in use");
            }
        }
    }

    protected class ImageRectProperty
    extends RectProperty {
        public ImageRectProperty(Element element) {
            super((Property<String>)new AttributeProperty(element, "xywh"), "rect");
        }

        public Dimension getLimit() {
            return Image.this.textures.getTextureDimensions();
        }
    }
}

