/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.renderer.lwjgl.PNGDecoder;
import de.matthiasmann.twlthemeeditor.TestEnv;
import de.matthiasmann.twlthemeeditor.VirtualFile;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.Image;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewArea;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewSimple;
import de.matthiasmann.twlthemeeditor.properties.AttributeProperty;
import de.matthiasmann.twlthemeeditor.properties.HasProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Images
extends ThemeTreeNode
implements HasProperties {
    private Dimension textureDimensions;
    private AttributeProperty commentProperty;
    protected VirtualFile textureVirtualFile;
    private static final String[] ALLOWED_CHILDREN = new String[]{"area", "select", "composed", "grid", "animation", "alias"};

    Images(TreeTableNode treeTableNode, Element element, ThemeFile themeFile) throws IOException {
        super(themeFile, treeTableNode, element);
        this.registerTextureURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerTextureURL() throws IOException {
        URL uRL;
        TestEnv testEnv = this.themeFile.getEnv();
        if (this.textureVirtualFile != null) {
            testEnv.unregisterFile(this.textureVirtualFile);
            this.textureVirtualFile = null;
        }
        if ((uRL = this.getTextureURL()) != null) {
            this.textureVirtualFile = testEnv.registerFile(uRL);
            InputStream inputStream = uRL.openStream();
            try {
                PNGDecoder pNGDecoder = new PNGDecoder(inputStream);
                this.textureDimensions = new Dimension(pNGDecoder.getWidth(), pNGDecoder.getHeight());
            }
            finally {
                inputStream.close();
            }
        }
        this.commentProperty = new AttributeProperty(this.element, "comment", "Comment", true);
        this.addProperty((Property<?>)this.commentProperty);
    }

    public URL getTextureURL() throws MalformedURLException {
        String string = this.getFile();
        if (string != null) {
            return this.themeFile.getURL(string);
        }
        return null;
    }

    public void updateTextureDimension(URL uRL, int n, int n2) {
        if (n != this.textureDimensions.getX() && n2 != this.textureDimensions.getY()) {
            try {
                if (uRL.equals(this.getTextureURL())) {
                    this.textureDimensions = new Dimension(n, n2);
                }
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(Images.class.getName()).log(Level.SEVERE, "Could not compare URLs", malformedURLException);
            }
        }
    }

    public String getFile() {
        return this.element.getAttributeValue("file");
    }

    public String getFormat() {
        return this.element.getAttributeValue("format");
    }

    @Override
    public String toString() {
        return "[Images file=\"" + this.getFile() + "\"]";
    }

    @Override
    public String getName() {
        return this.getFile();
    }

    @Override
    protected String getIcon() {
        return "images";
    }

    @Override
    public String getDisplayName() {
        String string = this.commentProperty.getPropertyValue();
        String string2 = this.getName();
        if (string != null) {
            string = string.trim();
        }
        if (string != null && string.length() > 0) {
            if (string2 != null) {
                return string + " (" + string2 + ")";
            }
            return string;
        }
        if (string2 != null) {
            return string2;
        }
        return "<add comment>";
    }

    @Override
    public Kind getKind() {
        return Kind.NONE;
    }

    @Override
    protected String getType() {
        return "PNG";
    }

    public Dimension getTextureDimensions() {
        return this.textureDimensions;
    }

    public static boolean isAllowedChildImage(String string) {
        for (String string2 : ALLOWED_CHILDREN) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canPasteElement(Element element) {
        String string = element.getName();
        return Images.isAllowedChildImage(string) || "cursor".equals(string);
    }

    @Override
    public boolean childrenNeedName() {
        return true;
    }

    @Override
    public void addChildren() throws IOException {
        this.addChildren(this.themeFile, this.element, Image.getImageDomWrapper(this));
    }

    @Override
    public void addToXPP(DomXPPParser domXPPParser) {
        Utils.addToXPP(domXPPParser, this.element.getName(), this, this.element.getAttributes());
    }

    @Override
    public List<CreateChildOperation> getCreateChildOperations() {
        List<CreateChildOperation> list = super.getCreateChildOperations();
        Images.addCreateImageOperations(list, this);
        return list;
    }

    public static void addCreateImageOperations(List<CreateChildOperation> list, ThemeTreeNode themeTreeNode) {
        list.add(new CreateNewArea(themeTreeNode, themeTreeNode.getDOMElement(), "area", new String[0]));
        list.add(new CreateNewSimple(themeTreeNode, themeTreeNode.getDOMElement(), "select", new String[0]));
        list.add(new CreateNewSimple(themeTreeNode, themeTreeNode.getDOMElement(), "composed", new String[0]));
        list.add(new CreateNewSimple(themeTreeNode, themeTreeNode.getDOMElement(), "grid", "weightsX", "0,1,0", "weightsY", "0,1,0"));
        list.add(new CreateNewSimple(themeTreeNode, themeTreeNode.getDOMElement(), "animation", "timeSource", "hover"));
        list.add(new CreateNewSimple(themeTreeNode, themeTreeNode.getDOMElement(), "alias", "ref", "none"));
        list.add(new CreateNewArea(themeTreeNode, themeTreeNode.getDOMElement(), "cursor", "hotSpotX", "0", "hotSpotY", "0"));
        list.add(new CreateNewSimple("opNewNodeCursorAlias", themeTreeNode, themeTreeNode.getDOMElement(), "cursor", "ref", "none"));
    }
}

