/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Include
extends ThemeTreeNode {
    private final ThemeFile includedThemeFile;

    public Include(TreeTableNode treeTableNode, Element element, ThemeFile themeFile) throws IOException {
        super(themeFile, treeTableNode, element);
        this.includedThemeFile = themeFile.createThemeFile(this.getFileName());
    }

    @Override
    public String getName() {
        return this.getFileName();
    }

    @Override
    protected String getIcon() {
        return "include";
    }

    @Override
    public Kind getKind() {
        return Kind.NONE;
    }

    @Override
    protected boolean isModified() {
        return this.includedThemeFile.isModified();
    }

    public String getFileName() {
        return this.element.getAttributeValue("filename");
    }

    @Override
    public void addChildren() throws IOException {
        this.includedThemeFile.addChildren(this);
    }

    @Override
    public void addToXPP(DomXPPParser domXPPParser) {
        domXPPParser.addElement((Object)this, this.element);
    }

    public ThemeFile getIncludedThemeFile() {
        return this.includedThemeFile;
    }

    @Override
    public List<CreateChildOperation> getCreateChildOperations() {
        List<CreateChildOperation> list = super.getCreateChildOperations();
        this.includedThemeFile.addCreateOperations(list, this);
        return list;
    }
}

