/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.DomWrapper;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.InputMapAction;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.Param;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CloneNodeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import de.matthiasmann.twlthemeeditor.properties.AttributeProperty;
import de.matthiasmann.twlthemeeditor.properties.DerivedNodeReferenceProperty;
import de.matthiasmann.twlthemeeditor.properties.HasProperties;
import de.matthiasmann.twlthemeeditor.properties.NameProperty;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputMapDef
extends ThemeTreeNode
implements HasProperties {
    protected final NameProperty nameProperty;
    protected final DerivedNodeReferenceProperty refProperty;

    public InputMapDef(ThemeFile themeFile, TreeTableNode treeTableNode, Element element) {
        super(themeFile, treeTableNode, element);
        this.nameProperty = new NameProperty((Property)new AttributeProperty(element, "name"), this.getThemeTreeModel(), Kind.INPUTMAP, true){

            public void validateName(String string) throws IllegalArgumentException {
                if (string == null || string.length() == 0) {
                    throw new IllegalArgumentException("Empty name not allowed");
                }
            }
        };
        this.addProperty(this.nameProperty);
        this.refProperty = new DerivedNodeReferenceProperty((Property<String>)new AttributeProperty(element, "ref", "Base input map reference", true), this, Kind.INPUTMAP);
        this.addProperty(this.refProperty);
    }

    @Override
    public void addChildren() throws IOException {
        this.addChildren(this.themeFile, this.element, new DomWrapperImpl());
    }

    @Override
    public void addToXPP(DomXPPParser domXPPParser) {
        Utils.addToXPP(domXPPParser, this.element.getName(), this, this.element.getAttributes());
    }

    @Override
    public Kind getKind() {
        return Kind.INPUTMAP;
    }

    @Override
    public String getName() {
        return this.nameProperty.getPropertyValue();
    }

    @Override
    protected String getIcon() {
        return "inputmapdef";
    }

    @Override
    public boolean canPasteElement(Element element) {
        return InputMapDef.canPasteInputMapDefElement(element);
    }

    public static boolean canPasteInputMapDefElement(Element element) {
        return "action".equals(element.getName());
    }

    @Override
    public boolean childrenNeedName() {
        return true;
    }

    @Override
    public List<ThemeTreeOperation> getOperations() {
        List<ThemeTreeOperation> list = super.getOperations();
        list.add(new CloneNodeOperation(this.element, this));
        return list;
    }

    @Override
    public List<CreateChildOperation> getCreateChildOperations() {
        List<CreateChildOperation> list = super.getCreateChildOperations();
        InputMapDef.addInputMapActionOperations(list, this, this.element);
        return list;
    }

    static void addInputMapActionOperations(List<CreateChildOperation> list, ThemeTreeNode themeTreeNode, Element element) {
        list.add(new CreateChildOperation("opNewNodeInputMapAction", themeTreeNode, element){

            public ThemeTreeNode executeAt(Object[] objectArray, int n) throws IOException {
                Element element = new Element("action");
                element.setAttribute("name", "changeMe");
                element.setText("F12");
                return this.addChild(element, n);
            }

            protected int getBaseIndentation() {
                int n = super.getBaseIndentation();
                if (this.parent instanceof Param) {
                    n = Math.max(0, n - 4);
                }
                return n;
            }
        });
    }

    static class DomWrapperImpl
    implements DomWrapper {
        DomWrapperImpl() {
        }

        public TreeTableNode wrap(ThemeFile themeFile, ThemeTreeNode themeTreeNode, Element element) throws IOException {
            if ("action".equals(element.getName())) {
                return new InputMapAction(themeFile, (TreeTableNode)themeTreeNode, element);
            }
            return null;
        }
    }
}

