/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

public class Split {
    private final Point split1;
    private final Point split2;

    public Split(Point point, Point point2) {
        this.split1 = point;
        this.split2 = point2;
    }

    public Split(String string) {
        int n = string.indexOf(44);
        if (n < 0) {
            throw new IllegalArgumentException("Need 2 integers");
        }
        this.split1 = new Point(string.substring(0, n).trim());
        this.split2 = new Point(string.substring(n + 1).trim());
    }

    public Point getPoint1() {
        return this.split1;
    }

    public Point getPoint2() {
        return this.split2;
    }

    public Point getPoint(int n) {
        switch (n) {
            case 0: {
                return this.split1;
            }
            case 1: {
                return this.split2;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Split setPoint(int n, Point point) {
        switch (n) {
            case 0: {
                return new Split(point, this.split2);
            }
            case 1: {
                return new Split(this.split1, point);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public String toString() {
        return this.toString(Axis.HORIZONTAL);
    }

    public String toString(Axis axis) {
        return "" + axis.edgeCharacter(this.split1.edge) + this.split1.pos + ',' + axis.edgeCharacter(this.split2.edge) + this.split2.pos;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Axis {
        HORIZONTAL("LR"),
        VERTICAL("TB");

        final String edgeCharacters;

        private Axis(String string2) {
            this.edgeCharacters = string2;
        }

        char edgeCharacter(boolean bl) {
            return this.edgeCharacters.charAt(bl ? 1 : 0);
        }
    }

    public static class Point {
        final int pos;
        final boolean edge;

        public Point(int n, boolean bl) {
            this.pos = n;
            this.edge = bl;
        }

        public Point(String string) {
            if (string.length() == 0) {
                throw new IllegalArgumentException("empty string");
            }
            switch (string.charAt(0)) {
                case 'L': 
                case 'T': 
                case 'l': 
                case 't': {
                    this.edge = false;
                    string = string.substring(1).trim();
                    break;
                }
                case 'B': 
                case 'R': 
                case 'b': 
                case 'r': {
                    this.edge = true;
                    string = string.substring(1).trim();
                    break;
                }
                default: {
                    this.edge = false;
                }
            }
            this.pos = Integer.parseInt(string);
        }

        public boolean isOtherEdge() {
            return this.edge;
        }

        public int getPos() {
            return this.pos;
        }

        public int convertToPX(int n) {
            if (this.edge) {
                return n - this.pos;
            }
            return this.pos;
        }

        public Point movePX(int n) {
            if (this.edge) {
                return new Point(this.pos - n, true);
            }
            return new Point(this.pos + n, false);
        }

        public Point setOtherEdge(boolean bl, int n) {
            if (this.edge != bl) {
                return new Point(n - this.pos, bl);
            }
            return this;
        }

        public Point setPos(int n) {
            return new Point(n, this.edge);
        }
    }
}

