/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.model.AbstractTreeTableModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twlthemeeditor.TestEnv;
import de.matthiasmann.twlthemeeditor.datamodel.Image;
import de.matthiasmann.twlthemeeditor.datamodel.Images;
import de.matthiasmann.twlthemeeditor.datamodel.Include;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeRootNode;
import de.matthiasmann.twlthemeeditor.datamodel.TreeTablePath;
import de.matthiasmann.twlthemeeditor.gui.MessageLog;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeTreeModel
extends AbstractTreeTableModel {
    private final Runnable xmlChangedCB = new Runnable(){

        public void run() {
            ThemeTreeModel.this.fireCallbacks(CallbackReason.ATTRIBUTE_CHANGED);
        }
    };
    private final ThemeFile rootThemeFile;
    private final ThemeTreeRootNode rootNode;
    private ThemeTreeNode curErrorLocation;
    private CallbackWithReason<?>[] callbacks;
    private static final String[] COLUMN_HEADER = new String[]{"Name", "Type"};

    public ThemeTreeModel(MessageLog messageLog, URL uRL) throws IOException {
        this.rootThemeFile = new ThemeFile(messageLog, null, new TestEnv(), uRL, this.xmlChangedCB);
        this.rootNode = new ThemeTreeRootNode(this.rootThemeFile, (TreeTableNode)this);
        this.insertChild((TreeTableNode)this.rootNode, 0);
        this.rootNode.addChildren();
    }

    public String getColumnHeaderText(int n) {
        return COLUMN_HEADER[n];
    }

    public int getNumColumns() {
        return COLUMN_HEADER.length;
    }

    public ThemeFile getRootThemeFile() {
        return this.rootThemeFile;
    }

    public <E extends TreeTableNode> List<E> getTopLevelNodes(Class<E> clazz, TreeTableNode treeTableNode) {
        TreeTablePath treeTablePath = TreeTablePath.create(treeTableNode);
        ArrayList arrayList = new ArrayList();
        this.processInclude((TreeTableNode)this.rootNode, clazz, arrayList, treeTablePath);
        return arrayList;
    }

    public List<Image> getImages(TreeTableNode treeTableNode) {
        TreeTablePath treeTablePath = TreeTablePath.create(treeTableNode);
        ArrayList<Image> arrayList = new ArrayList<Image>();
        block0: for (Images images : this.getTopLevelNodes(Images.class, null)) {
            for (Image image : images.getChildren(Image.class)) {
                if (treeTablePath != null && treeTablePath.compareTo((TreeTableNode)image) <= 0) break block0;
                arrayList.add(image);
            }
        }
        return arrayList;
    }

    public <E extends ThemeTreeNode> E findTopLevelNodes(Class<E> clazz, String string, E e) {
        for (ThemeTreeNode themeTreeNode : this.getTopLevelNodes(clazz, null)) {
            if (themeTreeNode == e || !string.equals(themeTreeNode.getName())) continue;
            return (E)((Object)themeTreeNode);
        }
        return null;
    }

    public Image findImage(Kind kind, String string, Image image) {
        for (Image image2 : this.getImages(null)) {
            if (image2 == image || image2.getKind() != kind || !string.equals(image2.getName())) continue;
            return image2;
        }
        return null;
    }

    public void setErrorLocation(ThemeTreeNode themeTreeNode) {
        if (this.curErrorLocation != null) {
            this.curErrorLocation.setError(false);
        }
        this.curErrorLocation = themeTreeNode;
        if (this.curErrorLocation != null) {
            this.curErrorLocation.setError(true);
        }
    }

    private <E extends TreeTableNode> void processInclude(TreeTableNode treeTableNode, Class<E> clazz, List<E> list, TreeTablePath treeTablePath) {
        int n = treeTableNode.getNumChildren();
        for (int i = 0; i < n; ++i) {
            TreeTableNode treeTableNode2 = treeTableNode.getChild(i);
            if (treeTablePath != null && treeTablePath.compareTo(treeTableNode2) <= 0) break;
            if (clazz.isInstance(treeTableNode2)) {
                list.add(clazz.cast(treeTableNode2));
            }
            if (!(treeTableNode2 instanceof Include)) continue;
            this.processInclude((TreeTableNode)((Include)treeTableNode2), clazz, list, treeTablePath);
        }
    }

    public void handleNodeRenamed(String string, String string2, Kind kind) {
        this.rootNode.handleNodeRenamed(string, string2, kind);
    }

    public ThemeTreeNode findNode(String string, Kind kind) {
        return this.rootNode.findNode(string, kind);
    }

    public void collectNodes(String string, Kind kind, Collection<ThemeTreeNode> collection) {
        this.rootNode.collectNodes(string, kind, collection);
    }

    public void addCallback(CallbackWithReason<CallbackReason> callbackWithReason) {
        this.callbacks = (CallbackWithReason[])CallbackSupport.addCallbackToList((Object[])this.callbacks, callbackWithReason, CallbackWithReason.class);
    }

    public void removeCallbacks(CallbackWithReason<CallbackReason> callbackWithReason) {
        this.callbacks = (CallbackWithReason[])CallbackSupport.removeCallbackFromList((Object[])this.callbacks, callbackWithReason);
    }

    void fireCallbacks(CallbackReason callbackReason) {
        CallbackSupport.fireCallbacks(this.callbacks, (Enum)callbackReason);
    }

    protected void fireNodesAdded(TreeTableNode treeTableNode, int n, int n2) {
        super.fireNodesAdded(treeTableNode, n, n2);
        this.fireCallbacks(CallbackReason.STRUCTURE_CHANGED);
    }

    protected void fireNodesRemoved(TreeTableNode treeTableNode, int n, int n2) {
        super.fireNodesRemoved(treeTableNode, n, n2);
        this.fireCallbacks(CallbackReason.STRUCTURE_CHANGED);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CallbackReason {
        ATTRIBUTE_CHANGED,
        STRUCTURE_CHANGED;

    }
}

