/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel.operations;

import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNewParam
extends CreateChildOperation {
    private final String tagName;
    private final String initialText;
    private static final HashMap<String, String[]> NAME_LIST = new HashMap();

    public CreateNewParam(Element element, String string, ThemeTreeNode themeTreeNode, String string2) {
        this("opNewParam" + Utils.capitalize(string), themeTreeNode, element, string, string2);
        this.indentChildren = "map".equals(string);
    }

    protected CreateNewParam(String string, ThemeTreeNode themeTreeNode, Element element, String string2, String string3) {
        super(string, themeTreeNode, element);
        this.tagName = string2;
        this.initialText = string3;
    }

    @Override
    public ThemeTreeNode executeAt(Object[] objectArray, int n) throws IOException {
        Element element = new Element("param");
        element.setAttribute("name", this.makeName());
        Element element2 = new Element(this.tagName);
        this.initParamElement(element2, objectArray);
        element.addContent((Content)element2);
        return this.addChild(element, n);
    }

    protected void initParamElement(Element element, Object[] objectArray) {
        element.setText(this.initialText);
    }

    protected String makeName() {
        String[] stringArray = NAME_LIST.get(this.tagName);
        return this.makeName(stringArray);
    }

    protected String makeName(String ... stringArray) {
        if (stringArray != null) {
            HashSet<String> hashSet = this.findUsedNames();
            for (String string : stringArray) {
                if (hashSet.contains(string)) continue;
                return string;
            }
            for (int i = 2; i < 10; ++i) {
                String string = stringArray[0] + i;
                if (hashSet.contains(string)) continue;
                return string;
            }
        }
        return this.makeRandomName();
    }

    protected HashSet<String> findUsedNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object e : this.element.getChildren("param")) {
            Element element = (Element)e;
            hashSet.add(element.getAttributeValue("name"));
        }
        return hashSet;
    }

    static {
        NAME_LIST.put("image", new String[]{"background", "overlay"});
        NAME_LIST.put("string", new String[]{"text", "tooltip"});
        NAME_LIST.put("border", new String[]{"border"});
        NAME_LIST.put("font", new String[]{"font"});
        NAME_LIST.put("cursor", new String[]{"mouseCursor"});
        NAME_LIST.put("int", new String[]{"maxWidth", "maxHeight", "minWidth", "minHeight"});
        NAME_LIST.put("inputMap", new String[]{"inputMap"});
        NAME_LIST.put("inputMapDef", new String[]{"inputMap"});
    }
}

