/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel.operations;

import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeOperation;
import java.io.IOException;
import org.jdom.Content;
import org.jdom.Element;

abstract class ElementOperation
extends ThemeTreeOperation {
    protected final Element element;
    protected final Element parent;
    protected final ThemeTreeNode node;

    protected ElementOperation(String string, Element element, ThemeTreeNode themeTreeNode) {
        super(string);
        this.element = element;
        this.parent = element.getParentElement();
        this.node = themeTreeNode;
    }

    protected ThemeTreeNode getNodeParent() {
        return (ThemeTreeNode)this.node.getParent();
    }

    protected int getElementPosition() {
        int n = this.parent.getContentSize();
        for (int i = 0; i < n; ++i) {
            if (this.parent.getContent(i) != this.element) continue;
            return i;
        }
        return -1;
    }

    protected int getPrevSiblingPosition(int n) {
        while (--n >= 0 && !(this.parent.getContent(n) instanceof Element)) {
        }
        return n;
    }

    protected int getNextSiblingPosition(int n) {
        int n2 = this.parent.getContentSize();
        while (++n < n2 && !(this.parent.getContent(n) instanceof Element)) {
        }
        return n;
    }

    protected void updateParent() throws IOException {
        this.getNodeParent().addChildren();
        ElementOperation.setModified(this.parent);
    }

    protected static void setModified(Element element) {
        ThemeFile themeFile = ThemeFile.getThemeFile((Content)element);
        if (themeFile != null) {
            themeFile.setModified(true);
        }
    }
}

