/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel.operations;

import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.operations.ElementOperation;
import java.io.IOException;
import org.jdom.Content;
import org.jdom.Element;

public class MoveNodeOperations
extends ElementOperation {
    private final int direction;

    public MoveNodeOperations(String string, Element element, ThemeTreeNode themeTreeNode, int n) {
        super(string, element, themeTreeNode);
        this.direction = n;
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean isEnabled() {
        TreeTableNode treeTableNode = this.node.getParent();
        int n = treeTableNode.getChildIndex((TreeTableNode)this.node);
        return this.direction > 0 && n < treeTableNode.getNumChildren() - 1 || this.direction < 0 && n > 0;
    }

    public ThemeTreeNode execute(Object[] objectArray) throws IOException {
        int n = this.getElementPosition();
        int n2 = this.getPrevSiblingPosition(n) + 1;
        if (this.direction < 0) {
            int n3 = this.getPrevSiblingPosition(n2 - 1) + 1;
            if (n3 >= 0 && n3 < n2) {
                this.moveContent(n2, n3, n - n2 + 1);
            }
        } else {
            int n4 = this.getNextSiblingPosition(n);
            if (n4 > n && n4 < this.element.getParent().getContentSize()) {
                this.moveContent(n2, n4, n - n2 + 1);
            }
        }
        return this.node;
    }

    protected void moveContent(int n, int n2, int n3) throws IOException {
        if (n < n2) {
            while (n3 > 0) {
                Content content = this.parent.removeContent(n);
                this.parent.addContent(n2, content);
                --n3;
            }
        } else if (n > n2) {
            while (n3 > 0) {
                Content content = this.parent.removeContent(n++);
                this.parent.addContent(n2++, content);
                --n3;
            }
        }
        this.updateParent();
    }
}

