/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Properties;

public class CharSet {
    private static final String KEY_MANUAL = "ChatSetManual";
    private final HashMap<Character.UnicodeBlock, Boolean> blocks = new HashMap();
    private final BitSet manualCharactersBitSet = new BitSet();
    private String manualCharacters = "";

    public CharSet() {
    }

    public CharSet(CharSet charSet) {
        this();
        this.blocks.putAll(charSet.blocks);
        this.manualCharactersBitSet.or(charSet.manualCharactersBitSet);
        this.manualCharacters = charSet.manualCharacters;
    }

    public void setBlock(Character.UnicodeBlock unicodeBlock, boolean bl) {
        this.blocks.put(unicodeBlock, bl);
    }

    public boolean getBlockEnabled(Character.UnicodeBlock unicodeBlock) {
        return this.blocks.get(unicodeBlock) == Boolean.TRUE;
    }

    public String getManualCharacters() {
        return this.manualCharacters;
    }

    public void setManualCharacters(String string) {
        this.manualCharacters = string;
        this.manualCharactersBitSet.clear();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.manualCharactersBitSet.set(string.charAt(i));
        }
    }

    public boolean isIncluded(int n) {
        return this.manualCharactersBitSet.get(n) || this.getBlockEnabled(Character.UnicodeBlock.of(n));
    }

    public boolean isIncluded(int[] nArray) {
        for (int n : nArray) {
            if (!this.isIncluded(n)) continue;
            return true;
        }
        return false;
    }

    public void save(Properties properties) {
        for (Character.UnicodeBlock unicodeBlock : CharSet.getSupportedBlocks()) {
            properties.setProperty(CharSet.getKey(unicodeBlock), Boolean.toString(this.getBlockEnabled(unicodeBlock)));
        }
        properties.setProperty(KEY_MANUAL, this.getManualCharacters());
    }

    public void load(Properties properties) {
        this.blocks.clear();
        for (Character.UnicodeBlock unicodeBlock : CharSet.getSupportedBlocks()) {
            if (!"true".equals(properties.getProperty(CharSet.getKey(unicodeBlock)))) continue;
            this.setBlock(unicodeBlock, true);
        }
        this.setManualCharacters(properties.getProperty(KEY_MANUAL, ""));
    }

    private static String getKey(Character.UnicodeBlock unicodeBlock) {
        return "CharSet.".concat(unicodeBlock.toString());
    }

    public static Character.UnicodeBlock[] getSupportedBlocks() {
        ArrayList<Character.UnicodeBlock> arrayList = new ArrayList<Character.UnicodeBlock>();
        for (Field field : Character.UnicodeBlock.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Character.UnicodeBlock.class) continue;
            try {
                Character.UnicodeBlock unicodeBlock = (Character.UnicodeBlock)field.get(null);
                if (unicodeBlock == Character.UnicodeBlock.LOW_SURROGATES || unicodeBlock == Character.UnicodeBlock.HIGH_SURROGATES || unicodeBlock == Character.UnicodeBlock.SURROGATES_AREA || unicodeBlock == Character.UnicodeBlock.HIGH_PRIVATE_USE_SURROGATES) continue;
                arrayList.add(unicodeBlock);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arrayList.toArray(new Character.UnicodeBlock[arrayList.size()]);
    }
}

