/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen;

import de.matthiasmann.twlthemeeditor.fontgen.CharSet;
import de.matthiasmann.twlthemeeditor.fontgen.IntMap;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontData {
    private final File fontFile;
    private final Font javaFont;
    private final float size;
    private final int upem;
    private final IntMap<IntMap<Integer>> kerning;
    private final IntMap<int[]> glyphToUnicode;
    private final BitSet defined;
    private final String postScriptName;

    public String getName() {
        return this.postScriptName;
    }

    public String getFamilyName() {
        return this.javaFont.getFamily();
    }

    public float getSize() {
        return this.size;
    }

    public Font getJavaFont() {
        return this.javaFont;
    }

    public File getFontFile() {
        return this.fontFile;
    }

    public IntMap<IntMap<Integer>> getRawKerning() {
        return this.kerning;
    }

    public int[][] getKernings(CharSet charSet) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (IntMap.Entry<IntMap<Integer>> entry : this.kerning) {
            int[] nArray = this.glyphToUnicode.get(entry.key);
            if (nArray == null || !charSet.isIncluded(nArray)) continue;
            for (IntMap.Entry entry2 : (IntMap)entry.value) {
                int n;
                int[] nArray2 = this.glyphToUnicode.get(entry2.key);
                if (nArray2 == null || !charSet.isIncluded(nArray2) || (n = this.convertUnitToEm((Integer)entry2.value)) == 0) continue;
                this.expandKerning(arrayList, nArray, nArray2, n, charSet);
            }
        }
        return (int[][])arrayList.toArray((T[])new int[arrayList.size()][]);
    }

    public void expandKerning(ArrayList<int[]> arrayList, int n, int n2, int n3, CharSet charSet) {
        int[] nArray = this.glyphToUnicode.get(n);
        int[] nArray2 = this.glyphToUnicode.get(n2);
        if (nArray != null && nArray2 != null) {
            this.expandKerning(arrayList, nArray, nArray2, n3, charSet);
        }
    }

    public void expandKerning(ArrayList<int[]> arrayList, int[] nArray, int[] nArray2, int n, CharSet charSet) {
        for (int n2 : nArray) {
            if (!charSet.isIncluded(n2)) continue;
            for (int n3 : nArray2) {
                if (!charSet.isIncluded(n3)) continue;
                arrayList.add(new int[]{n2, n3, n});
            }
        }
    }

    public int getNextCodepoint(int n) {
        return this.defined.nextSetBit(n + 1);
    }

    public HashSet<Character.UnicodeBlock> getDefinedBlocks() {
        HashSet<Character.UnicodeBlock> hashSet = new HashSet<Character.UnicodeBlock>();
        int n = -1;
        while ((n = this.getNextCodepoint(n)) >= 0) {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(n);
            if (unicodeBlock == null) continue;
            hashSet.add(unicodeBlock);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontData(File file, float f) throws IOException {
        this.fontFile = file;
        this.size = f;
        this.defined = new BitSet();
        this.kerning = new IntMap();
        this.glyphToUnicode = new IntMap();
        try {
            Object object;
            Object object2;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            try {
                object2 = FontData.readDirTable(randomAccessFile);
                object = FontData.readSection(randomAccessFile, (byte[])object2, "head");
                byte[] byArray = FontData.readSection(randomAccessFile, (byte[])object2, "cmap");
                byte[] byArray2 = FontData.readSection(randomAccessFile, (byte[])object2, "name");
                byte[] byArray3 = FontData.readSectionOptional(randomAccessFile, (byte[])object2, "kern");
                this.upem = FontData.readUPEM((byte[])object);
                this.postScriptName = FontData.readNAME(byArray2);
                this.readCMAP(byArray, this.glyphToUnicode);
                if (byArray3 != null) {
                    this.readKERN(byArray3);
                }
            }
            finally {
                randomAccessFile.close();
            }
            object2 = Font.createFont(0, file);
            object = this.getName();
            System.err.println("Loaded: " + (String)object);
            int n = 0;
            int n2 = ((String)object).indexOf(44);
            if (n2 >= 0) {
                if (((String)(object = ((String)object).substring(n2 + 1))).indexOf("Bold") >= 0) {
                    n |= 1;
                }
                if (((String)object).indexOf("Italic") >= 0) {
                    n |= 2;
                }
            }
            this.javaFont = ((Font)object2).deriveFont(n, f);
        }
        catch (FontFormatException fontFormatException) {
            throw (IOException)new IOException("Failed to read font").initCause(fontFormatException);
        }
    }

    private FontData(FontData fontData, float f, int n) {
        this.fontFile = fontData.fontFile;
        this.size = f;
        this.javaFont = fontData.javaFont.deriveFont(n, f);
        this.upem = fontData.upem;
        this.kerning = fontData.kerning;
        this.defined = fontData.defined;
        this.postScriptName = fontData.postScriptName;
        this.glyphToUnicode = fontData.glyphToUnicode;
    }

    public FontData deriveFont(float f) {
        return this.deriveFont(f, this.javaFont.getStyle());
    }

    public FontData deriveFont(float f, int n) {
        return new FontData(this, f, n);
    }

    private int convertUnitToEm(int n) {
        return Math.round((float)n * this.size / (float)this.upem);
    }

    private void readCMAP(byte[] byArray, IntMap<int[]> intMap) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = FontData.readUShort(byArray, 2);
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = FontData.readUShort(byArray, n3 * 8 + 4);
            n = FontData.readUShort(byArray, n3 * 8 + 6);
            if (n2 != 3 || n != 1) continue;
            n5 = FontData.readInt(byArray, n3 * 8 + 8);
            break;
        }
        if (n5 == 0) {
            throw new IOException("No unicode mapping table found");
        }
        n3 = FontData.readUShort(byArray, n5);
        if (n3 != 4) {
            throw new IOException("Unsupported unicode table format: " + n3);
        }
        n2 = FontData.readUShort(byArray, n5 + 6);
        for (n = 0; n < n2; n += 2) {
            int n6 = FontData.readUShort(byArray, n5 + 14 + n);
            int n7 = FontData.readUShort(byArray, n5 + 16 + n + n2);
            short s = FontData.readShort(byArray, n5 + 16 + n + n2 * 2);
            int n8 = n5 + 16 + n + n2 * 3;
            int n9 = FontData.readUShort(byArray, n8);
            int n10 = n9 + n8;
            if (n6 == 65535) {
                --n6;
            }
            for (int i = n7; i <= n6; ++i) {
                int n11 = i;
                if (n9 != 0) {
                    n11 = FontData.readUShort(byArray, n10);
                    n10 += 2;
                }
                if (n9 == 0 || n11 != 0) {
                    n11 = n11 + s & 0xFFFF;
                }
                if (n11 == 0) continue;
                int[] nArray = intMap.get(n11);
                if (nArray == null) {
                    nArray = new int[]{i};
                } else {
                    int n12 = nArray.length;
                    nArray = Arrays.copyOf(nArray, n12 + 1);
                    nArray[n12] = i;
                }
                intMap.put(n11, nArray);
                this.defined.set(i);
            }
        }
    }

    private void readKERN(byte[] byArray) {
        int n = FontData.readUShort(byArray, 0);
        int n2 = FontData.readUShort(byArray, 2);
        int n3 = 4;
        for (int i = 0; i < n2; ++i) {
            int n4 = FontData.readInt(byArray, n3);
            int n5 = FontData.readUShort(byArray, n3 + 4);
            if ((n5 & 3) == 1) {
                int n6 = n5 >> 8;
                switch (n6) {
                    case 0: {
                        int n7 = FontData.readUShort(byArray, n3 + 6);
                        int n8 = n3 + 14;
                        int n9 = 0;
                        while (n9 < n7) {
                            int n10 = FontData.readUShort(byArray, n8);
                            int n11 = FontData.readUShort(byArray, n8 + 2);
                            short s = FontData.readShort(byArray, n8 + 4);
                            if (s != 0) {
                                this.addKerning(n10, n11, s);
                            }
                            ++n9;
                            n8 += 6;
                        }
                        break;
                    }
                    default: {
                        Logger.getLogger(FontData.class.getName()).log(Level.WARNING, "Unsupported kerning subtable format: {0} (kern table version: {1})", new Object[]{n6, n});
                    }
                }
            }
            n3 += n4;
        }
    }

    private void addKerning(int n, int n2, int n3) {
        IntMap<Integer> intMap = this.kerning.get(n);
        if (intMap == null) {
            intMap = new IntMap();
            this.kerning.put(n, intMap);
        }
        intMap.put(n2, n3);
    }

    private static byte[] readDirTable(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(4L);
        int n = randomAccessFile.readUnsignedShort();
        randomAccessFile.seek(12L);
        byte[] byArray = new byte[n * 16];
        randomAccessFile.readFully(byArray);
        return byArray;
    }

    private static byte[] readSectionOptional(RandomAccessFile randomAccessFile, byte[] byArray, String string) throws IOException {
        assert (string.length() == 4);
        for (int i = 0; i < byArray.length; i += 16) {
            int n;
            boolean bl = true;
            for (n = 0; n < 4; ++n) {
                if (byArray[i + n] == string.charAt(n)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            n = FontData.readInt(byArray, i + 8);
            int n2 = FontData.readInt(byArray, i + 12);
            byte[] byArray2 = new byte[n2];
            randomAccessFile.seek(n);
            randomAccessFile.readFully(byArray2);
            return byArray2;
        }
        return null;
    }

    private static byte[] readSection(RandomAccessFile randomAccessFile, byte[] byArray, String string) throws IOException {
        byte[] byArray2 = FontData.readSectionOptional(randomAccessFile, byArray, string);
        if (byArray2 == null) {
            throw new IOException("Missing '" + string + "' section");
        }
        return byArray2;
    }

    private static int readUPEM(byte[] byArray) {
        return FontData.readUShort(byArray, 18);
    }

    private static String readNAME(byte[] byArray) {
        int n = FontData.readUShort(byArray, 2);
        int n2 = FontData.readUShort(byArray, 4);
        String string = "";
        String string2 = "";
        block4: for (int i = 0; i < n; ++i) {
            int n3 = FontData.readUShort(byArray, i * 12 + 6);
            int n4 = FontData.readUShort(byArray, i * 12 + 8);
            if (n3 != 1 && n3 != 3 || n4 != 0 && n4 != 1) continue;
            int n5 = FontData.readUShort(byArray, i * 12 + 12);
            int n6 = FontData.readUShort(byArray, i * 12 + 14);
            int n7 = FontData.readUShort(byArray, i * 12 + 16);
            switch (n5) {
                case 1: {
                    string = FontData.readString(byArray, n2 + n7, n6);
                    continue block4;
                }
                case 2: {
                    string2 = FontData.readString(byArray, n2 + n7, n6);
                }
            }
        }
        if (string2.length() == 0 || "Regular".equals(string2) || "Roman".equals(string2)) {
            return string;
        }
        return string + "," + string2;
    }

    private static int readUShort(byte[] byArray, int n) {
        return (byArray[n + 0] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static short readShort(byte[] byArray, int n) {
        return (short)FontData.readUShort(byArray, n);
    }

    private static int readInt(byte[] byArray, int n) {
        return (byArray[n + 0] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static String readString(byte[] byArray, int n, int n2) {
        try {
            if (n2 > 0) {
                String string = byArray[n] == 0 ? "UTF-16BE" : "ISO-8859-1";
                return new String(byArray, n, n2, string);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(FontData.class.getName()).log(Level.SEVERE, "Can't decode string", unsupportedEncodingException);
        }
        return "";
    }
}

