/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen;

import com.sun.jna.Platform;
import de.matthiasmann.javafreetype.FreeTypeCodePointIterator;
import de.matthiasmann.javafreetype.FreeTypeFont;
import de.matthiasmann.javafreetype.FreeTypeGlyphInfo;
import de.matthiasmann.twlthemeeditor.fontgen.CharSet;
import de.matthiasmann.twlthemeeditor.fontgen.Effect;
import de.matthiasmann.twlthemeeditor.fontgen.FontData;
import de.matthiasmann.twlthemeeditor.fontgen.FontInfo;
import de.matthiasmann.twlthemeeditor.fontgen.GlyphRect;
import de.matthiasmann.twlthemeeditor.fontgen.IntMap;
import de.matthiasmann.twlthemeeditor.fontgen.PNGWriter;
import de.matthiasmann.twlthemeeditor.fontgen.Padding;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class FontGenerator {
    private final FontData fontData;
    private final GeneratorMethod generatorMethod;
    private Padding padding;
    private BufferedImage image;
    private GlyphRect[] rects;
    private int[][] kernings;
    private int ascent;
    private int descent;
    private int lineHeight;
    private int usedTextureHeight;

    public FontGenerator(FontData fontData, GeneratorMethod generatorMethod) {
        this.fontData = fontData;
        this.generatorMethod = generatorMethod;
    }

    public void generate(int n, int n2, CharSet charSet, Padding padding, Effect.Renderer[] rendererArray, boolean bl) throws IOException {
        if (this.generatorMethod == GeneratorMethod.FREETYPE2) {
            this.generateFT2(n, n2, charSet, padding);
        } else {
            this.generateAWT(n, n2, charSet, padding, rendererArray, bl, this.generatorMethod == GeneratorMethod.AWT_DRAWSTRING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFT2(int n, int n2, CharSet charSet, Padding padding) throws IOException {
        this.padding = new Padding(0, 0, 0, 0, padding.advance);
        this.image = new BufferedImage(n, n2, 2);
        FreeTypeFont freeTypeFont = FreeTypeFont.create((File)this.fontData.getFontFile());
        try {
            int n4;
            freeTypeFont.setCharSize(0.0f, this.fontData.getSize(), 72, 72);
            this.ascent = freeTypeFont.getAscent();
            this.descent = freeTypeFont.getDescent();
            this.lineHeight = freeTypeFont.getLineHeight();
            int n5 = this.ascent;
            IntMap<FT2Glyph> intMap = new IntMap<FT2Glyph>();
            BitSet bitSet = new BitSet();
            int n6 = 0;
            int n7 = 0;
            FreeTypeCodePointIterator freeTypeCodePointIterator = freeTypeFont.iterateCodePoints();
            while (freeTypeCodePointIterator.nextCodePoint()) {
                int n8 = freeTypeCodePointIterator.getCodePoint();
                int n9 = freeTypeCodePointIterator.getGlyphIndex();
                if (!charSet.isIncluded(n8)) continue;
                FT2Glyph fT2Glyph = (FT2Glyph)intMap.get(n9);
                if (fT2Glyph == null) {
                    try {
                        fT2Glyph = new FT2Glyph(freeTypeFont.loadGlyph(n9), n9);
                        intMap.put(n9, fT2Glyph);
                        bitSet.set(n9);
                        ++n7;
                        n5 = Math.max(fT2Glyph.info.getHeight(), n5);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (fT2Glyph == null) continue;
                ++n6;
            }
            Object[] objectArray = new FT2Glyph[n7];
            Iterator iterator = intMap.iterator();
            int n10 = 0;
            while (iterator.hasNext()) {
                objectArray[n10] = (FT2Glyph)iterator.next().value;
                ++n10;
            }
            Arrays.sort(objectArray);
            n10 = 0;
            int n11 = 1;
            int[] nArray = new int[n];
            this.usedTextureHeight = 0;
            for (n4 = 0; n4 < n7; ++n4) {
                int n3;
                Object object = objectArray[n4];
                int n32 = ((FT2Glyph)object).info.getWidth();
                if (n11 > 0) {
                    if (n10 + n32 > n) {
                        n10 = n - n32;
                        n11 = -1;
                    }
                } else if ((n10 -= n32) < 0) {
                    n10 = 0;
                    n11 = 1;
                }
                int n8 = 0;
                for (n3 = 0; n3 < n32; ++n3) {
                    n8 = Math.max(n8, nArray[n10 + n3]);
                }
                ((FT2Glyph)object).x = n10;
                ((FT2Glyph)object).y = n8;
                freeTypeFont.loadGlyph(((FT2Glyph)object).glyphIndex);
                freeTypeFont.copyGlpyhToBufferedImage(this.image, n10, n8, Color.WHITE);
                n8 += ((FT2Glyph)object).info.getHeight() + 1;
                for (n3 = 0; n3 < n32; ++n3) {
                    nArray[n10 + n3] = n8;
                }
                if (n8 > this.usedTextureHeight) {
                    this.usedTextureHeight = n8;
                }
                if (n11 > 0) {
                    n10 += n32 + 1;
                    continue;
                }
                --n10;
            }
            this.rects = new GlyphRect[n6];
            freeTypeCodePointIterator = freeTypeFont.iterateCodePoints();
            n4 = 0;
            while (freeTypeCodePointIterator.nextCodePoint()) {
                FT2Glyph fT2Glyph;
                int n14 = freeTypeCodePointIterator.getCodePoint();
                int entry = freeTypeCodePointIterator.getGlyphIndex();
                if (!charSet.isIncluded(n14) || (fT2Glyph = (FT2Glyph)intMap.get(entry)) == null) continue;
                GlyphRect entry2 = new GlyphRect((char)n14, fT2Glyph.info.getWidth(), fT2Glyph.info.getHeight(), fT2Glyph.info.getAdvanceX(), -fT2Glyph.info.getOffsetY(), -fT2Glyph.info.getOffsetX(), 0, null);
                entry2.x = fT2Glyph.x;
                entry2.y = fT2Glyph.y;
                this.rects[n4++] = entry2;
            }
            if (freeTypeFont.hasKerning()) {
                ArrayList<int[]> arrayList = new ArrayList<int[]>();
                for (IntMap.Entry<IntMap<Integer>> entry : this.fontData.getRawKerning()) {
                    if (!bitSet.get(entry.key)) continue;
                    for (IntMap.Entry entry2 : (IntMap)entry.value) {
                        int n9;
                        if (!bitSet.get(entry2.key) || (n9 = freeTypeFont.getKerning((int)entry.key, (int)entry2.key).x) == 0) continue;
                        this.fontData.expandKerning(arrayList, entry.key, entry2.key, n9, charSet);
                    }
                }
                this.kernings = (int[][])arrayList.toArray((T[])new int[arrayList.size()][]);
            } else {
                this.kernings = new int[0][];
            }
        }
        finally {
            freeTypeFont.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void generateAWT(int n, int n2, CharSet charSet, Padding padding, Effect.Renderer[] rendererArray, boolean bl, boolean bl2) {
        int n3;
        int n4;
        Object object2;
        this.padding = padding;
        this.image = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = this.image.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Font font = this.fontData.getJavaFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        this.kernings = this.fontData.getKernings(charSet);
        this.ascent = graphics2D.getFontMetrics().getMaxAscent();
        this.descent = graphics2D.getFontMetrics().getMaxDescent();
        this.lineHeight = graphics2D.getFontMetrics().getLeading() + this.ascent + this.descent;
        int n5 = this.ascent;
        ArrayList<GlyphRect> arrayList = new ArrayList<GlyphRect>();
        char[] cArray = new char[1];
        int n6 = -1;
        while ((n6 = this.fontData.getNextCodepoint(n6)) >= 0) {
            if (!charSet.isIncluded(n6)) continue;
            cArray[0] = (char)n6;
            object2 = font.layoutGlyphVector(fontRenderContext, cArray, 0, 1, 0);
            GlyphMetrics glyphMetrics = ((GlyphVector)object2).getGlyphMetrics(0);
            Effect.Renderer[] rendererArray2 = glyphMetrics.getBounds2D().getBounds();
            n4 = Math.round(glyphMetrics.getAdvanceX());
            int n7 = rendererArray2.width + 1 + padding.left + padding.right;
            int n8 = rendererArray2.height + 1 + padding.top + padding.bottom;
            int n9 = 1 - rendererArray2.x;
            n3 = rendererArray2.y - 1;
            GlyphRect object3 = new GlyphRect(cArray[0], Math.min(n7, n), n8, n4 + padding.advance, n3, n9 + padding.left, padding.top, ((GlyphVector)object2).getGlyphOutline(0));
            n5 = Math.max(n8, n5);
            arrayList.add(object3);
        }
        object2 = new FontInfo(n5, this.descent);
        int n10 = arrayList.size();
        this.rects = arrayList.toArray(new GlyphRect[n10]);
        Arrays.sort(this.rects, new Comparator<GlyphRect>(){

            @Override
            public int compare(GlyphRect glyphRect, GlyphRect glyphRect2) {
                int n = glyphRect2.height - glyphRect.height;
                if (n == 0) {
                    n = glyphRect2.width - glyphRect.width;
                }
                return n;
            }
        });
        for (Effect.Renderer renderer : rendererArray) {
            renderer.prePageRender(graphics2D, (FontInfo)object2);
        }
        graphics2D.setColor(Color.white);
        int n11 = 0;
        n4 = 1;
        int[] nArray = new int[n];
        this.usedTextureHeight = 0;
        for (int i = 0; i < n10; ++i) {
            void var23_34;
            GlyphRect glyphRect = this.rects[i];
            if (n4 > 0) {
                if (n11 + glyphRect.width > n) {
                    n11 = n - glyphRect.width;
                    n4 = -1;
                }
            } else if ((n11 -= glyphRect.width) < 0) {
                n11 = 0;
                n4 = 1;
            }
            n3 = 0;
            boolean bl3 = false;
            while (var23_34 < glyphRect.width) {
                n3 = Math.max(n3, nArray[n11 + var23_34]);
                ++var23_34;
            }
            glyphRect.x = n11;
            glyphRect.y = n3;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(n11, n3, glyphRect.width, glyphRect.height);
            try {
                for (Effect.Renderer renderer : rendererArray) {
                    renderer.preGlyphRender(graphics2D2, (FontInfo)object2, glyphRect);
                }
                glyphRect.drawGlyph(graphics2D2, bl2);
                for (Effect.Renderer renderer : rendererArray) {
                    renderer.postGlyphRender(graphics2D2, (FontInfo)object2, glyphRect);
                }
            }
            finally {
                graphics2D2.dispose();
            }
            n3 += glyphRect.height + 1;
            for (int j = 0; j < glyphRect.width; ++j) {
                nArray[n11 + j] = n3;
            }
            if (n3 > this.usedTextureHeight) {
                this.usedTextureHeight = n3;
            }
            if (n4 > 0) {
                n11 += glyphRect.width + 1;
                continue;
            }
            --n11;
        }
        for (Effect.Renderer renderer : rendererArray) {
            renderer.postPageRender(graphics2D, (FontInfo)object2);
        }
        Arrays.sort(this.rects, new Comparator<GlyphRect>(){

            @Override
            public int compare(GlyphRect glyphRect, GlyphRect glyphRect2) {
                return glyphRect.ch - glyphRect2.ch;
            }
        });
    }

    public int getImageWidth() {
        return this.image.getWidth();
    }

    public int getUsedTextureHeight() {
        return this.usedTextureHeight;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public int getImageType() {
        if (this.image != null) {
            return this.image.getType();
        }
        return -1;
    }

    public boolean getTextureData(IntBuffer intBuffer) {
        if (this.image != null) {
            intBuffer.put(((DataBufferInt)this.image.getRaster().getDataBuffer()).getData());
            return true;
        }
        return false;
    }

    public boolean getTextureData(ByteBuffer byteBuffer) {
        if (this.image != null) {
            byteBuffer.put(((DataBufferByte)this.image.getRaster().getDataBuffer()).getData());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(File file, ExportFormat exportFormat) throws IOException {
        File file2 = file.getParentFile();
        String string = this.getBaseName(file);
        PNGWriter.write(new File(file2, string.concat("_00.png")), this.image, Math.min(this.usedTextureHeight, this.image.getHeight()));
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            switch (exportFormat) {
                case XML: {
                    this.writeXML(fileOutputStream, string);
                    return;
                }
                case TEXT: {
                    this.writeText(fileOutputStream, string);
                    return;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    public File[] getFilesCreatedForName(File file) {
        File file2 = file.getParentFile();
        String string = this.getBaseName(file);
        return new File[]{file, new File(file2, string.concat("_00.png"))};
    }

    private void writeXML(OutputStream outputStream, String string) throws IOException {
        try {
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(false);
            XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
            xmlSerializer.setOutput(outputStream, "UTF8");
            xmlSerializer.startDocument("UTF8", Boolean.valueOf(true));
            xmlSerializer.text("\n");
            xmlSerializer.comment("Created by TWL Theme Editor");
            xmlSerializer.text("\n");
            xmlSerializer.startTag(null, "font");
            xmlSerializer.text("\n  ");
            xmlSerializer.startTag(null, "info");
            xmlSerializer.attribute(null, "face", this.fontData.getName());
            xmlSerializer.attribute(null, "size", Integer.toString((int)this.fontData.getSize()));
            xmlSerializer.attribute(null, "bold", this.fontData.getJavaFont().isBold() ? "1" : "0");
            xmlSerializer.attribute(null, "italic", this.fontData.getJavaFont().isItalic() ? "1" : "0");
            xmlSerializer.attribute(null, "charset", "");
            xmlSerializer.attribute(null, "unicode", "1");
            xmlSerializer.attribute(null, "stretchH", "100");
            xmlSerializer.attribute(null, "smooth", "0");
            xmlSerializer.attribute(null, "aa", "1");
            xmlSerializer.attribute(null, "padding", this.padding.top + "," + this.padding.left + "," + this.padding.bottom + "," + this.padding.right);
            xmlSerializer.attribute(null, "spacing", "1,1");
            xmlSerializer.endTag(null, "info");
            xmlSerializer.text("\n  ");
            xmlSerializer.startTag(null, "common");
            xmlSerializer.attribute(null, "lineHeight", Integer.toString(this.lineHeight + this.padding.top + this.padding.bottom));
            xmlSerializer.attribute(null, "base", Integer.toString(this.ascent));
            xmlSerializer.attribute(null, "scaleW", Integer.toString(this.image.getWidth()));
            xmlSerializer.attribute(null, "scaleH", Integer.toString(this.image.getHeight()));
            xmlSerializer.attribute(null, "pages", "1");
            xmlSerializer.attribute(null, "packed", "0");
            xmlSerializer.endTag(null, "common");
            xmlSerializer.text("\n  ");
            xmlSerializer.startTag(null, "pages");
            xmlSerializer.text("\n    ");
            xmlSerializer.startTag(null, "page");
            xmlSerializer.attribute(null, "id", "0");
            xmlSerializer.attribute(null, "file", string.concat("_00.png"));
            xmlSerializer.endTag(null, "page");
            xmlSerializer.text("\n  ");
            xmlSerializer.endTag(null, "pages");
            xmlSerializer.text("\n  ");
            xmlSerializer.startTag(null, "chars");
            xmlSerializer.attribute(null, "count", Integer.toString(this.rects.length));
            for (Object object : this.rects) {
                xmlSerializer.text("\n    ");
                xmlSerializer.startTag(null, "char");
                xmlSerializer.attribute(null, "id", Integer.toString(((GlyphRect)object).ch));
                xmlSerializer.attribute(null, "x", Integer.toString(((GlyphRect)object).x));
                xmlSerializer.attribute(null, "y", Integer.toString(((GlyphRect)object).y));
                xmlSerializer.attribute(null, "width", Integer.toString(((GlyphRect)object).width));
                xmlSerializer.attribute(null, "height", Integer.toString(((GlyphRect)object).height));
                xmlSerializer.attribute(null, "xoffset", Integer.toString(-((GlyphRect)object).xDrawOffset));
                xmlSerializer.attribute(null, "yoffset", Integer.toString(this.ascent + ((GlyphRect)object).yoffset));
                xmlSerializer.attribute(null, "xadvance", Integer.toString(((GlyphRect)object).advance));
                xmlSerializer.attribute(null, "page", "0");
                xmlSerializer.attribute(null, "chnl", "0");
                xmlSerializer.endTag(null, "char");
            }
            xmlSerializer.text("\n  ");
            xmlSerializer.endTag(null, "chars");
            xmlSerializer.text("\n  ");
            xmlSerializer.startTag(null, "kernings");
            xmlSerializer.attribute(null, "count", Integer.toString(this.kernings.length));
            int[][] nArray = this.kernings;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                object = nArray[i];
                xmlSerializer.text("\n    ");
                xmlSerializer.startTag(null, "kerning");
                xmlSerializer.attribute(null, "first", Integer.toString((int)object[0]));
                xmlSerializer.attribute(null, "second", Integer.toString((int)object[1]));
                xmlSerializer.attribute(null, "amount", Integer.toString((int)object[2]));
                xmlSerializer.endTag(null, "kerning");
                xmlSerializer.comment(" '" + this.ch2str((int)object[0]) + "' to '" + this.ch2str((int)object[1]) + "' ");
            }
            xmlSerializer.text("\n  ");
            xmlSerializer.endTag(null, "kernings");
            xmlSerializer.text("\n");
            xmlSerializer.endTag(null, "font");
            xmlSerializer.endDocument();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw (IOException)new IOException().initCause(xmlPullParserException);
        }
    }

    public void writeText(OutputStream outputStream, String string) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.printf("info face=%s size=%d bold=%d italic=%d charset=\"\" unicode=1 stretchH=100 smooth=0 aa=1 padding=%d,%d,%d,%d spacing=1,1\n", this.fontData.getName(), (int)this.fontData.getSize(), this.fontData.getJavaFont().isBold() ? 1 : 0, this.fontData.getJavaFont().isItalic() ? 1 : 0, this.padding.top, this.padding.left, this.padding.bottom, this.padding.right);
        printWriter.printf("common lineHeight=%d base=%s scaleW=%s scaleH=%d pages=1 packed=0\n", this.lineHeight + this.padding.bottom + this.padding.top, this.ascent, this.image.getWidth(), this.image.getHeight());
        printWriter.printf("page id=0 file=%s_00.png\n", string);
        printWriter.printf("chars count=%d\n", this.rects.length);
        for (Object object : this.rects) {
            printWriter.printf("char id=%d x=%d y=%d width=%d height=%d xoffset=%d yoffset=%d xadvance=%d page=0 chnl=0\n", ((GlyphRect)object).ch, ((GlyphRect)object).x, ((GlyphRect)object).y, ((GlyphRect)object).width, ((GlyphRect)object).height, -((GlyphRect)object).xDrawOffset, this.ascent + ((GlyphRect)object).yoffset, ((GlyphRect)object).advance);
        }
        printWriter.printf("kernings count=%d\n", this.kernings.length);
        int[][] nArray = this.kernings;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            object = nArray[i];
            printWriter.printf("kerning first=%d second=%d amount=%d\n", (int)object[0], (int)object[1], (int)object[2]);
        }
        printWriter.close();
    }

    private String ch2str(int n) {
        if (Character.isISOControl(n)) {
            return String.format("\\u%04X", n);
        }
        return Character.toString((char)n);
    }

    private String getBaseName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    static boolean isFreeTypeAvailable() {
        if (Platform.isWindows()) {
            FreeTypeFont.setNativeLibraryName((String)(Platform.is64Bit() ? "freetype6_amd64" : "freetype6_x86"));
        }
        return FreeTypeFont.isAvailable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExportFormat {
        XML,
        TEXT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FT2Glyph
    implements Comparable<FT2Glyph> {
        final FreeTypeGlyphInfo info;
        final int glyphIndex;
        int x;
        int y;

        public FT2Glyph(FreeTypeGlyphInfo freeTypeGlyphInfo, int n) {
            this.info = freeTypeGlyphInfo;
            this.glyphIndex = n;
        }

        @Override
        public int compareTo(FT2Glyph fT2Glyph) {
            int n = fT2Glyph.info.getHeight() - this.info.getHeight();
            if (n == 0) {
                n = fT2Glyph.info.getWidth() - this.info.getWidth();
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GeneratorMethod {
        AWT_VECTOR(true, true, true),
        AWT_DRAWSTRING(true, true, false),
        FREETYPE2(FontGenerator.isFreeTypeAvailable(), false, false);

        public final boolean isAvailable;
        public final boolean supportsAAflag;
        public final boolean supportsEffects;

        private GeneratorMethod(boolean bl, boolean bl2, boolean bl3) {
            this.isAvailable = bl;
            this.supportsAAflag = bl2;
            this.supportsEffects = bl3;
        }
    }
}

