/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PNGWriter {
    private static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int IHDR = 1229472850;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    private static final byte COLOR_TRUEALPHA = 6;
    private static final byte COMPRESSION_DEFLATE = 0;
    private static final byte FILTER_NONE = 0;
    private static final byte INTERLACE_NONE = 0;
    private static final byte PAETH = 4;

    public static void write(OutputStream outputStream, BufferedImage bufferedImage, int n) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.write(SIGNATURE);
        Chunk chunk = new Chunk(1229472850);
        chunk.writeInt(bufferedImage.getWidth());
        chunk.writeInt(n);
        chunk.writeByte(8);
        chunk.writeByte(6);
        chunk.writeByte(0);
        chunk.writeByte(0);
        chunk.writeByte(0);
        chunk.writeTo(dataOutputStream);
        Chunk chunk2 = new Chunk(1229209940);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)chunk2, new Deflater(9));
        int n2 = bufferedImage.getWidth() * 4;
        byte[] byArray = new byte[n2 + 1];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5 = bufferedImage.getWidth();
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = bufferedImage.getRGB(n4, i);
                byArray2[n4 * 4 + 0] = (byte)(n3 >>> 16);
                byArray2[n4 * 4 + 1] = (byte)(n3 >>> 8);
                byArray2[n4 * 4 + 2] = (byte)n3;
                byArray2[n4 * 4 + 3] = (byte)(n3 >>> 24);
            }
            byArray[0] = 4;
            byArray[1] = (byte)(byArray2[0] - byArray3[0]);
            byArray[2] = (byte)(byArray2[1] - byArray3[1]);
            byArray[3] = (byte)(byArray2[2] - byArray3[2]);
            byArray[4] = (byte)(byArray2[3] - byArray3[3]);
            for (n4 = 4; n4 < n2; ++n4) {
                int n6;
                int n7;
                n5 = byArray2[n4 - 4] & 0xFF;
                n3 = byArray3[n4] & 0xFF;
                int n8 = byArray3[n4 - 4] & 0xFF;
                int n9 = n5 + n3 - n8;
                int n10 = n9 - n5;
                if (n10 < 0) {
                    n10 = -n10;
                }
                if ((n7 = n9 - n3) < 0) {
                    n7 = -n7;
                }
                if ((n6 = n9 - n8) < 0) {
                    n6 = -n6;
                }
                if (n10 <= n7 && n10 <= n6) {
                    n8 = n5;
                } else if (n7 <= n6) {
                    n8 = n3;
                }
                byArray[n4 + 1] = (byte)(byArray2[n4] - n8);
            }
            deflaterOutputStream.write(byArray);
            byte[] byArray4 = byArray2;
            byArray2 = byArray3;
            byArray3 = byArray4;
        }
        deflaterOutputStream.finish();
        chunk2.writeTo(dataOutputStream);
        Chunk chunk3 = new Chunk(1229278788);
        chunk3.writeTo(dataOutputStream);
        dataOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, BufferedImage bufferedImage, int n) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            PNGWriter.write(fileOutputStream, bufferedImage, n);
        }
        finally {
            fileOutputStream.close();
        }
    }

    static class Chunk
    extends DataOutputStream {
        final CRC32 crc;
        final ByteArrayOutputStream baos;

        Chunk(int n) throws IOException {
            this(n, new ByteArrayOutputStream(), new CRC32());
        }

        private Chunk(int n, ByteArrayOutputStream byteArrayOutputStream, CRC32 cRC32) throws IOException {
            super(new CheckedOutputStream(byteArrayOutputStream, cRC32));
            this.crc = cRC32;
            this.baos = byteArrayOutputStream;
            this.writeInt(n);
        }

        public void writeTo(DataOutputStream dataOutputStream) throws IOException {
            this.flush();
            dataOutputStream.writeInt(this.baos.size() - 4);
            this.baos.writeTo(dataOutputStream);
            dataOutputStream.writeInt((int)this.crc.getValue());
        }
    }
}

