/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen.gui;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.SimpleBooleanModel;
import de.matthiasmann.twlthemeeditor.fontgen.Effect;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.PropertyFactories;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EffectPropertyPanel
extends DialogLayout {
    private final SimpleBooleanModel effectActive = new SimpleBooleanModel();
    private final String effectName;
    private final Effect effect;
    private final Property<?>[] properties;

    public EffectPropertyPanel(PropertyFactories propertyFactories, String string, Effect effect) {
        this.effectName = string;
        this.effect = effect;
        this.properties = effect.getProperties();
        DialogLayout.Group group = this.createParallelGroup();
        DialogLayout.Group group2 = this.createParallelGroup();
        DialogLayout.Group group3 = this.createSequentialGroup();
        for (Property<?> property : this.properties) {
            PropertyEditorFactory<?, ?> propertyEditorFactory = propertyFactories.getFactory(property);
            if (propertyEditorFactory != null) {
                Widget widget = propertyEditorFactory.create(new PropertyAccessor(property, null));
                Label label = new Label(property.getName());
                label.setLabelFor(widget);
                group.addWidget((Widget)label);
                group2.addWidget(widget);
                group3.addGroup(this.createParallelGroup().addWidget((Widget)label).addWidget(widget));
                continue;
            }
            System.out.println("No factory for property " + property.getName() + " type " + property.getClass() + "<" + property.getType() + ">");
        }
        this.setHorizontalGroup(this.createSequentialGroup().addGroup(group).addGroup(group2));
        this.setVerticalGroup(group3);
    }

    public void addCallback(Runnable runnable) {
        this.effectActive.addCallback(runnable);
        for (Property<?> property : this.properties) {
            property.addValueChangedCallback(runnable);
        }
    }

    public void removeCallback(Runnable runnable) {
        this.effectActive.removeCallback(runnable);
        for (Property<?> property : this.properties) {
            property.removeValueChangedCallback(runnable);
        }
    }

    public Effect getEffect() {
        return this.effect;
    }

    public SimpleBooleanModel getEffectActive() {
        return this.effectActive;
    }

    public void save(Properties properties) {
        properties.setProperty(this.getActiveKey(), Boolean.toString(this.effectActive.getValue()));
        for (Property<?> property : this.properties) {
            properties.setProperty(this.getPropertyKey(property), String.valueOf(property.getPropertyValue()));
        }
    }

    public void load(Properties properties) {
        this.effectActive.setValue(Boolean.valueOf(properties.getProperty(this.getActiveKey())).booleanValue());
        for (Property<?> property : this.properties) {
            String string = properties.getProperty(this.getPropertyKey(property));
            if (string == null) continue;
            try {
                Object object;
                Class clazz = property.getType();
                if (Color.class == clazz) {
                    object = Color.parserColor((String)string);
                } else if (Integer.class == clazz) {
                    object = Integer.valueOf(string);
                } else if (Float.class == clazz) {
                    object = Float.valueOf(string);
                } else if (clazz.isEnum()) {
                    object = Enum.valueOf(clazz, string);
                } else {
                    throw new UnsupportedOperationException("Not implemented: " + clazz);
                }
                property.setPropertyValue(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private String getActiveKey() {
        return this.effectName.concat(".active");
    }

    private String getPropertyKey(Property<?> property) {
        return this.effectName + "." + property.getName().replace(' ', '_');
    }
}

