/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen.gui;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.DynamicImage;
import de.matthiasmann.twlthemeeditor.DelayedAction;
import de.matthiasmann.twlthemeeditor.fontgen.CharSet;
import de.matthiasmann.twlthemeeditor.fontgen.Effect;
import de.matthiasmann.twlthemeeditor.fontgen.FontData;
import de.matthiasmann.twlthemeeditor.fontgen.FontGenerator;
import de.matthiasmann.twlthemeeditor.fontgen.Padding;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FontDisplay
extends Widget {
    private final Runnable callback;
    private final GUI.AsyncCompletionListener<FontGenerator> completionHandler;
    private DelayedAction delayedAction;
    private int textureSize;
    private FontData fontData;
    private Padding padding;
    private boolean paddingAutomatic;
    private boolean useAA;
    private CharSet charSet;
    private Effect.Renderer[] effects;
    private FontGenerator.GeneratorMethod generatorMethod;
    private boolean pendingUpdate;
    private boolean updateRunning;
    private ByteBuffer buffer;
    private DynamicImage image;
    private FontGenerator lastFontGen;

    public FontDisplay(Runnable runnable) {
        this.callback = runnable;
        this.completionHandler = new GUI.AsyncCompletionListener<FontGenerator>(){

            public void completed(FontGenerator fontGenerator) {
                FontDisplay.this.updateImage(fontGenerator);
            }

            public void failed(Exception exception) {
                Logger.getLogger(FontDisplay.class.getName()).log(Level.SEVERE, "Can't generate font", exception);
                FontDisplay.this.updateDone();
            }
        };
    }

    public void setTextureSize(int n) {
        this.textureSize = n;
        this.update();
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
        this.update();
    }

    public void setPaddingManual(Padding padding) {
        this.padding = padding;
        this.paddingAutomatic = false;
        this.update();
    }

    public void setPaddingAutomatic() {
        this.padding = null;
        this.paddingAutomatic = true;
        this.update();
    }

    public void setUseAA(boolean bl) {
        this.useAA = bl;
        this.update();
    }

    public void setGeneratorMethod(FontGenerator.GeneratorMethod generatorMethod) {
        this.generatorMethod = generatorMethod;
        this.update();
    }

    public void setCharSet(CharSet charSet) {
        this.charSet = new CharSet(charSet);
        this.update();
    }

    public void setEffects(Effect[] effectArray) {
        Effect.Renderer[] rendererArray = new Effect.Renderer[effectArray.length];
        for (int i = 0; i < effectArray.length; ++i) {
            rendererArray[i] = effectArray[i].createRenderer();
        }
        this.effects = rendererArray;
        this.update();
    }

    public FontGenerator getLastFontGen() {
        return this.lastFontGen;
    }

    void update() {
        if (this.delayedAction != null) {
            this.delayedAction.run();
        }
    }

    void doUpdate() {
        GUI gUI = this.getGUI();
        if (gUI != null && this.textureSize > 0 && this.fontData != null && (this.paddingAutomatic || this.padding != null) && this.charSet != null && this.effects != null && this.generatorMethod != null) {
            if (this.updateRunning) {
                this.pendingUpdate = true;
            } else {
                gUI.invokeAsync((Callable)new GenFont(this.textureSize, this.fontData, this.computePadding(), this.charSet, this.effects, this.useAA, this.generatorMethod), this.completionHandler);
                this.updateRunning = true;
            }
        }
    }

    private Padding computePadding() {
        if (this.paddingAutomatic) {
            Padding padding = Padding.ZERO;
            for (Effect.Renderer renderer : this.effects) {
                Padding padding2 = renderer.getPadding();
                if (padding2 == null) continue;
                padding = padding.max(padding2);
            }
            return padding;
        }
        assert (this.padding != null) : "padding is null";
        return this.padding;
    }

    protected void afterAddToGUI(GUI gUI) {
        super.afterAddToGUI(gUI);
        this.delayedAction = new DelayedAction(gUI, new Runnable(){

            public void run() {
                FontDisplay.this.doUpdate();
            }
        });
    }

    protected void beforeRemoveFromGUI(GUI gUI) {
        this.delayedAction = null;
        super.beforeRemoveFromGUI(gUI);
    }

    public void destroy() {
        super.destroy();
        this.destroyImage();
    }

    public int getPreferredInnerWidth() {
        return this.image != null ? this.image.getWidth() : 0;
    }

    public int getPreferredInnerHeight() {
        return this.image != null ? this.image.getHeight() : 0;
    }

    protected void paintWidget(GUI gUI) {
        if (this.image != null) {
            this.image.draw((AnimationState)this.getAnimationState(), this.getInnerX(), this.getInnerY());
        }
    }

    private void destroyImage() {
        if (this.image != null) {
            this.image.destroy();
            this.image = null;
        }
    }

    private ByteBuffer getBuffer(int n) {
        if (this.buffer == null || this.buffer.capacity() < n) {
            this.buffer = ByteBuffer.allocateDirect(n);
        }
        this.buffer.clear().limit(n);
        return this.buffer;
    }

    void updateImage(FontGenerator fontGenerator) {
        Object object;
        this.lastFontGen = fontGenerator;
        int n = fontGenerator.getImageWidth();
        if (this.image == null || this.image.getWidth() != n) {
            this.destroyImage();
            object = this.getGUI();
            if (object != null) {
                this.image = object.getRenderer().createDynamicImage(n, n);
            }
        }
        if (this.image != null) {
            try {
                object = this.getBuffer(this.textureSize * this.textureSize * 4);
                IntBuffer intBuffer = ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
                fontGenerator.getTextureData(intBuffer);
                this.image.update((ByteBuffer)object, DynamicImage.Format.BGRA);
            }
            catch (Throwable throwable) {
                Logger.getLogger(FontDisplay.class.getName()).log(Level.SEVERE, "Unable to update image", throwable);
            }
            this.invalidateLayout();
        }
        this.updateDone();
    }

    void updateDone() {
        this.updateRunning = false;
        if (this.pendingUpdate) {
            this.pendingUpdate = false;
            this.update();
        }
        this.callback.run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class GenFont
    implements Callable<FontGenerator> {
        private final int textureSize;
        private final FontGenerator fontGen;
        private final Padding padding;
        private final CharSet charSet;
        private final Effect.Renderer[] effects;
        private final boolean useAA;

        public GenFont(int n, FontData fontData, Padding padding, CharSet charSet, Effect.Renderer[] rendererArray, boolean bl, FontGenerator.GeneratorMethod generatorMethod) {
            this.textureSize = n;
            this.fontGen = new FontGenerator(fontData, generatorMethod);
            this.padding = padding;
            this.charSet = charSet;
            this.effects = rendererArray;
            this.useAA = bl;
        }

        @Override
        public FontGenerator call() throws Exception {
            this.fontGen.generate(this.textureSize, this.textureSize, this.charSet, this.padding, this.effects, this.useAA);
            return this.fontGen;
        }
    }
}

