/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen.gui;

import de.matthiasmann.twl.BoxLayout;
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.ComboBox;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.SplitPane;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.ValueAdjuster;
import de.matthiasmann.twl.ValueAdjusterInt;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.EnumListModel;
import de.matthiasmann.twl.model.HasCallback;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.model.SimpleBooleanModel;
import de.matthiasmann.twl.model.SimpleChangableListModel;
import de.matthiasmann.twl.model.SimpleIntegerModel;
import de.matthiasmann.twl.utils.TextUtil;
import de.matthiasmann.twlthemeeditor.fontgen.CharSet;
import de.matthiasmann.twlthemeeditor.fontgen.FontData;
import de.matthiasmann.twlthemeeditor.fontgen.FontGenerator;
import de.matthiasmann.twlthemeeditor.fontgen.Padding;
import de.matthiasmann.twlthemeeditor.fontgen.effects.BlurShadowEffect;
import de.matthiasmann.twlthemeeditor.fontgen.effects.GradientEffect;
import de.matthiasmann.twlthemeeditor.fontgen.effects.OutlineEffect;
import de.matthiasmann.twlthemeeditor.fontgen.gui.EffectsPanel;
import de.matthiasmann.twlthemeeditor.fontgen.gui.FontDisplay;
import de.matthiasmann.twlthemeeditor.fontgen.gui.FontSelectPopup;
import de.matthiasmann.twlthemeeditor.gui.DecoratedTextRenderer;
import de.matthiasmann.twlthemeeditor.gui.LoadFileSelector;
import de.matthiasmann.twlthemeeditor.gui.SaveFileSelector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public final class FontGenDialog {
    public static final String FONTGEN_FILE_SELECTOR_KEY = "fontgen_settings";
    private static final String SETTINGS_EXTENSION = ".twlfontgen";
    private final CharSet charSet = new CharSet();
    private final DialogLayout layout;
    private final PopupWindow popupWindow;
    private final EditField fontPathEF;
    private final Button selectFontBtn;
    private final SimpleChangableListModel<Integer> textureSizesModel;
    private final ComboBox<Integer> textureSizeCB;
    private final ComboBox<FontDisplayBG> fontDisplayBgCB;
    private final SimpleChangableListModel<FontGenerator.GeneratorMethod> generatorModesModel;
    private final ComboBox<FontGenerator.GeneratorMethod> generatorModeCB;
    private final CharSetBlockCB[] unicodeBockCBs;
    private final BoxLayout unicodeBlocksBox;
    private final ScrollPane unicodeBlocksSP;
    private final EditField manualCharactersEditfield;
    private final SimpleIntegerModel fontSizeModel;
    private final ValueAdjusterInt fontSizeAdjuster;
    private final Label fontMetricInfoLabel;
    private final ToggleButton useAACheckbox;
    private final EffectsPanel effectsPanel;
    private final ScrollPane effectsPanelSP;
    private final FontDisplay fontDisplay;
    private final ScrollPane fontDisplaySP;
    private final EnumListModel<FontGenerator.ExportFormat> exportFormatModel;
    private final ComboBox<FontGenerator.ExportFormat> exportFormatCB;
    private final Button loadSettingsButton;
    private final Button saveSettingsButton;
    private final Button saveFontButton;
    private final Button closeButton;
    private final Label statusBar;
    private final SimpleIntegerModel[] paddingModels;
    private final SimpleBooleanModel manualPaddingModel;
    private String fontPath;
    private FontData fontData;
    private static final String KEY_FONTPATH = "fontPath";
    private static final String KEY_TEXTURESIZE = "textureSize";
    private static final String KEY_FONTSIZE = "fontSize";
    private static final String KEY_EXPORTFORMAT = "exportFormat";
    private static final String KEY_PADDING_AUTOMATIC = "padding.automatic";
    private static final String KEY_USEAA = "useAA";
    private static final String KEY_GENERATOR_METHOD = "generatorMethod";
    private static final String[] KEY_PADDING = new String[]{"padding.top", "padding.left", "padding.bottom", "padding.right", "padding.advance"};

    /*
     * WARNING - void declaration
     */
    public FontGenDialog(Widget widget) {
        int n;
        void object;
        this.charSet.setBlock(Character.UnicodeBlock.BASIC_LATIN, true);
        this.charSet.setBlock(Character.UnicodeBlock.LATIN_1_SUPPLEMENT, true);
        this.effectsPanel = new EffectsPanel();
        this.effectsPanelSP = new ScrollPane((Widget)this.effectsPanel);
        this.effectsPanelSP.setTheme("effectsPanel");
        this.effectsPanelSP.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.effectsPanelSP.setExpandContentSize(true);
        this.unicodeBlocksBox = new BoxLayout(BoxLayout.Direction.VERTICAL);
        Runnable runnable = new Runnable(){

            public void run() {
                FontGenDialog.this.updateCharset();
            }
        };
        Character.UnicodeBlock[] unicodeBlockArray = CharSet.getSupportedBlocks();
        this.unicodeBockCBs = new CharSetBlockCB[unicodeBlockArray.length];
        boolean i = false;
        int n2 = unicodeBlockArray.length;
        while (object < n2) {
            CharSetBlockModel stringArray3 = new CharSetBlockModel(this.charSet, unicodeBlockArray[object]);
            stringArray3.addCallback(runnable);
            this.unicodeBockCBs[object] = new CharSetBlockCB(stringArray3);
            this.unicodeBlocksBox.add((Widget)this.unicodeBockCBs[object]);
            ++object;
        }
        this.manualCharactersEditfield = new EditField();
        this.manualCharactersEditfield.setTheme("manualCharacters");
        this.manualCharactersEditfield.addCallback(new EditField.Callback(){

            public void callback(int n) {
                FontGenDialog.this.updateManualCharacters();
            }
        });
        this.fontPathEF = new EditField();
        this.fontPathEF.setReadOnly(true);
        this.selectFontBtn = new Button();
        this.selectFontBtn.setTheme("selectFontBtn");
        this.selectFontBtn.addCallback(new Runnable(){

            public void run() {
                FontGenDialog.this.selectFont();
            }
        });
        this.textureSizesModel = new SimpleChangableListModel((Object[])new Integer[]{64, 128, 256, 512, 1024, 2048, 4096});
        this.textureSizeCB = new ComboBox(this.textureSizesModel);
        this.textureSizeCB.setSelected(2);
        this.textureSizeCB.addCallback(new Runnable(){

            public void run() {
                FontGenDialog.this.updateTextureSize();
            }
        });
        this.generatorModesModel = new SimpleChangableListModel();
        FontGenerator.GeneratorMethod[] generatorMethodArray = FontGenerator.GeneratorMethod.values();
        n2 = generatorMethodArray.length;
        for (n = 0; n < n2; ++n) {
            FontGenerator.GeneratorMethod generatorMethod = generatorMethodArray[n];
            if (!generatorMethod.isAvailable) continue;
            this.generatorModesModel.addElement((Object)generatorMethod);
        }
        this.generatorModeCB = new ComboBox(this.generatorModesModel);
        this.generatorModeCB.setSelected(0);
        this.generatorModeCB.addCallback(new Runnable(){

            public void run() {
                FontGenDialog.this.updateGeneratorMode();
            }
        });
        this.useAACheckbox = new ToggleButton("Use Antialiasing rendering");
        this.useAACheckbox.setTheme("useAACheckbox");
        this.useAACheckbox.setActive(true);
        this.useAACheckbox.addCallback(new Runnable(){

            public void run() {
                FontGenDialog.this.updateAA();
            }
        });
        this.fontDisplayBgCB = new ComboBox((ListModel)new SimpleChangableListModel((Object[])FontDisplayBG.values()));
        this.fontDisplayBgCB.setSelected(0);
        this.fontDisplayBgCB.addCallback(new Runnable(){

            public void run() {
                FontGenDialog.this.setFontDisplayTheme();
            }
        });
        this.unicodeBlocksSP = new ScrollPane((Widget)this.unicodeBlocksBox);
        this.unicodeBlocksSP.setTheme("unicodeBlocks");
        this.unicodeBlocksSP.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.fontSizeModel = new SimpleIntegerModel(8, 128, 14);
        this.fontSizeModel.addCallback(new Runnable(){

            public void run() {
                FontGenDialog.this.updateFont();
            }
        });
        this.fontSizeAdjuster = new ValueAdjusterInt((IntegerModel)this.fontSizeModel);
        this.fontMetricInfoLabel = new Label();
        this.fontMetricInfoLabel.setTheme("fontMetricInfo");
        Runnable runnable2 = new Runnable(){

            public void run() {
                FontGenDialog.this.updatePadding();
            }
        };
        this.manualPaddingModel = new SimpleBooleanModel();
        this.manualPaddingModel.addCallback(runnable2);
        this.paddingModels = new SimpleIntegerModel[5];
        ValueAdjusterInt[] valueAdjusterIntArray = new ValueAdjusterInt[this.paddingModels.length];
        for (n = 0; n < this.paddingModels.length; ++n) {
            this.paddingModels[n] = new SimpleIntegerModel(0, 16, 0);
            this.paddingModels[n].addCallback(runnable2);
            valueAdjusterIntArray[n] = new ValueAdjusterInt((IntegerModel)this.paddingModels[n]);
        }
        String[] stringArray = new String[]{"T: ", "L: ", "B: ", "R: ", "A: "};
        String[] stringArray2 = new String[]{"Top", "Left", "Bottom", "Right", "Advance"};
        for (int j = 0; j < valueAdjusterIntArray.length; ++j) {
            valueAdjusterIntArray[j].setDisplayPrefix(stringArray[j]);
            valueAdjusterIntArray[j].setTooltipContent((Object)stringArray2[j]);
        }
        this.effectsPanel.addControl("TTF font", (Widget)this.fontPathEF, this.selectFontBtn);
        this.effectsPanel.addControl("Texture size", (Widget)this.textureSizeCB);
        this.effectsPanel.addControl("Generator", (Widget)this.generatorModeCB);
        this.effectsPanel.addControl("Font size", (Widget)this.fontSizeAdjuster);
        this.effectsPanel.addControl("Font metric", (Widget)this.fontMetricInfoLabel);
        this.effectsPanel.addControl("Preview BG", (Widget)this.fontDisplayBgCB);
        this.effectsPanel.addControl((Widget)this.useAACheckbox);
        this.effectsPanel.addCollapsible("Unicode blocks", (Widget)this.unicodeBlocksSP, null).setExpanded(true);
        this.effectsPanel.addCollapsible("Manual characters", (Widget)this.manualCharactersEditfield, null);
        this.effectsPanel.addCollapsible("Manual padding", (ValueAdjuster[])valueAdjusterIntArray, (BooleanModel)this.manualPaddingModel);
        this.effectsPanel.addEffect("Shadow", new BlurShadowEffect());
        this.effectsPanel.addEffect("Gradient", new GradientEffect());
        this.effectsPanel.addEffect("Outline", new OutlineEffect());
        this.effectsPanel.addCallback(new Runnable(){

            public void run() {
                FontGenDialog.this.updateEffects();
            }
        });
        this.fontDisplay = new FontDisplay(new Runnable(){

            public void run() {
                FontGenDialog.this.updateStatusBar();
            }
        });
        this.fontDisplaySP = new ScrollPane((Widget)this.fontDisplay);
        this.fontDisplaySP.setTheme("fontDisplay");
        this.exportFormatModel = new EnumListModel<FontGenerator.ExportFormat>(FontGenerator.ExportFormat.class){

            public Object getEntryTooltip(int n) {
                if (this.getEntry(n) == FontGenerator.ExportFormat.XML) {
                    return "TWL's font format";
                }
                return "This format can be exported but can not used by TWL";
            }
        };
        this.exportFormatCB = new ComboBox(this.exportFormatModel);
        this.exportFormatCB.setSelected(this.exportFormatModel.findEntry((Enum)FontGenerator.ExportFormat.XML));
        this.loadSettingsButton = new Button("Load Settings");
        this.loadSettingsButton.addCallback(new Runnable(){

            public void run() {
                FontGenDialog.this.loadSettings();
            }
        });
        this.saveSettingsButton = new Button("Save Settings");
        this.saveSettingsButton.addCallback(new Runnable(){

            public void run() {
                FontGenDialog.this.saveSettings();
            }
        });
        this.saveFontButton = new Button("Save Font");
        this.saveFontButton.addCallback(new Runnable(){

            public void run() {
                FontGenDialog.this.saveFont();
            }
        });
        this.closeButton = new Button("Close");
        this.closeButton.addCallback(new Runnable(){

            public void run() {
                FontGenDialog.this.close();
            }
        });
        this.statusBar = new Label();
        this.statusBar.setTheme("statusBar");
        SplitPane splitPane = new SplitPane();
        splitPane.setDirection(SplitPane.Direction.HORIZONTAL);
        splitPane.setSplitPosition(370);
        splitPane.add((Widget)this.effectsPanelSP);
        splitPane.add((Widget)this.fontDisplaySP);
        this.layout = new DialogLayout();
        this.layout.setTheme("fontgendialog");
        DialogLayout.Group group = this.layout.createSequentialGroup().addWidget((Widget)this.loadSettingsButton).addWidget((Widget)this.saveSettingsButton).addWidget((Widget)this.statusBar).addWidget(this.exportFormatCB).addWidget((Widget)this.saveFontButton).addWidget((Widget)this.closeButton);
        DialogLayout.Group group2 = this.layout.createParallelGroup().addWidget((Widget)this.loadSettingsButton).addWidget((Widget)this.saveSettingsButton).addWidget((Widget)this.statusBar).addWidget(this.exportFormatCB).addWidget((Widget)this.saveFontButton).addWidget((Widget)this.closeButton);
        this.layout.setHorizontalGroup(this.layout.createParallelGroup().addWidget((Widget)splitPane).addGroup(group));
        this.layout.setVerticalGroup(this.layout.createSequentialGroup().addWidget((Widget)splitPane).addGroup(group2));
        this.popupWindow = new PopupWindow(widget);
        this.popupWindow.setTheme("fontGenDialog-popup");
        this.popupWindow.add((Widget)this.layout);
        this.popupWindow.setCloseOnClickedOutside(false);
        this.setFontDisplayTheme();
        this.updateTextureSize();
        this.updateCharset();
        this.updateFont();
        this.updateAA();
        this.updatePadding();
        this.updateEffects();
        this.updateStatusBar();
        this.updateGeneratorMode();
    }

    public void openPopup() {
        if (this.popupWindow.openPopup()) {
            GUI gUI = this.popupWindow.getGUI();
            this.popupWindow.setSize(gUI.getWidth() * 7 / 8, gUI.getHeight() * 7 / 8);
            this.popupWindow.setPosition((gUI.getWidth() - this.popupWindow.getWidth()) / 2, (gUI.getHeight() - this.popupWindow.getHeight()) / 2);
        }
    }

    void loadSettings() {
        LoadFileSelector loadFileSelector = new LoadFileSelector((Widget)this.loadSettingsButton, Preferences.userNodeForPackage(FontGenDialog.class), FONTGEN_FILE_SELECTOR_KEY, "TWL font generator settings", SETTINGS_EXTENSION, new LoadFileSelector.Callback(){

            public void canceled() {
            }

            public void fileSelected(File file) {
                FontGenDialog.this.loadSettings(file);
            }
        });
        loadFileSelector.openPopup();
    }

    void saveSettings() {
        SaveFileSelector saveFileSelector = new SaveFileSelector((Widget)this.saveSettingsButton, Preferences.userNodeForPackage(FontGenDialog.class), FONTGEN_FILE_SELECTOR_KEY, "TWL font generator settings", SETTINGS_EXTENSION, new SaveFileSelector.Callback(){

            public File[] getFilesCreatedForFileName(File file) {
                return new File[]{file};
            }

            public void fileNameSelected(File file) {
                FontGenDialog.this.saveSettings(file);
            }

            public void canceled() {
            }
        });
        saveFileSelector.openPopup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadSettings(File file) {
        Enum enum_;
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF8");
                properties.load(inputStreamReader);
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(FontGenDialog.class.getName()).log(Level.SEVERE, "Can't load settings file", iOException);
            return;
        }
        this.fontPath = properties.getProperty(KEY_FONTPATH);
        this.fontData = null;
        this.fontPathEF.setText(TextUtil.notNull((String)this.fontPath));
        int n = -1;
        try {
            int n2 = Integer.parseInt(properties.getProperty(KEY_TEXTURESIZE, "0"));
            n = this.textureSizesModel.findElement((Object)n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.textureSizeCB.setSelected(n < 0 ? 2 : n);
        n = 14;
        try {
            n = Integer.parseInt(properties.getProperty(KEY_FONTSIZE, "0"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.fontSizeModel.setValue(n <= 0 ? 14 : n);
        try {
            enum_ = FontGenerator.ExportFormat.valueOf(properties.getProperty(KEY_EXPORTFORMAT, FontGenerator.ExportFormat.XML.name()));
            this.exportFormatCB.setSelected(this.exportFormatModel.findEntry(enum_));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.useAACheckbox.setActive(Boolean.parseBoolean(properties.getProperty(KEY_USEAA, "true")));
        try {
            enum_ = FontGenerator.GeneratorMethod.valueOf(properties.getProperty(KEY_GENERATOR_METHOD, FontGenerator.GeneratorMethod.AWT_VECTOR.name()));
            if (!((FontGenerator.GeneratorMethod)enum_).isAvailable) {
                enum_ = FontGenerator.GeneratorMethod.AWT_VECTOR;
            }
            this.generatorModeCB.setSelected(this.generatorModesModel.findElement((Object)enum_));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.manualPaddingModel.setValue(!Boolean.parseBoolean(properties.getProperty(KEY_PADDING_AUTOMATIC, "false")));
        for (int i = 0; i < 5; ++i) {
            int n3 = 0;
            try {
                n3 = Integer.parseInt(properties.getProperty(KEY_PADDING[i], "0"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.paddingModels[i].setValue(n3);
        }
        this.charSet.load(properties);
        this.effectsPanel.load(properties);
        for (CharSetBlockCB charSetBlockCB : this.unicodeBockCBs) {
            charSetBlockCB.charSetModel.fireCallback();
        }
        this.manualCharactersEditfield.setText(this.charSet.getManualCharacters());
        if (this.fontPath != null) {
            try {
                this.fontData = new FontData(new File(this.fontPath), 32.0f);
            }
            catch (Throwable throwable) {
                Logger.getLogger(FontGenDialog.class.getName()).log(Level.SEVERE, "Can't load font", throwable);
            }
        }
        this.updateCharset();
        this.updateFont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveSettings(File file) {
        Properties properties = new Properties();
        if (this.fontPath != null) {
            properties.setProperty(KEY_FONTPATH, this.fontPath);
        }
        properties.setProperty(KEY_TEXTURESIZE, Integer.toString(this.getTextureSize()));
        properties.setProperty(KEY_FONTSIZE, Integer.toString(this.fontSizeModel.getValue()));
        properties.setProperty(KEY_EXPORTFORMAT, this.getExportFormat().name());
        properties.setProperty(KEY_USEAA, Boolean.toString(this.useAACheckbox.isActive()));
        properties.setProperty(KEY_GENERATOR_METHOD, this.getGeneratorMethod().name());
        this.charSet.save(properties);
        properties.setProperty(KEY_PADDING_AUTOMATIC, Boolean.toString(!this.manualPaddingModel.getValue()));
        for (int i = 0; i < 5; ++i) {
            properties.setProperty(KEY_PADDING[i], Integer.toString(this.paddingModels[i].getValue()));
        }
        this.effectsPanel.save(properties);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
                properties.store(outputStreamWriter, "TWL theme editor font generator settings");
                outputStreamWriter.close();
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(FontGenDialog.class.getName()).log(Level.SEVERE, "Can't write settings file", iOException);
        }
    }

    void saveFont() {
        final FontGenerator fontGenerator = this.fontDisplay.getLastFontGen();
        if (fontGenerator == null) {
            return;
        }
        SaveFileSelector saveFileSelector = new SaveFileSelector((Widget)this.saveFontButton, Preferences.userNodeForPackage(FontGenDialog.class), FONTGEN_FILE_SELECTOR_KEY, "BMFont files", ".fnt", new SaveFileSelector.Callback(){

            public File[] getFilesCreatedForFileName(File file) {
                return fontGenerator.getFilesCreatedForName(file);
            }

            public void fileNameSelected(File file) {
                try {
                    fontGenerator.write(file, FontGenDialog.this.getExportFormat());
                }
                catch (IOException iOException) {
                    Logger.getLogger(FontGenDialog.class.getName()).log(Level.SEVERE, "Cound not save font", iOException);
                }
            }

            public void canceled() {
            }
        });
        saveFileSelector.openPopup();
    }

    void close() {
        this.popupWindow.closePopup();
    }

    void updateStatusBar() {
        FontGenerator fontGenerator = this.fontDisplay.getLastFontGen();
        if (fontGenerator == null) {
            this.fontMetricInfoLabel.setText("<not available>");
            this.setStatusBar("Select a font", 1);
            return;
        }
        this.fontMetricInfoLabel.setText("height: " + fontGenerator.getLineHeight() + " ascent: " + fontGenerator.getAscent() + " descent: " + fontGenerator.getDescent());
        int n = fontGenerator.getUsedTextureHeight();
        if (n == 0) {
            this.setStatusBar("Select unicode blocks to include", 1);
            return;
        }
        Integer n2 = this.getTextureSize();
        if (n > n2) {
            this.setStatusBar("Not all characters could fit onto the selected texture size (need " + (n - n2) + " lines more)", 1);
            return;
        }
        this.setStatusBar("Used " + n + " of " + n2 + " lines", 0);
    }

    void setFontDisplayTheme() {
        FontDisplayBG fontDisplayBG = (FontDisplayBG)((Object)this.fontDisplayBgCB.getModel().getEntry(this.fontDisplayBgCB.getSelected()));
        this.fontDisplay.setTheme(fontDisplayBG.theme);
        this.fontDisplay.reapplyTheme();
    }

    void selectFont() {
        FontSelectPopup fontSelectPopup = new FontSelectPopup((Widget)this.selectFontBtn);
        fontSelectPopup.addCallback(new FontSelectPopup.Callback(){

            public void fontSelected(String string, FontData fontData) {
                FontGenDialog.this.fontSelected(string, fontData);
            }
        });
        fontSelectPopup.openPopup();
        if (this.fontPath != null) {
            fontSelectPopup.selectFile(this.fontPath);
        }
    }

    void fontSelected(String string, FontData fontData) {
        this.fontPath = string;
        this.fontData = fontData;
        this.fontPathEF.setText(string);
        this.updateFont();
    }

    void updatePadding() {
        if (this.manualPaddingModel.getValue()) {
            Padding padding = new Padding(this.paddingModels[0].getValue(), this.paddingModels[1].getValue(), this.paddingModels[2].getValue(), this.paddingModels[3].getValue(), this.paddingModels[4].getValue());
            this.fontDisplay.setPaddingManual(padding);
        } else {
            this.fontDisplay.setPaddingAutomatic();
        }
    }

    void updateManualCharacters() {
        this.charSet.setManualCharacters(this.manualCharactersEditfield.getText());
        this.updateCharset();
    }

    void updateCharset() {
        this.fontDisplay.setCharSet(this.charSet);
    }

    void updateFont() {
        if (this.fontData != null) {
            HashSet<Character.UnicodeBlock> hashSet = this.fontData.getDefinedBlocks();
            for (CharSetBlockCB charSetBlockCB : this.unicodeBockCBs) {
                charSetBlockCB.setEnabled(hashSet.contains(charSetBlockCB.charSetModel.block));
            }
            this.fontDisplay.setFontData(this.fontData.deriveFont(this.fontSizeModel.getValue()));
        } else {
            this.fontDisplay.setFontData(null);
        }
    }

    void updateAA() {
        this.fontDisplay.setUseAA(this.useAACheckbox.isActive());
    }

    void updateGeneratorMode() {
        FontGenerator.GeneratorMethod generatorMethod = this.getGeneratorMethod();
        this.fontDisplay.setGeneratorMethod(generatorMethod);
        this.effectsPanel.enableEffectsPanels(generatorMethod.supportsEffects);
        this.useAACheckbox.setVisible(generatorMethod.supportsAAflag);
    }

    void updateTextureSize() {
        this.fontDisplay.setTextureSize(this.getTextureSize());
    }

    Integer getTextureSize() {
        return (Integer)this.textureSizesModel.getEntry(this.textureSizeCB.getSelected());
    }

    FontGenerator.GeneratorMethod getGeneratorMethod() {
        return (FontGenerator.GeneratorMethod)((Object)this.generatorModesModel.getEntry(this.generatorModeCB.getSelected()));
    }

    FontGenerator.ExportFormat getExportFormat() {
        int n = this.exportFormatCB.getSelected();
        if (n >= 0) {
            return (FontGenerator.ExportFormat)this.exportFormatModel.getEntry(n);
        }
        return FontGenerator.ExportFormat.XML;
    }

    void updateEffects() {
        this.fontDisplay.setEffects(this.effectsPanel.getActiveEffects());
    }

    private void setStatusBar(String string, int n) {
        this.statusBar.setText(string);
        DecoratedTextRenderer.setAnimationState(this.statusBar.getAnimationState(), n);
    }

    static class CharSetBlockCB
    extends ToggleButton {
        final CharSetBlockModel charSetModel;

        public CharSetBlockCB(CharSetBlockModel charSetBlockModel) {
            super((BooleanModel)charSetBlockModel);
            this.charSetModel = charSetBlockModel;
            this.setText(CharSetBlockCB.getName(charSetBlockModel.block));
            this.setTheme("checkbox");
        }

        public CharSetBlockModel getCharSetModel() {
            return this.charSetModel;
        }

        private static String getName(Character.UnicodeBlock unicodeBlock) {
            char[] cArray = unicodeBlock.toString().toCharArray();
            boolean bl = false;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '_') {
                    cArray[i] = 32;
                    bl = false;
                    continue;
                }
                if (bl) {
                    cArray[i] = Character.toLowerCase(cArray[i]);
                    continue;
                }
                bl = true;
            }
            return new String(cArray);
        }
    }

    static class CharSetBlockModel
    extends HasCallback
    implements BooleanModel {
        final CharSet charSet;
        final Character.UnicodeBlock block;

        public CharSetBlockModel(CharSet charSet, Character.UnicodeBlock unicodeBlock) {
            this.charSet = charSet;
            this.block = unicodeBlock;
        }

        public boolean getValue() {
            return this.charSet.getBlockEnabled(this.block);
        }

        public void setValue(boolean bl) {
            this.charSet.setBlock(this.block, bl);
            this.doCallback();
        }

        void fireCallback() {
            super.doCallback();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FontDisplayBG {
        BLACK("Black", "fontdisplay-black"),
        WHITE("White", "fontdisplay-white"),
        CHECKERBOARD("Checker board", "fontdisplay-checkerboard");

        final String text;
        final String theme;

        private FontDisplayBG(String string2, String string3) {
            this.text = string2;
            this.theme = string3;
        }

        public String toString() {
            return this.text;
        }
    }
}

