/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.fontgen.gui;

import de.matthiasmann.twl.FileSelector;
import de.matthiasmann.twl.FileTable;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.FileSystemModel;
import de.matthiasmann.twl.model.JavaFileSystemModel;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twlthemeeditor.fontgen.FontData;
import de.matthiasmann.twlthemeeditor.fontgen.gui.FontPreview;
import de.matthiasmann.twlthemeeditor.gui.MainUI;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class FontSelectPopup
extends PopupWindow {
    private static final String PREF_FS = "fontSelector";
    private final FileSelector fileSelector = new FileSelector(Preferences.userNodeForPackage(FontSelectPopup.class), "fontSelector");
    private final FontPreview preview = new FontPreview();
    private String fontPath;
    private FontData fontData;
    private Callback[] callbacks;

    public FontSelectPopup(Widget widget) {
        super(widget);
        this.fileSelector.setFileSystemModel((FileSystemModel)JavaFileSystemModel.getInstance());
        this.fileSelector.addFileFilter(new FileSelector.NamedFileFilter("TrueType fonts", (FileSystemModel.FileFilter)new MainUI.ExtFilter(".ttf")));
        this.fileSelector.setAllowMultiSelection(false);
        this.fileSelector.setUserWidgetBottom((Widget)this.preview);
        this.fileSelector.getFileTable().addCallback(new FileTable.Callback(){

            public void selectionChanged() {
                FontSelectPopup.this.updatePreview();
            }

            public void sortingChanged() {
            }
        });
        this.fileSelector.addCallback(new FileSelector.Callback(){

            public void filesSelected(Object[] objectArray) {
                FontSelectPopup.this.fireAcceptFont();
            }

            public void canceled() {
                FontSelectPopup.this.closePopup();
            }
        });
        this.add((Widget)this.fileSelector);
        this.setCloseOnClickedOutside(false);
    }

    public void addCallback(Callback callback) {
        this.callbacks = (Callback[])CallbackSupport.addCallbackToList((Object[])this.callbacks, (Object)callback, Callback.class);
    }

    public void removeCallback(Callback callback) {
        this.callbacks = (Callback[])CallbackSupport.removeCallbackFromList((Object[])this.callbacks, (Object)callback);
    }

    public boolean selectFile(String string) {
        return this.fileSelector.selectFile((Object)new File(string));
    }

    public boolean openPopup() {
        if (super.openPopup()) {
            int n = this.getGUI().getInnerWidth();
            int n2 = this.getGUI().getInnerHeight();
            this.setSize(n * 4 / 5, n2 * 4 / 5);
            this.setPosition(n / 2 - this.getWidth() / 2, n2 / 2 - this.getHeight() / 2);
            this.validateLayout();
            return true;
        }
        return false;
    }

    void updatePreview() {
        this.fontPath = null;
        this.fontData = null;
        FileTable.Entry[] entryArray = this.fileSelector.getFileTable().getSelection();
        if (entryArray.length > 0) {
            FileTable.Entry entry = entryArray[0];
            if (!entry.isFolder && entry.obj instanceof File) {
                try {
                    this.fontData = new FontData((File)entry.obj, 32.0f);
                    this.fontPath = entry.getPath();
                }
                catch (Throwable throwable) {
                    Logger.getLogger(FontSelectPopup.class.getName()).log(Level.SEVERE, "Can't open font: " + entry.getPath(), throwable);
                }
            }
        }
        if (this.fontData != null) {
            this.fileSelector.setOkButtonEnabled(true);
            this.preview.setFont(this.fontData.getJavaFont());
            this.preview.setTooltipContent(this.fontData.getName());
        } else {
            this.fileSelector.setOkButtonEnabled(false);
            this.preview.setFont(null);
            this.preview.setTooltipContent(null);
        }
    }

    void fireAcceptFont() {
        if (this.fontData != null) {
            if (this.callbacks != null) {
                for (Callback callback : this.callbacks) {
                    callback.fontSelected(this.fontPath, this.fontData);
                }
            }
            this.closePopup();
        }
    }

    public static interface Callback {
        public void fontSelected(String var1, FontData var2);
    }
}

