/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Timer;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.renderer.AnimationState;

public final class CollapsiblePanel
extends DialogLayout {
    public static final AnimationState.StateKey STATE_EXPANDED = AnimationState.StateKey.get((String)"expanded");
    private final Direction direction;
    private final Arrow arrow;
    private final ContentContainer container;
    private boolean expanded;
    private static final int STEP = 2;
    private static final int MAX_SPEED = 25;
    private static final int DELAY = 20;

    public CollapsiblePanel(Direction direction, String string, Widget widget, final BooleanModel booleanModel) {
        ToggleButton toggleButton;
        DialogLayout.Group group;
        DialogLayout.Group group2;
        this.direction = direction;
        this.arrow = new Arrow();
        this.container = new ContentContainer(widget);
        if (direction == Direction.VERTICAL) {
            group2 = this.createSequentialGroup();
            group = this.createParallelGroup();
        } else {
            group2 = this.createParallelGroup();
            group = this.createSequentialGroup();
        }
        group2.addWidget((Widget)this.arrow);
        group.addWidget((Widget)this.arrow);
        if (booleanModel != null) {
            toggleButton = new ToggleButton(booleanModel);
            toggleButton.setTheme("active");
            group2.addWidget((Widget)toggleButton);
            group.addWidget((Widget)toggleButton);
        }
        if (string != null && string.length() > 0) {
            toggleButton = new Label(string);
            toggleButton.setTheme("title");
            toggleButton.setLabelFor(widget);
            group2.addWidget((Widget)toggleButton);
            group.addWidget((Widget)toggleButton);
        }
        if (direction == Direction.VERTICAL) {
            group2.addGap();
            this.setHorizontalGroup(this.createParallelGroup().addGroup(group2).addWidget((Widget)this.container));
            this.setVerticalGroup(this.createSequentialGroup().addGroup(group).addGap("title-content").addWidget((Widget)this.container));
        } else {
            this.setHorizontalGroup(this.createSequentialGroup().addGroup(group2).addGap("title-content").addWidget((Widget)this.container));
            this.setVerticalGroup(this.createParallelGroup().addGroup(group).addWidget((Widget)this.container));
        }
        if (booleanModel == null || booleanModel.getValue()) {
            this.toggleExpand();
        } else {
            this.container.setEnabled(false);
        }
        if (booleanModel != null) {
            booleanModel.addCallback(new Runnable(){

                public void run() {
                    if (booleanModel.getValue() && !CollapsiblePanel.this.expanded) {
                        CollapsiblePanel.this.toggleExpand();
                    }
                }
            });
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        if (this.expanded != bl) {
            this.toggleExpand();
        }
    }

    protected void widgetDisabled() {
        super.widgetDisabled();
        this.setExpanded(false);
    }

    void toggleExpand() {
        this.expanded ^= true;
        this.arrow.getAnimationState().setAnimationState(STATE_EXPANDED, this.expanded);
        this.container.startAnimate();
        this.container.setEnabled(this.expanded);
    }

    class Arrow
    extends Label {
        Arrow() {
        }

        public boolean handleEvent(Event event) {
            if (event.getType() == Event.Type.MOUSE_CLICKED && event.getMouseClickCount() == 1) {
                CollapsiblePanel.this.toggleExpand();
                return true;
            }
            return event.isMouseEventNoWheel();
        }
    }

    class ContentContainer
    extends Widget
    implements Runnable {
        private final Widget content;
        private Timer timer;
        private int prefInnerSize = -1;
        private int speed;

        public ContentContainer(Widget widget) {
            this.content = widget;
            this.add(widget);
            this.setClip(true);
        }

        protected void afterAddToGUI(GUI gUI) {
            super.afterAddToGUI(gUI);
            this.timer = gUI.createTimer();
            this.timer.setContinuous(true);
            this.timer.setDelay(20);
            this.timer.setCallback((Runnable)this);
        }

        protected void beforeRemoveFromGUI(GUI gUI) {
            this.timer.stop();
            this.timer = null;
            super.beforeRemoveFromGUI(gUI);
        }

        public int getMinWidth() {
            int n = super.getMinWidth();
            if (CollapsiblePanel.this.direction == Direction.VERTICAL) {
                n = Math.max(n, this.getBorderHorizontal() + this.content.getMinWidth());
            }
            return n;
        }

        public int getMinHeight() {
            int n = super.getMinHeight();
            if (CollapsiblePanel.this.direction == Direction.HORIZONTAL) {
                n = Math.max(n, this.getBorderVertical() + this.content.getMinHeight());
            }
            return n;
        }

        public int getPreferredInnerWidth() {
            if (CollapsiblePanel.this.direction == Direction.VERTICAL) {
                return this.content.getPreferredWidth();
            }
            if (this.prefInnerSize < 0) {
                this.prefInnerSize = this.computePreferredInnerSize();
            }
            return this.prefInnerSize;
        }

        public int getPreferredInnerHeight() {
            if (CollapsiblePanel.this.direction == Direction.HORIZONTAL) {
                return this.content.getPreferredHeight();
            }
            if (this.prefInnerSize < 0) {
                this.prefInnerSize = this.computePreferredInnerSize();
            }
            return this.prefInnerSize;
        }

        public void run() {
            int n = this.computePreferredInnerSize();
            if (n == this.prefInnerSize) {
                this.timer.stop();
            } else {
                this.prefInnerSize = this.prefInnerSize < n ? Math.min(this.prefInnerSize + this.speed, n) : Math.max(this.prefInnerSize - this.speed, n);
            }
            this.speed = Math.min(this.speed + 2, 25);
            this.checkSize();
        }

        private int computePreferredInnerSize() {
            if (!CollapsiblePanel.this.expanded) {
                return 0;
            }
            if (CollapsiblePanel.this.direction == Direction.VERTICAL) {
                return ContentContainer.computeSize((int)0, (int)this.content.getPreferredHeight(), (int)this.content.getMaxHeight());
            }
            return ContentContainer.computeSize((int)0, (int)this.content.getPreferredWidth(), (int)this.content.getMaxWidth());
        }

        private void checkSize() {
            int n;
            int n2 = n = CollapsiblePanel.this.direction == Direction.VERTICAL ? this.getInnerHeight() : this.getInnerWidth();
            if (n != this.prefInnerSize) {
                super.invalidateLayout();
            }
        }

        protected void paintWidget(GUI gUI) {
            this.checkSize();
        }

        protected void childInvalidateLayout(Widget widget) {
            this.startAnimate();
        }

        void startAnimate() {
            if (this.timer != null && !this.timer.isRunning()) {
                this.speed = 2;
                this.timer.start();
            }
        }

        protected void layout() {
            this.layoutChildFullInnerArea(this.content);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

