/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.TableBase;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AutoCompletionDataSource;
import de.matthiasmann.twl.model.AutoCompletionResult;
import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.model.SimpleAutoCompletionResult;
import de.matthiasmann.twl.model.SimpleChangableListModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twlthemeeditor.datamodel.Image;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.NodeReference;
import de.matthiasmann.twlthemeeditor.datamodel.Theme;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeModel;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.gui.MessageLog;
import de.matthiasmann.twlthemeeditor.gui.PreviewDebugHook;
import de.matthiasmann.twlthemeeditor.gui.PropertyFactories;
import de.matthiasmann.twlthemeeditor.gui.ThemeTreePane;
import de.matthiasmann.twlthemeeditor.gui.editors.AnimStateEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.ConditionEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.NodeReferenceEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.WidgetThemeEditorFactory;
import de.matthiasmann.twlthemeeditor.properties.ConditionProperty;
import de.matthiasmann.twlthemeeditor.properties.NodeReferenceProperty;
import de.matthiasmann.twlthemeeditor.properties.WidgetThemeProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
extends PropertyFactories {
    private static final MessageLog.Category CAT_JUMP = new MessageLog.Category("Jump to element", MessageLog.CombineMode.NONE, 2);
    private static final MessageLog.Category CAT_ERROR = new MessageLog.Category("Exception", MessageLog.CombineMode.NONE, 1);
    private final MessageLog messageLog;
    private final ThemeTreeModel model;
    private final PreviewDebugHook debugHook;
    private final Set<String> standardStates;
    private ThemeTreePane themeTreePane;

    public Context(MessageLog messageLog, ThemeTreeModel themeTreeModel) {
        this.messageLog = messageLog;
        this.model = themeTreeModel;
        this.debugHook = new PreviewDebugHook();
        this.factories1.put(ConditionProperty.class, (Object)new ConditionEditorFactory(this));
        this.factories1.put(NodeReferenceProperty.class, (Object)new NodeReferenceEditorFactory(this));
        this.factories1.put(WidgetThemeProperty.class, (Object)new WidgetThemeEditorFactory(this));
        this.factories2.put(AnimationState.class, (Object)new AnimStateEditorFactory(this));
        this.standardStates = new TreeSet<String>();
        this.collectStandardStates(Widget.class);
        this.collectStandardStates(Button.class);
        this.collectStandardStates(TableBase.class);
        this.collectStandardStates(EditField.class);
    }

    public void logMessage(MessageLog.Entry entry) {
        this.messageLog.add(entry);
    }

    private void logException(String string, String string2, Throwable throwable) {
        this.logMessage(new MessageLog.Entry(CAT_ERROR, "Exception while " + string, string2, throwable, new MessageLog.EntryAction[0]));
    }

    public ListModel<String> getRefableNodes(ThemeTreeNode themeTreeNode, Kind kind) {
        SimpleChangableListModel simpleChangableListModel = new SimpleChangableListModel();
        switch (kind) {
            case IMAGE: {
                simpleChangableListModel.addElement((Object)"none");
            }
            case CURSOR: {
                for (Image image : this.model.getImages((TreeTableNode)themeTreeNode)) {
                    if (image.getKind() != kind) continue;
                    simpleChangableListModel.addElement((Object)image.getName());
                }
                break;
            }
            default: {
                for (ThemeTreeNode themeTreeNode2 : this.model.getTopLevelNodes(ThemeTreeNode.class, (TreeTableNode)themeTreeNode)) {
                    if (themeTreeNode2.getKind() != kind) continue;
                    simpleChangableListModel.addElement((Object)themeTreeNode2.getName());
                }
            }
        }
        return simpleChangableListModel;
    }

    public Theme findTheme(String[] stringArray) {
        ThemeData themeData;
        if (stringArray != null && stringArray.length > 0 && (themeData = this.findThemeData(stringArray)) != null) {
            return themeData.themeNode;
        }
        return null;
    }

    public ListModel<String> getRefableThemes(String[] stringArray) {
        if (stringArray.length == 0) {
            return this.getRefableNodes(null, Kind.THEME);
        }
        SimpleChangableListModel simpleChangableListModel = new SimpleChangableListModel();
        ThemeData themeData = this.findThemeData(stringArray);
        if (themeData != null) {
            TreeSet<String> treeSet;
            simpleChangableListModel.addElements(themeData.children.keySet());
            if (themeData.hasWildcard) {
                treeSet = new TreeSet<String>();
                for (ThemeTreeNode themeTreeNode : this.model.getTopLevelNodes(ThemeTreeNode.class, null)) {
                    String string;
                    Theme theme;
                    if (!(themeTreeNode instanceof Theme) || !(theme = (Theme)themeTreeNode).isAllowWildcard() || themeData.children.containsKey(string = theme.getName())) continue;
                    treeSet.add(string);
                }
                simpleChangableListModel.addElements(treeSet);
            }
            treeSet = new TreeSet();
            for (ThemeTreeNode themeTreeNode : this.model.getTopLevelNodes(ThemeTreeNode.class, null)) {
                if (!(themeTreeNode instanceof Theme)) continue;
                treeSet.add("/".concat(((Theme)themeTreeNode).getName()));
            }
            simpleChangableListModel.addElements(treeSet);
        }
        return simpleChangableListModel;
    }

    private ThemeData findThemeData(String[] stringArray) {
        HashMap<String, ThemeData> hashMap = new HashMap<String, ThemeData>();
        ThemeData themeData = this.parseTheme(stringArray[0], hashMap);
        for (int i = 1; i < stringArray.length && themeData != null; ++i) {
            themeData = this.getChildTheme(themeData, stringArray[i], hashMap);
        }
        return themeData;
    }

    private ThemeData getChildTheme(ThemeData themeData, String string, HashMap<String, ThemeData> hashMap) {
        ThemeData themeData2 = themeData.children.get(string);
        if (themeData2 == null && themeData.hasWildcard) {
            return this.parseTheme(string, hashMap);
        }
        return themeData2;
    }

    private ThemeData parseTheme(String string, HashMap<String, ThemeData> hashMap) {
        ThemeTreeNode themeTreeNode;
        ThemeData themeData = hashMap.get(string);
        if (themeData == null && this.model != null && (themeTreeNode = this.model.findNode(string, Kind.THEME)) instanceof Theme) {
            Theme theme = (Theme)themeTreeNode;
            themeData = this.parseTheme(null, theme, hashMap);
        }
        return themeData;
    }

    private ThemeData parseTheme(ThemeData themeData, Theme theme, HashMap<String, ThemeData> hashMap) {
        ThemeData themeData2;
        Object object;
        ThemeData themeData3 = new ThemeData(theme);
        if (themeData == null) {
            hashMap.put(themeData3.name, themeData3);
        }
        if (theme.isMerge() && themeData != null && (object = themeData.children.get(themeData3.name)) != null) {
            themeData3.copy((ThemeData)object);
        }
        if ((object = theme.getRef()) != null && (themeData2 = this.parseTheme(((NodeReference)object).getName(), hashMap)) != null) {
            themeData3.copy(themeData2);
        }
        int n = theme.getNumChildren();
        for (int i = 0; i < n; ++i) {
            TreeTableNode treeTableNode = theme.getChild(i);
            if (!(treeTableNode instanceof Theme)) continue;
            Theme theme2 = (Theme)treeTableNode;
            if (theme2.isWildcard()) {
                themeData3.hasWildcard = true;
                continue;
            }
            ThemeData themeData4 = this.parseTheme(themeData3, theme2, hashMap);
            themeData3.children.put(themeData4.name, themeData4);
        }
        return themeData3;
    }

    public AutoCompletionDataSource collectAllStates() {
        String[] stringArray;
        TreeSet<String> treeSet = new TreeSet<String>(this.standardStates);
        for (Image object : this.model.getImages(null)) {
            this.collectStates(object, treeSet);
        }
        try {
            stringArray = AnimationState.StateKey.class.getDeclaredField("keys");
            stringArray.setAccessible(true);
            HashMap hashMap = (HashMap)stringArray.get(null);
            treeSet.addAll(hashMap.keySet());
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringArray = treeSet.toArray(new String[treeSet.size()]);
        return new AutoCompletionDataSource(){

            public AutoCompletionResult collectSuggestions(String string, int n, AutoCompletionResult autoCompletionResult) {
                int n2;
                int n3;
                for (n3 = n; n3 > 0 && Character.isJavaIdentifierPart(string.charAt(n3 - 1)); --n3) {
                }
                if (n3 == n) {
                    return null;
                }
                for (n2 = n; n2 < string.length() && Character.isJavaIdentifierPart(string.charAt(n2)); ++n2) {
                }
                String string2 = string.substring(n3, n).toLowerCase();
                String string3 = string.substring(0, n3);
                String string4 = string.substring(n2);
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (String string5 : stringArray) {
                    int n4 = string5.toLowerCase().indexOf(string2);
                    if (n4 < 0) continue;
                    String string6 = string3 + string5 + string4;
                    if (n4 == 0) {
                        arrayList.add(string6);
                        continue;
                    }
                    arrayList2.add(string6);
                }
                arrayList.addAll(arrayList2);
                final int n5 = string4.length();
                return new SimpleAutoCompletionResult(string, n3, arrayList){

                    public int getCursorPosForResult(int n) {
                        return super.getResult(n).length() - n5;
                    }
                };
            }
        };
    }

    public void selectTarget(NodeReference nodeReference) {
        if (this.themeTreePane != null && nodeReference != null) {
            try {
                ThemeTreeNode themeTreeNode = this.resolveReference(nodeReference);
                if (themeTreeNode != null) {
                    this.themeTreePane.selectNode((TreeTableNode)themeTreeNode);
                } else {
                    this.logMessage(new MessageLog.Entry(CAT_JUMP, "Could not locate theme element", (Object)((Object)nodeReference.getKind()) + " " + nodeReference.getName(), null, new MessageLog.EntryAction[0]));
                }
            }
            catch (Throwable throwable) {
                this.logException("jump to theme element", (Object)((Object)nodeReference.getKind()) + " " + nodeReference.getName(), throwable);
            }
        }
    }

    public void selectTarget(ThemeTreeNode themeTreeNode) {
        if (this.themeTreePane != null && themeTreeNode != null) {
            try {
                this.themeTreePane.selectNode((TreeTableNode)themeTreeNode);
            }
            catch (Throwable throwable) {
                this.logException("jump to theme element", (Object)((Object)themeTreeNode.getKind()) + " " + themeTreeNode.getName(), throwable);
            }
        }
    }

    public void resolveReference(NodeReference nodeReference, Collection<ThemeTreeNode> collection) {
        if (nodeReference != null && !nodeReference.isNone()) {
            if (nodeReference.isWildcard()) {
                this.model.collectNodes(nodeReference.getBaseName(), nodeReference.getKind(), collection);
            } else {
                ThemeTreeNode themeTreeNode = this.model.findNode(nodeReference.getName(), nodeReference.getKind());
                if (themeTreeNode != null) {
                    collection.add(themeTreeNode);
                }
            }
        }
    }

    private ThemeTreeNode resolveReference(NodeReference nodeReference) {
        if (nodeReference != null && !nodeReference.isNone()) {
            return this.model.findNode(nodeReference.getName(), nodeReference.getKind());
        }
        return null;
    }

    public void selectTheme(String[] stringArray) {
        if (this.themeTreePane != null) {
            try {
                Theme theme = this.findTheme(stringArray);
                if (theme != null) {
                    this.themeTreePane.selectNode((TreeTableNode)theme);
                } else {
                    this.logMessage(new MessageLog.Entry(CAT_JUMP, "Could not locate theme element", Arrays.toString(stringArray), null, new MessageLog.EntryAction[0]));
                }
            }
            catch (Throwable throwable) {
                this.logException("jump to theme element", Arrays.toString(stringArray), throwable);
            }
        }
    }

    public ThemeTreeModel getThemeTreeModel() {
        return this.model;
    }

    public ThemeTreePane getThemeTreePane() {
        return this.themeTreePane;
    }

    public void setThemeTreePane(ThemeTreePane themeTreePane) {
        this.themeTreePane = themeTreePane;
    }

    private void collectStates(Image image, Set<String> set) {
        String string = image.getCondition().getCondition();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            while (n < n2 && !Character.isJavaIdentifierStart(string.charAt(n))) {
                ++n;
            }
            int n3 = n;
            while (n < n2 && Character.isJavaIdentifierPart(string.charAt(n))) {
                ++n;
            }
            String string2 = string.substring(n3, n);
            set.add(string2);
        }
        for (Image image2 : image.getChildren(Image.class)) {
            this.collectStates(image2, set);
        }
    }

    private void collectStandardStates(Class<? extends Widget> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            int n = field.getModifiers();
            if (!Modifier.isPublic(n) || !Modifier.isStatic(n) || !Modifier.isFinal(n) || field.getType() != String.class || !field.getName().startsWith("STATE_")) continue;
            try {
                String string = (String)field.get(null);
                this.standardStates.add(string);
            }
            catch (Throwable throwable) {
                Logger.getLogger(Context.class.getName()).log(Level.SEVERE, "Can't read state constant", throwable);
            }
        }
    }

    public void uninstallDebugHook() {
        this.debugHook.uninstall();
    }

    public void installDebugHook() {
        this.debugHook.install();
    }

    public void clearWidgetMessages() {
        this.debugHook.clear();
    }

    public boolean checkLayoutValidated() {
        return this.debugHook.checkLayoutValidated();
    }

    public Object getTooltipForWidget(Widget widget) {
        PreviewDebugHook.Entry entry = this.debugHook.getEntry(widget);
        if (entry != null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendMsgs(stringBuilder, entry.errorMsg, "Error");
            this.appendMsgs(stringBuilder, entry.warningMsg, "Warning");
            this.stripTrailingNewline(stringBuilder);
            return stringBuilder.toString();
        }
        return null;
    }

    public int getWidgetFlags(Widget widget) {
        PreviewDebugHook.Entry entry = this.debugHook.getEntry(widget);
        if (entry != null) {
            return (entry.errorMsg.isEmpty() ? 0 : 1) | (entry.warningMsg.isEmpty() ? 0 : 2);
        }
        return 0;
    }

    private void appendMsgs(StringBuilder stringBuilder, Collection<String> collection, String string) {
        if (!collection.isEmpty()) {
            stringBuilder.append(string).append(":\n");
            for (String string2 : collection) {
                stringBuilder.append(string2).append('\n');
            }
        }
    }

    private void stripTrailingNewline(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) == '\n') {
            stringBuilder.deleteCharAt(n - 1);
        }
    }

    static class ThemeData {
        final Theme themeNode;
        final String name;
        final TreeMap<String, ThemeData> children;
        boolean hasWildcard;

        ThemeData(Theme theme) {
            this.themeNode = theme;
            this.name = theme.getName();
            this.children = new TreeMap();
        }

        void copy(ThemeData themeData) {
            this.hasWildcard |= themeData.hasWildcard;
            this.children.putAll(themeData.children);
        }
    }
}

