/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.FileSelector;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.FileSystemModel;
import de.matthiasmann.twl.model.JavaFileSystemModel;
import de.matthiasmann.twlthemeeditor.gui.MainUI;
import java.io.File;
import java.util.prefs.Preferences;

public class LoadFileSelector {
    final Callback callback;
    final FileSelector fileSelector;
    final PopupWindow popupWindow;

    public LoadFileSelector(Widget widget, Preferences preferences, String string, String string2, String string3, Callback callback) {
        this(widget, preferences, string, string2, new MainUI.ExtFilter(string3), callback);
    }

    public LoadFileSelector(Widget widget, Preferences preferences, String string, String string2, FileSystemModel.FileFilter fileFilter, Callback callback) {
        this.callback = callback;
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        FileSelector.NamedFileFilter namedFileFilter = new FileSelector.NamedFileFilter(string2, fileFilter);
        this.fileSelector = new FileSelector(preferences, string);
        this.fileSelector.setFileSystemModel((FileSystemModel)JavaFileSystemModel.getInstance());
        this.fileSelector.setAllowMultiSelection(false);
        this.fileSelector.addCallback((FileSelector.Callback)new CB());
        this.fileSelector.addFileFilter(FileSelector.AllFilesFilter);
        this.fileSelector.addFileFilter(namedFileFilter);
        this.fileSelector.setFileFilter(namedFileFilter);
        this.popupWindow = new PopupWindow(widget);
        this.popupWindow.setTheme("fileselector-popup");
        this.popupWindow.add((Widget)this.fileSelector);
    }

    public void openPopup() {
        if (this.popupWindow.openPopup()) {
            GUI gUI = this.popupWindow.getGUI();
            this.popupWindow.setSize(gUI.getWidth() * 4 / 5, gUI.getHeight() * 4 / 5);
            this.popupWindow.setPosition((gUI.getWidth() - this.popupWindow.getWidth()) / 2, (gUI.getHeight() - this.popupWindow.getHeight()) / 2);
        }
    }

    class CB
    implements FileSelector.Callback {
        CB() {
        }

        public void filesSelected(Object[] objectArray) {
            if (objectArray.length == 1 && objectArray[0] instanceof File) {
                LoadFileSelector.this.popupWindow.closePopup();
                LoadFileSelector.this.callback.fileSelected((File)objectArray[0]);
            }
        }

        public void canceled() {
            LoadFileSelector.this.popupWindow.closePopup();
            LoadFileSelector.this.callback.canceled();
        }
    }

    public static interface Callback {
        public void fileSelected(File var1);

        public void canceled();
    }
}

