/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.Clipboard;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Menu;
import de.matthiasmann.twl.MenuAction;
import de.matthiasmann.twl.MenuCheckbox;
import de.matthiasmann.twl.MenuElement;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.SimpleDialog;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.FileSystemModel;
import de.matthiasmann.twl.model.JavaFileSystemModel;
import de.matthiasmann.twl.model.MRUListModel;
import de.matthiasmann.twl.model.PersistentMRUListModel;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.StyleSheet;
import de.matthiasmann.twl.textarea.StyleSheetResolver;
import de.matthiasmann.twl.textarea.TextAreaModel;
import de.matthiasmann.twlthemeeditor.Main;
import de.matthiasmann.twlthemeeditor.datamodel.Include;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeModel;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.fontgen.gui.FontGenDialog;
import de.matthiasmann.twlthemeeditor.gui.EditorArea;
import de.matthiasmann.twlthemeeditor.gui.LoadFileSelector;
import de.matthiasmann.twlthemeeditor.gui.MessageLog;
import de.matthiasmann.twlthemeeditor.gui.NewProjectDialog;
import de.matthiasmann.twlthemeeditor.gui.NewProjectSettings;
import de.matthiasmann.twlthemeeditor.gui.StatusBar;
import de.matthiasmann.twlthemeeditor.imgconv.ConvertImageDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;

public final class MainUI
extends DialogLayout {
    private static final String KEY_PROJECT_FILESELECTOR = "projectsFiles";
    private static final String KEY_RECENT_PROJECTS = "recentProjects";
    private static final MessageLog.Category CAT_PROJECT = new MessageLog.Category("Project", MessageLog.CombineMode.NONE, 0);
    private static final MessageLog.Category CAT_PROJECT_WARNING = new MessageLog.Category("Project", MessageLog.CombineMode.NONE, 2);
    private static final MessageLog.Category CAT_PROJECT_ERROR = new MessageLog.Category("Project", MessageLog.CombineMode.NONE, 1);
    private final Preferences prefs = Preferences.userNodeForPackage(MainUI.class);
    private final MessageLog messageLog = new MessageLog();
    private final EditorArea editorArea = new EditorArea(this.messageLog);
    private final StatusBar statusBar = new StatusBar(this.messageLog);
    private final MenuAction btnSaveProject;
    private final Menu recentProjectsMenu;
    private final MRUListModel<String> recentProjectsModel;
    private boolean closeRequested;
    private ThemeTreeModel model;
    private File projectDir;
    static final String[] HTML_ESCAPES = new String[]{"&amp;", "&lt;", "&gt;"};

    public MainUI() {
        Menu menu = new Menu("File");
        menu.add("New project...", new Runnable(){

            public void run() {
                MainUI.this.newProject();
            }
        });
        menu.add("Open project...", new Runnable(){

            public void run() {
                MainUI.this.openProject();
            }
        });
        menu.add(new MenuAction("Start demo mode", new Runnable(){

            public void run() {
                MainUI.this.startDemoMode();
            }
        }).setTooltipContent((Object)"Opens the TWL Theme Editor in read-only mode"));
        this.recentProjectsMenu = new Menu("Open recent Project");
        menu.add((MenuElement)this.recentProjectsMenu);
        this.btnSaveProject = new MenuAction("Save project", new Runnable(){

            public void run() {
                MainUI.this.saveProject();
            }
        });
        menu.add((MenuElement)this.btnSaveProject);
        menu.addSpacer();
        menu.add("Exit", new Runnable(){

            public void run() {
                MainUI.this.exit();
            }
        });
        Menu menu2 = new Menu("View");
        menu2.add(new MenuCheckbox("Layout 1", this.editorArea.getLayoutBooleanModel(EditorArea.Layout.SPLIT_HV)).setTheme("radiobtn"));
        menu2.add(new MenuCheckbox("Layout 2", this.editorArea.getLayoutBooleanModel(EditorArea.Layout.SPLIT_HHV)).setTheme("radiobtn"));
        Menu menu3 = new Menu();
        menu3.setTheme("mainmenu");
        menu3.add((MenuElement)menu);
        menu3.add((MenuElement)menu2);
        this.editorArea.addMenus(menu3);
        Menu menu4 = new Menu("Settings");
        this.editorArea.addSettingsMenuItems(menu4);
        menu3.add((MenuElement)menu4);
        Menu menu5 = new Menu("Tools");
        menu5.add("Create font...", new Runnable(){

            public void run() {
                FontGenDialog fontGenDialog = new FontGenDialog((Widget)MainUI.this);
                fontGenDialog.openPopup();
            }
        });
        menu5.add("Convert image...", new Runnable(){

            public void run() {
                ConvertImageDialog convertImageDialog = new ConvertImageDialog((Widget)MainUI.this);
                convertImageDialog.openPopup();
            }
        });
        menu5.addSpacer();
        menu5.add("Reload all images", new Runnable(){

            public void run() {
                MainUI.this.editorArea.reapplyTheme();
            }
        });
        menu3.add((MenuElement)menu5);
        Menu menu6 = new Menu("Help");
        menu6.add("About", new Runnable(){

            public void run() {
                MainUI.this.openAboutDialog();
            }
        });
        menu3.add((MenuElement)menu6);
        Widget widget = menu3.createMenuBar();
        this.recentProjectsModel = new PersistentMRUListModel(5, String.class, this.prefs, KEY_RECENT_PROJECTS);
        this.btnSaveProject.setEnabled(false);
        this.setHorizontalGroup(this.createParallelGroup().addWidget(widget).addWidget((Widget)this.editorArea).addWidget((Widget)this.statusBar));
        this.setVerticalGroup(this.createSequentialGroup().addWidget(widget).addGap("menubar-editorarea").addWidget((Widget)this.editorArea).addGap("editorarea-statusbar").addWidget((Widget)this.statusBar));
        this.popuplateRecentProjectsMenu();
        this.addActionMapping("reloadTestWidget", "reloadTestWidget", new Object[0]);
    }

    protected void afterAddToGUI(GUI gUI) {
        super.afterAddToGUI(gUI);
        this.messageLog.setGUI(gUI);
    }

    protected void beforeRemoveFromGUI(GUI gUI) {
        this.messageLog.setGUI(null);
        super.beforeRemoveFromGUI(gUI);
    }

    public void addMessage(MessageLog.Entry entry) {
        this.messageLog.add(entry);
    }

    public void clearMessages(MessageLog.Category category) {
        this.messageLog.removeAll(category);
    }

    public void openMessagesDialog() {
        this.statusBar.openDetailsDialog();
    }

    void newProject() {
        final PopupWindow popupWindow = new PopupWindow((Widget)this);
        JavaFileSystemModel javaFileSystemModel = JavaFileSystemModel.getInstance();
        NewProjectDialog newProjectDialog = new NewProjectDialog((FileSystemModel)javaFileSystemModel, this.prefs, KEY_PROJECT_FILESELECTOR, new NewProjectDialog.Listener(){

            public void ok(NewProjectSettings newProjectSettings) {
                MainUI.this.newProject(newProjectSettings);
                popupWindow.closePopup();
            }

            public void canceled() {
                popupWindow.closePopup();
            }
        });
        popupWindow.setTheme("newproject-popup");
        popupWindow.add((Widget)newProjectDialog);
        popupWindow.openPopup();
        popupWindow.setSize(this.getWidth() * 4 / 5, popupWindow.getPreferredHeight());
        popupWindow.setPosition(this.getWidth() / 2 - popupWindow.getWidth() / 2, this.getHeight() / 2 - popupWindow.getHeight() / 2);
    }

    void openProject() {
        LoadFileSelector loadFileSelector = new LoadFileSelector((Widget)this, this.prefs, KEY_PROJECT_FILESELECTOR, "XML theme files", ".xml", new LoadFileSelector.Callback(){

            public void fileSelected(File file) {
                MainUI.this.openProject(file);
            }

            public void canceled() {
            }
        });
        loadFileSelector.openPopup();
    }

    void startDemoMode() {
        this.closeProject();
        try {
            this.model = new ThemeTreeModel(this.messageLog, Main.class.getResource("gui.xml"));
            this.projectDir = null;
            this.editorArea.setModel(this.model);
            this.btnSaveProject.setEnabled(false);
            this.editorArea.setDemoMode(true);
            this.messageLog.add(new MessageLog.Entry(CAT_PROJECT, "Demo mode started", null, null, new MessageLog.EntryAction[0]));
        }
        catch (IOException iOException) {
            this.messageLog.add(new MessageLog.Entry(CAT_PROJECT_ERROR, "Could not start demo mode", null, iOException, new MessageLog.EntryAction[0]));
        }
    }

    public boolean isCloseRequested() {
        return this.closeRequested;
    }

    public void closeProject() {
        this.model = null;
        this.projectDir = null;
        this.editorArea.setModel(null);
        this.editorArea.setDemoMode(false);
    }

    public void newProject(NewProjectSettings newProjectSettings) {
        try {
            File file = newProjectSettings.createProject();
            this.messageLog.add(new MessageLog.Entry(CAT_PROJECT, "New project created", file.toString(), null, new MessageLog.EntryAction[0]));
            this.openProject(file);
        }
        catch (IOException iOException) {
            this.messageLog.add(new MessageLog.Entry(CAT_PROJECT_ERROR, "Could not create project", newProjectSettings.toString(), iOException, new MessageLog.EntryAction[0]));
        }
    }

    public void openProject(File file) {
        this.closeProject();
        file = file.getAbsoluteFile();
        try {
            this.model = new ThemeTreeModel(this.messageLog, file.toURI().toURL());
            this.projectDir = file.getParentFile();
            this.editorArea.setModel(this.model);
            this.btnSaveProject.setEnabled(true);
            this.editorArea.setDemoMode(false);
            this.recentProjectsModel.addEntry((Object)file.toString());
            this.popuplateRecentProjectsMenu();
            if (this.model.getRootThemeFile().isHadErrors()) {
                this.messageLog.add(new MessageLog.Entry(CAT_PROJECT_WARNING, "Project loaded with errors", file.toString(), null, new MessageLog.EntryAction[0]));
            } else {
                this.messageLog.add(new MessageLog.Entry(CAT_PROJECT, "Project loaded", file.toString(), null, new MessageLog.EntryAction[0]));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.removeFromRecentProjectsList(file);
            this.messageLog.add(new MessageLog.Entry(CAT_PROJECT_ERROR, "Could not load project", file.toString(), fileNotFoundException, new MessageLog.EntryAction[0]));
        }
        catch (IOException iOException) {
            this.messageLog.add(new MessageLog.Entry(CAT_PROJECT_ERROR, "Could not load project", file.toString(), iOException, new MessageLog.EntryAction[0]));
        }
    }

    public void saveProject() {
        if (this.model != null && this.projectDir != null) {
            this.saveThemeFile(this.model.getRootThemeFile());
            for (Include include : this.model.getTopLevelNodes(Include.class, null)) {
                this.saveThemeFile(include.getIncludedThemeFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveThemeFile(ThemeFile themeFile) {
        if (themeFile.isModified()) {
            try {
                String string = this.projectDir.toURI().relativize(themeFile.getURL().toURI()).getPath();
                File file = new File(this.projectDir, string);
                File file2 = new File(this.projectDir, string.concat(".old"));
                File file3 = new File(this.projectDir, string.concat(".tmp"));
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    try {
                        themeFile.writeTo(fileOutputStream);
                    }
                    finally {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(MainUI.class.getName()).log(Level.SEVERE, "Can't write XML to file: " + file3, iOException);
                    return;
                }
                if (file2.exists() && !file2.delete()) {
                    this.messageLog.add(new MessageLog.Entry(CAT_PROJECT_ERROR, "Could not delete old backup file for " + string, file2.toString(), null, new MessageLog.EntryAction[0]));
                    return;
                }
                if (!file.renameTo(file2)) {
                    this.messageLog.add(new MessageLog.Entry(CAT_PROJECT_ERROR, "Could not backup existing file " + string, file.toString() + "\nBackup file:\n" + file2.toString(), null, new MessageLog.EntryAction[0]));
                    return;
                }
                if (!file3.renameTo(file)) {
                    this.messageLog.add(new MessageLog.Entry(CAT_PROJECT_ERROR, "Could not replace file " + string, file.toString() + "\nNew file:\n" + file3.toString(), null, new MessageLog.EntryAction[0]));
                    return;
                }
                this.messageLog.add(new MessageLog.Entry(CAT_PROJECT, "Wrote " + string, file.toString(), null, new MessageLog.EntryAction[0]));
                themeFile.setModified(false);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.messageLog.add(new MessageLog.Entry(CAT_PROJECT_ERROR, "Could not determine file location for: " + themeFile.getURL(), null, null, new MessageLog.EntryAction[0]));
            }
        }
    }

    public void reloadTestWidget() {
        this.editorArea.reloadTestWidget();
    }

    void exit() {
        this.closeRequested = true;
    }

    void popuplateRecentProjectsMenu() {
        this.recentProjectsMenu.clear();
        int n = this.recentProjectsModel.getNumEntries();
        for (int i = 0; i < n; ++i) {
            final String string = (String)this.recentProjectsModel.getEntry(i);
            this.recentProjectsMenu.add(string, new Runnable(){

                public void run() {
                    MainUI.this.openProject(new File(string));
                }
            });
        }
        this.recentProjectsMenu.setEnabled(n > 0);
    }

    private void removeFromRecentProjectsList(File file) {
        int n = Utils.find(this.recentProjectsModel, file.toString());
        if (n >= 0) {
            this.recentProjectsModel.removeEntry(n);
            this.popuplateRecentProjectsMenu();
        }
    }

    void openAboutDialog() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<img id=\"logo\" src=\"twl-logo\" alt=\"TWL Logo\"/><br/><br/><p>TWL Theme Editor (c) 2010 Matthias Mann</p><br/><table id=\"sysinfo\">\n");
        stringBuilder.append("<tr><td class=\"parameter\">Java</td><td class=\"value\">");
        MainUI.appendHTMLEscape(stringBuilder, System.getProperty("java.version")).append(" (");
        MainUI.appendHTMLEscape(stringBuilder, System.getProperty("java.vendor")).append(")</td></tr>\n");
        stringBuilder.append("<tr><td class=\"parameter\">Platform</td><td class=\"value\">");
        MainUI.appendHTMLEscape(stringBuilder, LWJGLUtil.getPlatformName()).append("</td></tr>\n");
        stringBuilder.append("<tr><td class=\"parameter\">OS</td><td class=\"value\">");
        MainUI.appendHTMLEscape(stringBuilder, System.getProperty("os.name")).append("  ");
        MainUI.appendHTMLEscape(stringBuilder, System.getProperty("os.arch")).append("  Version ");
        MainUI.appendHTMLEscape(stringBuilder, System.getProperty("os.version")).append("</td></tr>\n");
        stringBuilder.append("<tr><td class=\"parameter\"><a href=\"http://www.lwjgl.org\">LWJGL</a></td><td class=\"value\">");
        MainUI.appendHTMLEscape(stringBuilder, Sys.getVersion()).append("</td></tr>\n");
        stringBuilder.append("<tr><td class=\"parameter\">OpenGL</td><td class=\"value\">");
        MainUI.appendHTMLEscape(stringBuilder, GL11.glGetString((int)7938)).append("  ");
        MainUI.appendHTMLEscape(stringBuilder, GL11.glGetString((int)7936)).append("</td></tr>\n");
        stringBuilder.append("<tr><td class=\"parameter\">java.library.path</td><td class=\"value\">");
        MainUI.appendHTMLEscape(stringBuilder, System.getProperty("java.library.path")).append("</td></tr>\n");
        stringBuilder.append("<tr><td class=\"parameter\">jna.library.path</td><td class=\"value\">");
        MainUI.appendHTMLEscape(stringBuilder, System.getProperty("jna.library.path")).append("</td></tr>\n");
        stringBuilder.append("<tr><td class=\"parameter\">org.lwjgl.librarypath</td><td class=\"value\">");
        MainUI.appendHTMLEscape(stringBuilder, System.getProperty("org.lwjgl.librarypath")).append("</td></tr>\n");
        String string = System.getProperty("javawebstart.version");
        if (string != null) {
            stringBuilder.append("<tr><td class=\"parameter\">Webstart</td><td class=\"value\">");
            MainUI.appendHTMLEscape(stringBuilder, string).append("</td></tr>\n");
        }
        stringBuilder.append("<tr><td class=\"parameter\">Icons</td><td class=\"value\"><a href=\"http://www.famfamfam.com/lab/icons/silk/\">www.famfamfam.com</a></td></tr>");
        stringBuilder.append("</table><a href=\"javascript:copyToClipboard()\">Copy above report to clipboard</a>");
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.parse(MainUI.class.getResource("about.css"));
        }
        catch (IOException iOException) {
            Logger.getLogger(MainUI.class.getName()).log(Level.SEVERE, "Can't load style sheet", iOException);
        }
        final String string2 = stringBuilder.toString();
        HTMLTextAreaModel hTMLTextAreaModel = new HTMLTextAreaModel(string2);
        TextArea textArea = new TextArea((TextAreaModel)hTMLTextAreaModel);
        textArea.setStyleClassResolver((StyleSheetResolver)styleSheet);
        textArea.addCallback(new TextArea.Callback(){

            public void handleLinkClicked(String string) {
                if (string.startsWith("javascript:")) {
                    String string22 = string.substring(11);
                    if ("copyToClipboard()".equals(string22)) {
                        Clipboard.setClipboard((String)string2);
                    }
                } else {
                    Sys.openURL((String)string);
                }
            }
        });
        SimpleDialog simpleDialog = new SimpleDialog();
        simpleDialog.setMessage((Object)textArea);
        simpleDialog.setTheme("aboutDialog");
        simpleDialog.showDialog((Widget)this);
    }

    private static StringBuilder appendHTMLEscape(StringBuilder stringBuilder, String string) {
        if (string == null) {
            return stringBuilder.append(string);
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n2 = "&<>".indexOf(c);
            if (n2 < 0) continue;
            stringBuilder.append(string, n, i).append(HTML_ESCAPES[n2]);
            n = i + 1;
        }
        return stringBuilder.append(string, n, string.length());
    }

    public static class ExtFilter
    implements FileSystemModel.FileFilter {
        private final String[] extensions;

        public ExtFilter(String ... stringArray) {
            this.extensions = stringArray;
        }

        public boolean accept(FileSystemModel fileSystemModel, Object object) {
            String string = fileSystemModel.getName(object).toLowerCase();
            for (String string2 : this.extensions) {
                if (!string.endsWith(string2)) continue;
                return true;
            }
            return false;
        }
    }
}

