/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.FileSelector;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ListBox;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.SimpleDialog;
import de.matthiasmann.twl.TableBase;
import de.matthiasmann.twl.TableRowSelectionManager;
import de.matthiasmann.twl.TableSelectionManager;
import de.matthiasmann.twl.TreeTable;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.FileSystemModel;
import de.matthiasmann.twl.model.FileSystemTreeModel;
import de.matthiasmann.twl.model.JavaFileSystemModel;
import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.model.SimpleChangableListModel;
import de.matthiasmann.twl.model.TableSelectionModel;
import de.matthiasmann.twl.model.TableSingleSelectionModel;
import de.matthiasmann.twl.model.TreeTableModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.gui.LoadFileSelector;
import de.matthiasmann.twlthemeeditor.gui.SaveFileSelector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewClasspathDialog
extends PopupWindow {
    private static final String PREF_SELECT_JAR = "userWidgetJARs";
    private static final String PREF_SAVE_CLASSPATH = "selectClasspath";
    private static final String PREF_LAST_FOLDER = "lastFolder";
    private final Callback callback;
    private final Preferences prefs;
    private final DialogLayout layout;
    final SimpleChangableListModel<File> entriesToScan;
    final SimpleChangableListModel<File> entriesDependencies;

    public NewClasspathDialog(Widget widget, Callback callback) {
        super(widget);
        this.callback = callback;
        this.prefs = Preferences.userNodeForPackage(NewClasspathDialog.class);
        this.layout = new DialogLayout();
        DialogLayout.Group group = this.layout.createSequentialGroup();
        DialogLayout.Group group2 = this.layout.createParallelGroup();
        DialogLayout.Group group3 = this.layout.createParallelGroup();
        DialogLayout.Group group4 = this.layout.createSequentialGroup().addGroup(group2).addGroup(group3);
        DialogLayout.Group group5 = this.layout.createParallelGroup().addGroup(group4);
        this.entriesToScan = this.createList(group, group5, group2, group3, "Entries to Scan");
        this.entriesDependencies = this.createList(group, group5, group2, group3, "Dependencies (don't add LWJGL or TWL!)");
        final Button button = new Button("Save");
        button.setEnabled(false);
        button.addCallback(new Runnable(){

            public void run() {
                NewClasspathDialog.this.save();
            }
        });
        Button button2 = new Button("Cancel");
        button2.addCallback(new Runnable(){

            public void run() {
                NewClasspathDialog.this.cancel();
            }
        });
        this.entriesToScan.addChangeListener(new ListModel.ChangeListener(){

            public void entriesInserted(int n, int n2) {
                this.allChanged();
            }

            public void entriesDeleted(int n, int n2) {
                this.allChanged();
            }

            public void entriesChanged(int n, int n2) {
                this.allChanged();
            }

            public void allChanged() {
                button.setEnabled(NewClasspathDialog.this.entriesToScan.getNumEntries() > 0);
            }
        });
        DialogLayout.Group group6 = this.layout.createSequentialGroup().addGap().addWidget((Widget)button).addWidget((Widget)button2);
        DialogLayout.Group group7 = this.layout.createParallelGroup().addWidget((Widget)button).addWidget((Widget)button2);
        this.layout.setHorizontalGroup(group5.addGroup(group6));
        this.layout.setVerticalGroup(group.addGroup(group7));
        this.add((Widget)this.layout);
    }

    public boolean openPopup() {
        if (super.openPopup()) {
            int n = this.getGUI().getInnerWidth();
            int n2 = this.getGUI().getInnerHeight();
            this.setSize(n * 4 / 5, n2 * 4 / 5);
            this.setPosition(n / 2 - this.getWidth() / 2, n2 / 2 - this.getHeight() / 2);
            return true;
        }
        return false;
    }

    void save() {
        if (this.entriesToScan.getNumEntries() > 0) {
            SaveFileSelector saveFileSelector = new SaveFileSelector((Widget)this, this.prefs, PREF_SAVE_CLASSPATH, "TWL Theme Editor classpath file", ".classpath", new SaveFileSelector.Callback(){

                public File[] getFilesCreatedForFileName(File file) {
                    return new File[]{file};
                }

                public void fileNameSelected(File file) {
                    NewClasspathDialog.this.save(file);
                }

                public void canceled() {
                }
            });
            saveFileSelector.openPopup();
        }
    }

    void cancel() {
        this.closePopup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(File file) {
        try {
            URI uRI = file.getParentFile().toURI();
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(false);
            XmlSerializer xmlSerializer = xmlPullParserFactory.newSerializer();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                xmlSerializer.setOutput((OutputStream)fileOutputStream, "UTF8");
                xmlSerializer.startDocument("UTF8", Boolean.TRUE);
                xmlSerializer.text("\n");
                xmlSerializer.startTag(null, "classpath");
                xmlSerializer.text("\n    ");
                xmlSerializer.startTag(null, "entriesToScan");
                this.writeEntries(xmlSerializer, uRI, this.entriesToScan);
                xmlSerializer.text("\n    ");
                xmlSerializer.endTag(null, "entriesToScan");
                xmlSerializer.text("\n    ");
                xmlSerializer.startTag(null, "entriesDependencies");
                this.writeEntries(xmlSerializer, uRI, this.entriesDependencies);
                xmlSerializer.text("\n    ");
                xmlSerializer.endTag(null, "entriesDependencies");
                xmlSerializer.text("\n");
                xmlSerializer.endTag(null, "classpath");
                xmlSerializer.endDocument();
            }
            finally {
                fileOutputStream.close();
            }
            this.callback.classpathCreated(file);
            this.closePopup();
        }
        catch (Exception exception) {
            Logger.getLogger(NewClasspathDialog.class.getName()).log(Level.SEVERE, "can't write classpath", exception);
        }
    }

    private void writeEntries(XmlSerializer xmlSerializer, URI uRI, SimpleChangableListModel<File> simpleChangableListModel) throws IOException {
        for (int i = 0; i < simpleChangableListModel.getNumEntries(); ++i) {
            URI uRI2 = ((File)simpleChangableListModel.getEntry(i)).toURI();
            xmlSerializer.text("\n        ");
            xmlSerializer.startTag(null, "entry");
            xmlSerializer.text(uRI.relativize(uRI2).getPath());
            xmlSerializer.endTag(null, "entry");
        }
    }

    private SimpleChangableListModel<File> createList(DialogLayout.Group group, DialogLayout.Group group2, DialogLayout.Group group3, DialogLayout.Group group4, String string) {
        final SimpleChangableListModel simpleChangableListModel = new SimpleChangableListModel();
        final ListBox listBox = new ListBox((ListModel)simpleChangableListModel);
        final Button button = new Button("Add Folder");
        final Button button2 = new Button("Add JAR");
        final Button button3 = new Button("Remove");
        listBox.addCallback((CallbackWithReason)new CallbackWithReason<ListBox.CallbackReason>(){

            public void callback(ListBox.CallbackReason callbackReason) {
                button3.setEnabled(listBox.getSelected() >= 0);
            }
        });
        button.addCallback(new Runnable(){

            public void run() {
                NewClasspathDialog.this.addFolder((SimpleChangableListModel<File>)simpleChangableListModel, button);
            }
        });
        button2.addCallback(new Runnable(){

            public void run() {
                NewClasspathDialog.this.addJAR((SimpleChangableListModel<File>)simpleChangableListModel, button2);
            }
        });
        button3.setEnabled(false);
        button3.addCallback(new Runnable(){

            public void run() {
                int n = listBox.getSelected();
                if (n >= 0) {
                    simpleChangableListModel.removeElement(n);
                }
            }
        });
        Label label = new Label(string);
        label.setTheme("title");
        DialogLayout.Group group5 = this.layout.createSequentialGroup().addWidget((Widget)button).addWidget((Widget)button2).addWidget((Widget)button3).addGap();
        DialogLayout.Group group6 = this.layout.createParallelGroup().addWidget((Widget)listBox).addGroup(group5);
        group.addWidget((Widget)label).addGroup(group6).addGap(-2);
        group2.addWidget((Widget)label);
        group3.addWidget((Widget)listBox);
        group4.addWidget((Widget)button).addWidget((Widget)button2).addWidget((Widget)button3);
        return simpleChangableListModel;
    }

    void addFolder(final SimpleChangableListModel<File> simpleChangableListModel, Button button) {
        int n;
        File file;
        FileSystemTreeModel.FolderNode folderNode;
        FileSystemTreeModel fileSystemTreeModel = new FileSystemTreeModel((FileSystemModel)JavaFileSystemModel.getInstance());
        fileSystemTreeModel.setSorter((Comparator)new FileSelector.NameSorter((FileSystemModel)JavaFileSystemModel.getInstance()));
        final TableSingleSelectionModel tableSingleSelectionModel = new TableSingleSelectionModel();
        final TreeTable treeTable = new TreeTable((TreeTableModel)fileSystemTreeModel);
        ScrollPane scrollPane = new ScrollPane((Widget)treeTable);
        SimpleDialog simpleDialog = new SimpleDialog();
        treeTable.setSelectionManager((TableSelectionManager)new TableRowSelectionManager((TableSelectionModel)tableSingleSelectionModel));
        treeTable.addCallback(new TableBase.Callback(){

            public void mouseDoubleClicked(int n, int n2) {
                if (n >= 0 && n < treeTable.getNumRows()) {
                    treeTable.setRowExpanded(n, true);
                }
            }

            public void mouseRightClick(int n, int n2, Event event) {
            }

            public void columnHeaderClicked(int n) {
            }
        });
        scrollPane.setExpandContentSize(true);
        scrollPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        simpleDialog.setTheme("selectfolder");
        simpleDialog.setMessage((Object)scrollPane);
        simpleDialog.setOkCallback(new Runnable(){

            public void run() {
                TreeTableNode treeTableNode;
                int n = tableSingleSelectionModel.getFirstSelected();
                if (n >= 0 && (treeTableNode = treeTable.getNodeFromRow(n)) instanceof FileSystemTreeModel.FolderNode) {
                    File file = (File)((FileSystemTreeModel.FolderNode)treeTableNode).getFolder();
                    NewClasspathDialog.this.prefs.put(NewClasspathDialog.PREF_LAST_FOLDER, file.toString());
                    simpleChangableListModel.addElement((Object)file);
                }
            }
        });
        simpleDialog.showDialog((Widget)button);
        String string = this.prefs.get(PREF_LAST_FOLDER, null);
        if (string != null && (folderNode = fileSystemTreeModel.getNodeForFolder((Object)(file = new File(string)))) != null && (n = treeTable.getRowFromNodeExpand((TreeTableNode)folderNode)) >= 0) {
            treeTable.scrollToRow(n);
            tableSingleSelectionModel.setSelection(n, n);
        }
    }

    void addJAR(final SimpleChangableListModel<File> simpleChangableListModel, Button button) {
        LoadFileSelector loadFileSelector = new LoadFileSelector((Widget)button, this.prefs, PREF_SELECT_JAR, "Java JAR archive", ".jar", new LoadFileSelector.Callback(){

            public void fileSelected(File file) {
                if (file.isFile() && file.canRead()) {
                    simpleChangableListModel.addElement((Object)file);
                }
            }

            public void canceled() {
            }
        });
        loadFileSelector.openPopup();
    }

    public static interface Callback {
        public void classpathCreated(File var1);
    }
}

