/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twlthemeeditor.Main;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;

public class NewProjectSettings {
    private final File folder;
    private final String projectName;
    private static final String BLUEPRINT_FILENAME = "new_project_blueprint.xml";
    private static final String[] FONT_FILENAMES = new String[]{"font.fnt", "font_00.png"};

    public NewProjectSettings(File file, String string) {
        this.folder = file;
        this.projectName = string;
    }

    public File getFolder() {
        return this.folder;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String toString() {
        return this.getFile(this.projectName).getPath();
    }

    public File[] getFileList() {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(this.getFile(this.projectName));
        for (String string : FONT_FILENAMES) {
            arrayList.add(this.getFile(string));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public File createProject() throws IOException {
        File file = this.getFile(this.projectName);
        this.copy(BLUEPRINT_FILENAME, file);
        for (String string : FONT_FILENAMES) {
            this.copy(string, this.getFile(string));
        }
        return file;
    }

    private File getFile(String string) {
        return new File(this.folder, string);
    }

    private URL getResource(String string) {
        return Main.class.getResource(string);
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(URL uRL, File file) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                NewProjectSettings.copy(inputStream, fileOutputStream);
            }
            finally {
                fileOutputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
    }

    private void copy(String string, File file) throws IOException {
        URL uRL = this.getResource(string);
        if (uRL == null) {
            throw new IOException("Can't locate resource: " + string);
        }
        NewProjectSettings.copy(uRL, file);
    }
}

