/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.DesktopArea;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.CacheContext;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLRenderer;
import de.matthiasmann.twl.theme.ThemeManager;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeLoadErrorTracker;
import de.matthiasmann.twlthemeeditor.gui.Context;
import de.matthiasmann.twlthemeeditor.gui.MainUI;
import de.matthiasmann.twlthemeeditor.gui.MessageLog;
import de.matthiasmann.twlthemeeditor.gui.TestWidgetContainer;
import de.matthiasmann.twlthemeeditor.gui.TestWidgetFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Util;
import org.xmlpull.v1.XmlPullParserException;

public class PreviewWidget
extends Widget {
    public static final AnimationState.StateKey STATE_FLASHING = AnimationState.StateKey.get((String)"flashing");
    private final MessageLog messageLog;
    private final IntBuffer viewPortBuffer;
    private Context ctx;
    private URL url;
    private LWJGLRenderer render;
    private ThemeManager theme;
    private GUI testGUI;
    private boolean reloadTheme;
    private boolean hadThemeLoadError;
    private TestWidgetFactory widgetFactory;
    private Widget testWidget;
    private Callback callback;
    private Image flashImage;
    private int flashX;
    private int flashY;
    private int flashWidth;
    private int flashHeight;
    private static final MessageLog.Category CAT_INIT = new MessageLog.Category("init renderer", MessageLog.CombineMode.REPLACE, 1);
    private static final MessageLog.Category CAT_WIDGET = new MessageLog.Category("creating widget", MessageLog.CombineMode.REPLACE, 1);
    private static final MessageLog.Category CAT_THEME = new MessageLog.Category("theme loading", MessageLog.CombineMode.REPLACE, 1);
    private static final MessageLog.Category CAT_EXECUTE = new MessageLog.Category("executing", MessageLog.CombineMode.REPLACE, 1);

    public PreviewWidget(MessageLog messageLog) {
        this.messageLog = messageLog;
        this.viewPortBuffer = BufferUtils.createIntBuffer((int)16);
        this.setCanAcceptKeyboardFocus(true);
        this.setClip(true);
    }

    public void setURL(Context context, URL uRL) {
        this.ctx = context;
        this.url = uRL;
        this.reloadTheme = true;
    }

    public void setWidgetFactory(TestWidgetFactory testWidgetFactory) {
        this.widgetFactory = testWidgetFactory;
        this.testWidget = null;
    }

    public Widget getTestWidget() {
        return this.testWidget;
    }

    public GUI getTestGUI() {
        return this.testGUI;
    }

    public void reloadTheme() {
        this.reloadTheme = true;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public Image getImage(String string) {
        return this.theme != null ? this.theme.getImageNoWarning(string) : null;
    }

    public void flashRectangle(int n, int n2, int n3, int n4, boolean bl) {
        this.flashX = n;
        this.flashY = n2;
        this.flashWidth = n3;
        this.flashHeight = n4;
        AnimationState animationState = this.getAnimationState();
        animationState.setAnimationState(STATE_FLASHING, bl);
        animationState.resetAnimationTime(STATE_FLASHING);
    }

    public Widget selectWidgetFromMouse(int n, int n2) {
        n -= this.getInnerX();
        n2 -= this.getInnerY();
        GUI gUI = this.testGUI;
        while (true) {
            Widget widget = null;
            int n3 = gUI.getNumChildren();
            while (n3-- > 0) {
                Widget widget2 = gUI.getChild(n3);
                if (!widget2.isVisible() || !PreviewWidget.testWidgetInside(widget2, n, n2) || PreviewWidget.isTooltipWindow(widget2)) continue;
                widget = widget2;
                break;
            }
            if (widget == null) {
                return gUI;
            }
            gUI = widget;
        }
    }

    private static boolean isTooltipWindow(Widget widget) {
        return "de.matthiasmann.twl.GUI$TooltipWindow".equals(widget.getClass().getName());
    }

    private static boolean testWidgetInside(Widget widget, int n, int n2) {
        return n >= widget.getX() && n2 >= widget.getY() && n < widget.getRight() && n2 < widget.getBottom();
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.flashImage = themeInfo.getImage("flashImage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintWidget(GUI gUI) {
        block10: {
            if ((this.reloadTheme || !this.hadThemeLoadError) && this.ctx != null) {
                this.ctx.installDebugHook();
                try {
                    GL11.glGetInteger((int)2978, (IntBuffer)this.viewPortBuffer);
                    int n = this.viewPortBuffer.get(1) + this.viewPortBuffer.get(3);
                    GL11.glViewport((int)(this.viewPortBuffer.get(0) + this.getInnerX()), (int)(n - (this.getInnerY() + this.getInnerHeight())), (int)this.getInnerWidth(), (int)this.getInnerHeight());
                    try {
                        this.executeTestEnv(gUI);
                        Util.checkGLError();
                    }
                    catch (Throwable throwable) {
                        try {
                            this.messageLog.add(new MessageLog.Entry(CAT_EXECUTE, "Exception while executing test widget", null, throwable, new MessageLog.EntryAction[0]));
                            break block10;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            GL11.glViewport((int)this.viewPortBuffer.get(0), (int)this.viewPortBuffer.get(1), (int)this.viewPortBuffer.get(2), (int)this.viewPortBuffer.get(3));
                        }
                    }
                    GL11.glViewport((int)this.viewPortBuffer.get(0), (int)this.viewPortBuffer.get(1), (int)this.viewPortBuffer.get(2), (int)this.viewPortBuffer.get(3));
                }
                finally {
                    this.ctx.uninstallDebugHook();
                }
            }
        }
        if (this.flashImage != null && this.flashWidth > 0 && this.flashHeight > 0) {
            this.flashImage.draw((de.matthiasmann.twl.renderer.AnimationState)this.getAnimationState(), this.getInnerX() + this.flashX, this.getInnerY() + this.flashY, this.flashWidth, this.flashHeight);
        }
    }

    private void executeTestEnv(GUI gUI) {
        TestWidgetContainer testWidgetContainer;
        if (this.render == null && !this.initRenderer()) {
            return;
        }
        this.render.syncViewportSize();
        if (this.testGUI == null) {
            testWidgetContainer = new TestWidgetContainer();
            this.testGUI = new GUI((Widget)testWidgetContainer, (Renderer)this.render);
            if (this.callback != null) {
                this.callback.testGUIChanged(this.testGUI);
            }
        }
        if ((this.theme == null || this.reloadTheme) && !this.loadTheme(gUI)) {
            return;
        }
        if (this.testWidget == null && this.widgetFactory != null) {
            this.testGUI.getRootPane().removeAllChildren();
            try {
                this.ctx.clearWidgetMessages();
                this.testWidget = this.widgetFactory.getOrCreate();
                this.testGUI.getRootPane().add(this.testWidget);
                if (this.testWidget instanceof DesktopArea || MainUI.class.getName().equals(this.testWidget.getClass().getName())) {
                    this.testWidget.setSize(this.getInnerWidth(), this.getInnerHeight());
                } else {
                    this.testWidget.adjustSize();
                }
            }
            catch (Throwable throwable) {
                this.messageLog.add(new MessageLog.Entry(CAT_WIDGET, "Exception while creating test widget", null, PreviewWidget.unwrap(throwable), new MessageLog.EntryAction[0]));
            }
            if (this.callback != null) {
                testWidgetContainer = this.testWidget;
                final Callback callback = this.callback;
                gUI.invokeLater(new Runnable((Widget)testWidgetContainer){
                    final /* synthetic */ Widget val$widget;
                    {
                        this.val$widget = widget;
                    }

                    public void run() {
                        callback.testWidgetChanged(this.val$widget);
                    }
                });
            }
        }
        this.testGUI.setSize();
        this.testGUI.updateTime();
        this.testGUI.updateTimers();
        this.testGUI.handleKeyRepeat();
        this.testGUI.handleTooltips();
        this.testGUI.invokeRunables();
        this.testGUI.validateLayout();
        this.testGUI.draw();
        this.testGUI.setCursor();
    }

    private static Throwable unwrap(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return throwable;
    }

    private boolean initRenderer() {
        assert (this.render == null);
        try {
            this.render = new LWJGLRenderer();
            this.render.setUseSWMouseCursors(true);
            return true;
        }
        catch (LWJGLException lWJGLException) {
            this.messageLog.add(new MessageLog.Entry(CAT_INIT, "Exception while creating renderer", null, lWJGLException, new MessageLog.EntryAction[0]));
            this.render = null;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadTheme(GUI gUI) {
        this.reloadTheme = false;
        this.hadThemeLoadError = false;
        if (this.url != null) {
            Object object;
            block7: {
                ThemeLoadErrorTracker themeLoadErrorTracker = new ThemeLoadErrorTracker();
                ThemeLoadErrorTracker.push(themeLoadErrorTracker);
                object = null;
                CacheContext cacheContext = this.render.getActiveCacheContext();
                CacheContext cacheContext2 = this.render.createNewCacheContext();
                try {
                    ThemeManager themeManager = ThemeManager.createThemeManager((URL)this.url, (Renderer)this.render, (CacheContext)cacheContext2);
                    this.testGUI.applyTheme(themeManager);
                    cacheContext.destroy();
                    if (this.theme != null) {
                        this.theme.destroy();
                    }
                    this.theme = themeManager;
                    this.testGUI.destroy();
                    this.messageLog.removeAll(CAT_THEME);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    this.hadThemeLoadError = true;
                    object = themeLoadErrorTracker.findErrorLocation();
                    this.render.setActiveCacheContext(cacheContext);
                    cacheContext2.destroy();
                    this.messageLog.add(new MessageLog.Entry(CAT_THEME, "Exception while loading theme", null, iOException.getCause() instanceof XmlPullParserException ? iOException.getCause() : iOException, new MessageLog.EntryAction[0]));
                }
                finally {
                    if (ThemeLoadErrorTracker.pop() == themeLoadErrorTracker) break block7;
                    throw new IllegalStateException("Wrong error tracker");
                }
            }
            this.fireErrorLocationChanged(gUI, object);
        }
        return false;
    }

    private void fireErrorLocationChanged(GUI gUI, final Object object) {
        if (this.callback != null) {
            final Callback callback = this.callback;
            gUI.invokeLater(new Runnable(){

                public void run() {
                    callback.errorLocationChanged(object);
                }
            });
        }
    }

    protected boolean handleEvent(Event event) {
        if (this.testGUI != null) {
            boolean bl = false;
            try {
                switch (event.getType()) {
                    case MOUSE_MOVED: 
                    case MOUSE_DRAGGED: 
                    case MOUSE_ENTERED: 
                    case MOUSE_EXITED: {
                        bl = true;
                        this.testGUI.handleMouse(event.getMouseX() - this.getInnerX(), event.getMouseY() - this.getInnerY(), -1, false);
                        break;
                    }
                    case MOUSE_BTNDOWN: 
                    case MOUSE_BTNUP: {
                        bl = true;
                        this.testGUI.handleMouse(event.getMouseX() - this.getInnerX(), event.getMouseY() - this.getInnerY(), event.getMouseButton(), event.getType() == Event.Type.MOUSE_BTNDOWN);
                        break;
                    }
                    case MOUSE_WHEEL: {
                        bl = true;
                        this.testGUI.handleMouseWheel(event.getMouseWheelDelta());
                        break;
                    }
                    case KEY_PRESSED: 
                    case KEY_RELEASED: {
                        if (event.getKeyCode() == 63) break;
                        bl = true;
                        this.testGUI.handleKey(this.translateKeyCode(event.getKeyCode()), event.getKeyChar(), event.getType() == Event.Type.KEY_PRESSED);
                    }
                }
            }
            catch (Throwable throwable) {
                this.messageLog.add(new MessageLog.Entry(CAT_EXECUTE, "Exception while handling events", null, throwable, new MessageLog.EntryAction[0]));
            }
            return bl;
        }
        return super.handleEvent(event);
    }

    protected int translateKeyCode(int n) {
        if (n == 64) {
            return 15;
        }
        return n;
    }

    public static interface Callback {
        public void testWidgetChanged(Widget var1);

        public void errorLocationChanged(Object var1);

        public void testGUIChanged(GUI var1);
    }
}

