/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ProgressBar;
import de.matthiasmann.twl.Widget;

public class ProgressDialog
extends PopupWindow {
    final Label titleLabel = new Label(" ");
    final Label messageLabel;
    final ProgressBar progressBar;

    public ProgressDialog(Widget widget) {
        super(widget);
        this.titleLabel.setTheme("title");
        this.messageLabel = new Label(" ");
        this.messageLabel.setTheme("message");
        this.progressBar = new ProgressBar();
        this.progressBar.setClip(true);
        DialogLayout dialogLayout = new DialogLayout();
        dialogLayout.setHorizontalGroup(dialogLayout.createParallelGroup(new Widget[]{this.titleLabel, this.messageLabel, this.progressBar}));
        dialogLayout.setVerticalGroup(dialogLayout.createSequentialGroup().addWidget((Widget)this.titleLabel).addGap("title-message").addWidget((Widget)this.messageLabel).addGap("message-progressbar").addWidget((Widget)this.progressBar));
        this.add((Widget)dialogLayout);
        this.setCloseOnEscape(false);
        this.setCloseOnClickedOutside(false);
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
    }

    public void setMessage(final String string) {
        this.invokeLater(new Runnable(){

            public void run() {
                ProgressDialog.this.messageLabel.setText(string);
            }
        });
    }

    public void setIndeterminate(final String string) {
        this.invokeLater(new Runnable(){

            public void run() {
                ProgressDialog.this.progressBar.setText(string);
                ProgressDialog.this.progressBar.setIndeterminate();
            }
        });
    }

    public void setProgress(final String string, final float f) {
        this.invokeLater(new Runnable(){

            public void run() {
                ProgressDialog.this.progressBar.setText(string);
                ProgressDialog.this.progressBar.setValue(f);
            }
        });
    }

    private void invokeLater(Runnable runnable) {
        GUI gUI = this.getGUI();
        if (gUI != null) {
            gUI.invokeLater(runnable);
        }
    }
}

