/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.Property;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAccessor<T, P extends Property<T>> {
    private final P property;
    private final BooleanModel activeModel;
    private T value;
    private Widget[] widgetsToEnable;
    private Runnable focusWidgetCB;

    public PropertyAccessor(P p, BooleanModel booleanModel) {
        this.property = p;
        this.activeModel = booleanModel;
        this.value = p.getPropertyValue();
        if (booleanModel != null) {
            booleanModel.setValue(this.value != null);
            booleanModel.addCallback(new Runnable(){

                public void run() {
                    PropertyAccessor.this.setPropertyValue();
                    PropertyAccessor.this.syncWithActive();
                }
            });
        }
    }

    public void setWidgetsToEnable(Widget ... widgetArray) {
        this.widgetsToEnable = widgetArray;
        this.syncWithActive();
    }

    public void setFocusWidgetCB(Runnable runnable) {
        this.focusWidgetCB = runnable;
    }

    public void focusWidget() {
        if (this.focusWidgetCB != null) {
            this.focusWidgetCB.run();
        }
    }

    public boolean isActive() {
        return this.activeModel == null || this.activeModel.getValue();
    }

    public void addActiveCallback(Runnable runnable) {
        if (this.activeModel != null) {
            this.activeModel.addCallback(runnable);
        }
    }

    public T getValue(T t) {
        Object object = this.property.getPropertyValue();
        if (this.activeModel != null) {
            this.activeModel.setValue(object != null);
        }
        if (object != null) {
            this.value = object;
        }
        return this.value != null ? this.value : t;
    }

    public void setValue(T t) {
        this.value = t;
        this.setPropertyValue();
    }

    public String getDisplayName() {
        return this.property.getName();
    }

    public P getProperty() {
        return this.property;
    }

    void setPropertyValue() {
        try {
            Object var1_1;
            Object v0 = var1_1 = this.isActive() ? this.value : null;
            if (var1_1 != null || this.property.canBeNull()) {
                this.property.setPropertyValue(var1_1);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(PropertyAccessor.class.getName()).log(Level.SEVERE, "Could not set property value", exception);
        }
    }

    void syncWithActive() {
        if (this.widgetsToEnable != null) {
            boolean bl = this.isActive();
            for (Widget widget : this.widgetsToEnable) {
                widget.setEnabled(bl);
            }
        }
    }
}

