/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.KeyStroke;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.utils.TypeMapping;
import de.matthiasmann.twlthemeeditor.datamodel.IntegerFormula;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.BooleanEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.BorderEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.ColorEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.DimensionEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.EnumEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.FloatEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.GapEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.HotSpotEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.IntegerEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.IntegerFormulaEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.KeyStrokeEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.NameEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.RectEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.SplitEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.StringEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.editors.WeightsEditorFactory;
import de.matthiasmann.twlthemeeditor.properties.BorderProperty;
import de.matthiasmann.twlthemeeditor.properties.DimensionProperty;
import de.matthiasmann.twlthemeeditor.properties.GapProperty;
import de.matthiasmann.twlthemeeditor.properties.HotSpotProperty;
import de.matthiasmann.twlthemeeditor.properties.NameProperty;
import de.matthiasmann.twlthemeeditor.properties.RectProperty;
import de.matthiasmann.twlthemeeditor.properties.SplitProperty;
import de.matthiasmann.twlthemeeditor.properties.WeightsProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFactories {
    protected final TypeMapping<PropertyEditorFactory<?, ?>> factories1 = new TypeMapping();
    protected final TypeMapping<PropertyEditorFactory<?, ?>> factories2;

    public PropertyFactories() {
        this.factories1.put(RectProperty.class, (Object)new RectEditorFactory());
        this.factories1.put(WeightsProperty.class, (Object)new WeightsEditorFactory());
        this.factories1.put(SplitProperty.class, (Object)new SplitEditorFactory());
        this.factories1.put(GapProperty.class, (Object)new GapEditorFactory());
        this.factories1.put(DimensionProperty.class, (Object)new DimensionEditorFactory());
        this.factories1.put(HotSpotProperty.class, (Object)new HotSpotEditorFactory());
        this.factories1.put(BorderProperty.class, (Object)new BorderEditorFactory());
        this.factories1.put(NameProperty.class, (Object)new NameEditorFactory());
        this.factories2 = new TypeMapping();
        this.factories2.put(Color.class, (Object)new ColorEditorFactory());
        this.factories2.put(String.class, (Object)new StringEditorFactory());
        this.factories2.put(Integer.class, (Object)new IntegerEditorFactory());
        this.factories2.put(IntegerFormula.class, (Object)new IntegerFormulaEditorFactory());
        this.factories2.put(Float.class, (Object)new FloatEditorFactory());
        this.factories2.put(Boolean.class, (Object)new BooleanEditorFactory());
        this.factories2.put(Enum.class, new EnumEditorFactory());
        this.factories2.put(KeyStroke.class, (Object)new KeyStrokeEditorFactory());
    }

    public PropertyEditorFactory<?, ?> getFactory(Property<?> property) {
        PropertyEditorFactory propertyEditorFactory = (PropertyEditorFactory)this.factories1.get(property.getClass());
        if (propertyEditorFactory == null) {
            propertyEditorFactory = (PropertyEditorFactory)this.factories2.get(property.getType());
        }
        return propertyEditorFactory;
    }
}

